/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.container;

import com.sun.star.io.XInputStream;
import com.sun.star.script.framework.container.Parcel;
import com.sun.star.script.framework.container.ScriptEntry;
import com.sun.star.script.framework.io.UCBStreamHandler;
import com.sun.star.script.framework.io.XInputStreamImpl;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.PathUtils;
import com.sun.star.ucb.XSimpleFileAccess2;
import com.sun.star.uno.UnoRuntime;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

public class ScriptMetaData
extends ScriptEntry
implements Cloneable {
    private boolean hasSource = false;
    private String locationPlaceHolder = "";
    private String source;
    private Parcel parent;
    private static final String SHARE = "vnd.sun.star.expand:${$SYSBINDIR/" + PathUtils.BOOTSTRAP_NAME + "::BaseInstallation}/share";
    private static final String USER = "vnd.sun.star.expand:${$SYSBINDIR/" + PathUtils.BOOTSTRAP_NAME + "::UserInstallation}/user";
    private static final String UNO_USER_PACKAGES1 = "vnd.sun.star.expand:$UNO_USER_PACKAGES_CACHE";
    private static final String UNO_USER_PACKAGES2 = USER + "/uno_packages";
    private static final String UNO_SHARED_PACKAGES1 = "$UNO_SHARED_PACKAGES_CACHE";
    private static final String UNO_SHARED_PACKAGES2 = SHARE + "/uno_packages";

    public ScriptMetaData(Parcel parcel, ScriptEntry scriptEntry, String string) {
        super(scriptEntry);
        this.parent = parcel;
        if (string != null) {
            this.hasSource = true;
            this.source = string;
        }
    }

    public boolean hasSource() {
        return this.hasSource;
    }

    public String getSource() {
        if (this.source != null && this.hasSource) {
            return this.source;
        }
        return null;
    }

    public byte[] getSourceBytes() {
        if (this.source != null && this.hasSource) {
            return this.source.getBytes();
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(ScriptMetaData scriptMetaData) {
        return super.equals(scriptMetaData) && this.hasSource == scriptMetaData.hasSource();
    }

    public String getScriptFullURL() {
        String string = "vnd.sun.star.script:" + this.parent.getName() + "." + this.getLanguageName() + "?" + "language=" + this.getLanguage() + "&location=" + this.getParcelLocation();
        return string;
    }

    public String getShortFormScriptURL() {
        String string = "vnd.sun.star.script:" + this.parent.getName() + "." + this.getLanguageName() + "?" + "language=" + this.getLanguage() + "&location=" + this.getLocationPlaceHolder();
        return string;
    }

    public static String getLocationPlaceHolder(String string, String string2) {
        String string3 = "Unknown";
        if (string.indexOf(UNO_USER_PACKAGES1) > -1 || string.indexOf(UNO_USER_PACKAGES2) > -1) {
            string3 = PathUtils.make_url("user:uno_packages", string2);
        } else if (string.indexOf(UNO_SHARED_PACKAGES1) > -1 || string.indexOf(UNO_SHARED_PACKAGES2) > -1) {
            string3 = PathUtils.make_url("share:uno_packages", string2);
        } else if (string.indexOf(SHARE) == 0) {
            string3 = "share";
        } else if (string.indexOf(USER) == 0) {
            string3 = "user";
        } else if (string.indexOf("vnd.sun.star.tdoc:") == 0) {
            string3 = "document";
        }
        return string3;
    }

    public String getLocationPlaceHolder() {
        String string = "Unknown";
        String string2 = this.parent.getPathToParcel();
        if (string2.indexOf(UNO_USER_PACKAGES1) > -1 || string2.indexOf(UNO_USER_PACKAGES2) > -1) {
            string = "user:uno_packages";
            String string3 = this.parent.parent.getName();
            if (string3 != null) {
                string = PathUtils.make_url(string, string3);
            }
        } else if (string2.indexOf(UNO_SHARED_PACKAGES1) > -1 || string2.indexOf(UNO_SHARED_PACKAGES2) > -1) {
            string = "share:uno_packages";
            String string4 = this.parent.parent.getName();
            if (string4 != null) {
                string = PathUtils.make_url(string, string4);
            }
        } else if (string2.indexOf(SHARE) == 0) {
            string = "share";
        } else if (string2.indexOf(USER) == 0) {
            string = "user";
        } else if (string2.indexOf("vnd.sun.star.tdoc:") == 0) {
            string = "document";
        }
        return string;
    }

    public String getParcelLocation() {
        return this.parent.getPathToParcel();
    }

    public String toString() {
        return "\nParcelLocation = " + this.getParcelLocation() + "\nLocationPlaceHolder = " + this.locationPlaceHolder + super.toString();
    }

    public URL[] getClassPath() throws MalformedURLException {
        try {
            Object object;
            String string;
            String string2 = (String)this.getLanguageProperties().get("classpath");
            Object var2_3 = null;
            if (string2 == null) {
                string2 = "";
            }
            if (!(string = this.getParcelLocation()).endsWith("/")) {
                string = string + "/";
            }
            string = string.replace('\\', '/');
            Vector<Object> vector = new Vector<Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            while (stringTokenizer.hasMoreElements()) {
                object = (String)stringTokenizer.nextElement();
                String string3 = PathUtils.make_url(string, (String)object);
                URL uRL = this.createURL(string3);
                if (uRL == null) continue;
                vector.add(uRL);
            }
            if (vector.size() == 0 && (object = this.createURL(string)) != null) {
                vector.add(object);
            }
            return vector.toArray(new URL[0]);
        }
        catch (Exception exception) {
            LogUtils.DEBUG("Failed to build class path " + exception.toString());
            LogUtils.DEBUG(LogUtils.getTrace(exception));
            return new URL[0];
        }
    }

    private URL createURL(String string) throws MalformedURLException {
        URL uRL = null;
        int n = string.indexOf(":");
        String string2 = string.substring(0, n);
        UCBStreamHandler uCBStreamHandler = new UCBStreamHandler(this.parent.parent.m_xCtx, string2, this.parent.m_xSFA);
        string = string + "/ucb/";
        uRL = new URL(null, string, uCBStreamHandler);
        return uRL;
    }

    public void loadSource() {
        block5: {
            try {
                URL uRL = this.getSourceURL();
                LogUtils.DEBUG("** In load source BUT not loading yet for " + uRL);
                if (uRL == null) break block5;
                StringBuffer stringBuffer = new StringBuffer();
                InputStream inputStream = uRL.openStream();
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = inputStream.read(byArray, 0, 1024)) != -1) {
                    stringBuffer.append(new String(byArray, 0, n));
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LogUtils.DEBUG("** Failed to read scriot from url " + iOException.toString());
                }
                this.source = stringBuffer.toString();
                this.hasSource = true;
            }
            catch (IOException iOException) {
                LogUtils.DEBUG("** Failed to read scriot from url " + iOException.toString());
            }
        }
    }

    protected boolean writeSourceFile() {
        String string = this.parent.getPathToParcel();
        String string2 = this.parent.getPathToParcel() + "/" + this.getLanguageName();
        boolean bl = false;
        Object var4_4 = null;
        try {
            XSimpleFileAccess2 xSimpleFileAccess2 = (XSimpleFileAccess2)UnoRuntime.queryInterface((Class)XSimpleFileAccess2.class, (Object)this.parent.m_xSFA);
            if (xSimpleFileAccess2 != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getSourceBytes());
                XInputStreamImpl xInputStreamImpl = new XInputStreamImpl(byteArrayInputStream);
                xSimpleFileAccess2.writeFile(string2, (XInputStream)xInputStreamImpl);
                xInputStreamImpl.closeInput();
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    protected boolean removeSourceFile() {
        String string = this.parent.getPathToParcel();
        String string2 = string + "/" + this.getLanguageName();
        boolean bl = false;
        try {
            this.parent.m_xSFA.kill(string2);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public URL getSourceURL() throws MalformedURLException {
        String string = null;
        URL uRL = null;
        string = this.getParcelLocation();
        string = PathUtils.make_url(string, this.getLanguageName());
        LogUtils.DEBUG("Creating script url for " + string);
        uRL = this.createURL(string);
        return uRL;
    }
}

