/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Locale;
import org.hsqldb.Column;
import org.hsqldb.DITypeInfo;
import org.hsqldb.Table;
import org.hsqldb.Types;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.store.ValuePool;

final class DITableInfo {
    int bestRowTemporary = 0;
    int bestRowTransaction = 1;
    int bestRowSession = 2;
    int bestRowUnknown = 0;
    int bestRowNotPseudo = 1;
    static final short tableIndexOther = 3;
    private static final int HALF_MAX_INT = 0x3FFFFFFF;
    private int hnd_column_remarks = -1;
    private int hnd_table_remarks = -1;
    private Table table;
    private static final DITypeInfo ti = new DITypeInfo();

    DITableInfo() {
        this.setLocale(Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLocale(Locale locale) {
        Class clazz = BundleHandler.class;
        synchronized (clazz) {
            Locale locale2 = BundleHandler.getLocale();
            BundleHandler.setLocale(locale);
            this.hnd_column_remarks = BundleHandler.getBundleHandle("column-remarks", null);
            this.hnd_table_remarks = BundleHandler.getBundleHandle("table-remarks", null);
            BundleHandler.setLocale(locale2);
        }
    }

    Integer getBRIPseudo() {
        return ValuePool.getInt(this.bestRowNotPseudo);
    }

    Integer getBRIScope() {
        return this.table.isWritable() ? ValuePool.getInt(this.bestRowTemporary) : ValuePool.getInt(this.bestRowSession);
    }

    Integer getColBufLen(int n) {
        int n2;
        Column column = this.table.getColumn(n);
        int n3 = column.getDIType();
        switch (n3) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                n2 = column.getSize();
                if (n2 == 0) break;
                if (n2 > 0x3FFFFFFF) {
                    n2 = 0;
                    break;
                }
                n2 = 2 * n2;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                n2 = column.getSize();
                break;
            }
            case -5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: {
                n2 = 8;
                break;
            }
            case 93: {
                n2 = 12;
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                n2 = 4;
                break;
            }
            case 16: {
                n2 = 1;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2 > 0 ? ValuePool.getInt(n2) : null;
    }

    Integer getColCharOctLen(int n) {
        int n2;
        Column column = this.table.getColumn(n);
        int n3 = column.getDIType();
        switch (n3) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                n2 = column.getSize();
                if (n2 == 0) break;
                if (n2 > 0x3FFFFFFF) {
                    n2 = 0;
                    break;
                }
                n2 = 2 * n2;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2 == 0 ? null : ValuePool.getInt(n2);
    }

    Integer getColDataType(int n) {
        return ValuePool.getInt(this.table.getColumn(n).getDIType());
    }

    String getColDataTypeName(int n) {
        Column column = this.table.getColumn(n);
        ti.setTypeCode(column.getDIType());
        ti.setTypeSub(column.getDITypeSub());
        return ti.getTypeName();
    }

    Integer getColDataTypeSub(int n) {
        return ValuePool.getInt(this.table.getColumn(n).getDITypeSub());
    }

    String getColDefault(int n) {
        return this.table.getColumn(n).getDefaultDDL();
    }

    Boolean getColIsIdentity(int n) {
        return ValuePool.getBoolean(this.table.getColumn(n).isIdentity());
    }

    String getColIsNullable(int n) {
        Column column = this.table.getColumn(n);
        return column.isNullable() && !column.isIdentity() ? "YES" : "NO";
    }

    String getColName(int n) {
        return this.table.getColumn((int)n).columnName.name;
    }

    Integer getColNullability(int n) {
        Column column = this.table.getColumn(n);
        return column.isNullable() && !column.isIdentity() ? ValuePool.getInt(1) : ValuePool.getInt(0);
    }

    Integer getColPrecRadix(int n) {
        ti.setTypeCode(this.table.getColumn(n).getDIType());
        return ti.getNumPrecRadix();
    }

    String getColRemarks(int n) {
        if (this.table.getTableType() != 0) {
            return null;
        }
        String string = this.getName() + "_" + this.getColName(n);
        return BundleHandler.getString(this.hnd_column_remarks, string);
    }

    Integer getColScale(int n) {
        Column column = this.table.getColumn(n);
        int n2 = column.getDIType();
        return Types.acceptsScaleCreateParam(n2) ? ValuePool.getInt(column.getScale()) : null;
    }

    String getColScopeCat(int n) {
        return null;
    }

    String getColScopeSchem(int n) {
        return null;
    }

    String getColScopeTable(int n) {
        return null;
    }

    Integer getColSize(int n) {
        Column column = this.table.getColumn(n);
        int n2 = column.getDIType();
        if (!Types.acceptsPrecisionCreateParam(n2)) {
            return null;
        }
        int n3 = column.getSize();
        if (n3 > 0) {
            return ValuePool.getInt(n3);
        }
        ti.setTypeCode(n2);
        return ti.getPrecision();
    }

    Integer getColSqlDataType(int n) {
        ti.setTypeCode(this.table.getColumn(n).getDIType());
        return ti.getSqlDataType();
    }

    Integer getColSqlDateTimeSub(int n) {
        ti.setTypeCode(this.table.getColumn(n).getDIType());
        return ti.getSqlDateTimeSub();
    }

    String getDataSource() {
        return this.table.getDataSource();
    }

    String getHsqlType() {
        switch (this.table.getTableType()) {
            case 0: 
            case 2: 
            case 3: {
                return "MEMORY";
            }
            case 4: {
                return "CACHED";
            }
            case 5: 
            case 6: {
                return "TEXT";
            }
        }
        return null;
    }

    Integer getIndexCardinality(int n) {
        return null;
    }

    String getIndexColDirection(int n, int n2) {
        return "A";
    }

    int[] getIndexColumns(int n) {
        return this.table.getIndex(n).getColumns();
    }

    String getIndexName(int n) {
        return this.table.getIndex((int)n).getName().name;
    }

    Integer getIndexRowCardinality(int n) {
        return null;
    }

    Integer getIndexType(int n) {
        return ValuePool.getInt(3);
    }

    int getIndexVisibleColumns(int n) {
        return this.table.getIndex(n).getVisibleColumns();
    }

    String getName() {
        return this.table.getName().name;
    }

    Long getNextIdentity() {
        if (this.table.identityColumn < 0) {
            return null;
        }
        return ValuePool.getLong(this.table.identitySequence.peek());
    }

    String getRemark() {
        return this.table.getTableType() == 0 ? BundleHandler.getString(this.hnd_table_remarks, this.getName()) : null;
    }

    String getStandardType() {
        switch (this.table.getTableType()) {
            case 7: {
                return "VIEW";
            }
            case 2: 
            case 5: {
                return "GLOBAL TEMPORARY";
            }
            case 0: {
                return "SYSTEM TABLE";
            }
        }
        return "TABLE";
    }

    Table getTable() {
        return this.table;
    }

    Boolean isDataSourceDescending() {
        return ValuePool.getBoolean(this.table.isDescDataSource());
    }

    Boolean isIndexNonUnique(int n) {
        return ValuePool.getBoolean(!this.table.getIndex(n).isUnique());
    }

    Boolean isReadOnly() {
        return ValuePool.getBoolean(this.table.isDataReadOnly());
    }

    void setTable(Table table) {
        this.table = table;
    }
}

