/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import [Ljava.lang.Character;;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.DINameSpace;
import org.hsqldb.HsqlException;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Binary;

final class DIProcedureInfo {
    static final String conClsName = "java.sql.Connection";
    static final int procedureResultUnknown = 0;
    static final int procedureNoResult = 1;
    static final int procedureReturnsResult = 2;
    static final int procedureColumnUnknown = 0;
    static final int procedureColumnIn = 1;
    static final int procedureColumnInOut = 2;
    static final int procedureColumnResult = 3;
    static final int procedureColumnOut = 4;
    static final int procedureColumnReturn = 5;
    static final int procedureNoNulls = 0;
    static final int procedureNullable = 1;
    static final int procedureNullableUnknown = 2;
    private Class clazz;
    private Class[] colClasses;
    private int[] colTypes;
    private int colOffset;
    private int colCount;
    private boolean colsResolved;
    private String fqn;
    private String specificName;
    private int hnd_remarks;
    private Method method;
    private String sig;
    private DINameSpace nameSpace;
    private final HashMap typeMap = new HashMap();

    public DIProcedureInfo(DINameSpace dINameSpace) throws HsqlException {
        this.setNameSpace(dINameSpace);
    }

    private int colOffset() {
        if (!this.colsResolved) {
            this.resolveCols();
        }
        return this.colOffset;
    }

    HsqlArrayList getAliases() {
        return (HsqlArrayList)this.nameSpace.getInverseAliasMap().get(this.getFQN());
    }

    Class getColClass(int n) {
        return this.colClasses[n + this.colOffset()];
    }

    int getColCount() {
        if (!this.colsResolved) {
            this.resolveCols();
        }
        return this.colCount;
    }

    Integer getColDataType(int n) {
        return ValuePool.getInt(this.getColTypeCode(n));
    }

    Integer getColLen(int n) {
        int n2;
        int n3 = this.getColTypeCode(n);
        switch (n3) {
            case -4: 
            case -3: 
            case -2: {
                n2 = Integer.MAX_VALUE;
                break;
            }
            case -5: 
            case 6: 
            case 8: 
            case 91: 
            case 92: {
                n2 = 8;
                break;
            }
            case 93: {
                n2 = 12;
                break;
            }
            case 4: 
            case 7: {
                n2 = 4;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
            case -6: 
            case 16: {
                n2 = 1;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2 == 0 ? null : ValuePool.getInt(n2);
    }

    String getColName(int n) {
        return "@p" + (n + this.colOffset());
    }

    Integer getColNullability(int n) {
        int n2 = this.getColClass(n).isPrimitive() ? 0 : 1;
        return ValuePool.getInt(n2);
    }

    String getColRemark(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.getSignature());
        String string = stringBuffer.append('@').append(n + this.colOffset()).toString();
        return BundleHandler.getString(this.hnd_remarks, string);
    }

    int getColSequence(int n) {
        return n + this.colOffset() == 0 ? this.colCount : n;
    }

    int getColTypeCode(int n) {
        return this.colTypes[n += this.colOffset()];
    }

    Integer getColUsage(int n) {
        switch (n + this.colOffset()) {
            case 0: {
                return ValuePool.getInt(3);
            }
        }
        return ValuePool.getInt(1);
    }

    Class getDeclaringClass() {
        return this.clazz;
    }

    String getFQN() {
        if (this.fqn == null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.fqn = stringBuffer.append(this.clazz.getName()).append('.').append(this.method.getName()).toString();
        }
        return this.fqn;
    }

    String getSpecificName() {
        if (this.specificName == null) {
            this.specificName = this.clazz.getName() + "." + this.getSignature();
        }
        return this.specificName;
    }

    Integer getInputParmCount() {
        return ValuePool.getInt(this.method.getParameterTypes().length);
    }

    Method getMethod() {
        return this.method;
    }

    String getOrigin(String string) {
        return (this.nameSpace.isBuiltin(this.clazz) ? "BUILTIN " : "USER DEFINED ") + string;
    }

    Integer getOutputParmCount() {
        return ValuePool.getInt(0);
    }

    String getRemark() {
        return BundleHandler.getString(this.hnd_remarks, this.getSignature());
    }

    Integer getResultSetCount() {
        return this.method.getReturnType() == Void.TYPE ? ValuePool.getInt(0) : ValuePool.getInt(1);
    }

    Integer getResultType(String string) {
        int n = !"ROUTINE".equals(string) ? 0 : (this.method.getReturnType() == Void.TYPE ? 1 : 2);
        return ValuePool.getInt(n);
    }

    String getSignature() {
        if (this.sig == null) {
            this.sig = DINameSpace.getSignature(this.method);
        }
        return this.sig;
    }

    static String getMethodSpecificName(Method method) {
        return method == null ? null : method.getDeclaringClass().getName() + '.' + DINameSpace.getSignature(method);
    }

    DINameSpace getNameSpace() {
        return this.nameSpace;
    }

    void setNameSpace(DINameSpace dINameSpace) throws HsqlException {
        Class clazz;
        this.nameSpace = dINameSpace;
        try {
            clazz = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcArray");
            this.typeMap.put(clazz, ValuePool.getInt(2003));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Integer n = ValuePool.getInt(-5);
        this.typeMap.put(Long.TYPE, n);
        this.typeMap.put(Long.class, n);
        n = ValuePool.getInt(16);
        this.typeMap.put(Boolean.TYPE, n);
        this.typeMap.put(Boolean.class, n);
        n = ValuePool.getInt(2004);
        try {
            clazz = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcBlob");
            this.typeMap.put(clazz, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = ValuePool.getInt(1);
        this.typeMap.put(Character.TYPE, n);
        this.typeMap.put(Character.class, n);
        this.typeMap.put(Character;.class, n);
        this.typeMap.put([C.class, n);
        n = ValuePool.getInt(2005);
        try {
            clazz = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcClob");
            this.typeMap.put(clazz, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = ValuePool.getInt(70);
        this.typeMap.put(URL.class, n);
        n = ValuePool.getInt(91);
        this.typeMap.put(java.util.Date.class, n);
        this.typeMap.put(Date.class, n);
        n = ValuePool.getInt(3);
        try {
            clazz = this.nameSpace.classForName("java.math.BigDecimal");
            this.typeMap.put(clazz, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcDistinct");
            this.typeMap.put(clazz, ValuePool.getInt(2001));
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = ValuePool.getInt(8);
        this.typeMap.put(Double.TYPE, n);
        this.typeMap.put(Double.class, n);
        n = ValuePool.getInt(6);
        this.typeMap.put(Float.TYPE, n);
        this.typeMap.put(Float.class, n);
        n = ValuePool.getInt(4);
        this.typeMap.put(Integer.TYPE, n);
        this.typeMap.put(Integer.class, n);
        n = ValuePool.getInt(2000);
        this.typeMap.put(Object.class, n);
        n = ValuePool.getInt(-4);
        this.typeMap.put([B.class, n);
        this.typeMap.put(Binary.class, n);
        n = ValuePool.getInt(-1);
        this.typeMap.put(String.class, n);
        n = ValuePool.getInt(0);
        this.typeMap.put(Void.TYPE, n);
        this.typeMap.put(Void.class, n);
        n = ValuePool.getInt(2006);
        try {
            clazz = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcRef");
            this.typeMap.put(clazz, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = ValuePool.getInt(5);
        this.typeMap.put(Short.TYPE, n);
        this.typeMap.put(Short.class, n);
        n = ValuePool.getInt(2002);
        try {
            clazz = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcStruct");
            this.typeMap.put(clazz, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = ValuePool.getInt(92);
        this.typeMap.put(Time.class, n);
        n = ValuePool.getInt(93);
        this.typeMap.put(Timestamp.class, n);
        n = ValuePool.getInt(-6);
        this.typeMap.put(Byte.TYPE, n);
        this.typeMap.put(Byte.class, n);
        n = ValuePool.getInt(137);
        try {
            clazz = this.nameSpace.classForName("org.w3c.dom.Document");
            this.typeMap.put(clazz, n);
            clazz = this.nameSpace.classForName("org.w3c.dom.DocumentFragment");
            this.typeMap.put(clazz, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void resolveCols() {
        Class<?> clazz = this.method.getReturnType();
        Class<?>[] classArray = this.method.getParameterTypes();
        int n = classArray.length;
        boolean bl = n > 0 && classArray[0].getName().equals(conClsName);
        int n2 = 1 + n - (bl ? 1 : 0);
        this.colClasses = new Class[n2];
        this.colTypes = new int[n2];
        this.colClasses[0] = clazz;
        this.colTypes[0] = this.typeForClass(clazz);
        int n3 = bl ? 1 : 0;
        int n4 = 1;
        while (n3 < n) {
            Class<?> clazz2;
            this.colClasses[n4] = clazz2 = classArray[n3];
            this.colTypes[n4] = this.typeForClass(clazz2);
            ++n3;
            ++n4;
        }
        this.colOffset = clazz == Void.TYPE ? 1 : 0;
        this.colCount = n2 - this.colOffset;
    }

    void setMethod(Method method) {
        this.method = method;
        this.clazz = this.method.getDeclaringClass();
        this.fqn = null;
        this.specificName = null;
        this.sig = null;
        this.colsResolved = false;
        String string = this.clazz.getName().replace('.', '_');
        this.hnd_remarks = BundleHandler.getBundleHandle(string, null);
    }

    int typeForClass(Class clazz) {
        Class<?> clazz2;
        Integer n = (Integer)this.typeMap.get(clazz);
        if (n != null) {
            return n;
        }
        if (clazz.isArray() && !clazz.getComponentType().isArray()) {
            return 2003;
        }
        try {
            clazz2 = Class.forName("java.sql.Array");
            if (clazz2.isAssignableFrom(clazz)) {
                return 2003;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return 2;
        }
        try {
            clazz2 = Class.forName("java.sql.Timestamp");
            if (clazz2.isAssignableFrom(clazz)) {
                return 93;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz2 = Class.forName("java.sql.Time");
            if (clazz2.isAssignableFrom(clazz)) {
                return 93;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz2 = Class.forName("java.sql.Date");
            if (clazz2.isAssignableFrom(clazz)) {
                return 91;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz2 = Class.forName("java.sql.Blob");
            if (clazz2.isAssignableFrom(clazz)) {
                return 2004;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz2 = Class.forName("java.sql.Clob");
            if (clazz2.isAssignableFrom(clazz)) {
                return 2005;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz2 = Class.forName("java.sql.Ref");
            if (clazz2.isAssignableFrom(clazz)) {
                return 2006;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz2 = Class.forName("java.sql.Struct");
            if (clazz2.isAssignableFrom(clazz)) {
                return 2002;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Binary.class.isAssignableFrom(clazz)) {
            return -4;
        }
        try {
            clazz2 = Class.forName("java.lang.CharSequence");
            if (clazz2.isAssignableFrom(clazz)) {
                return -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            return 1111;
        }
        return 2000;
    }
}

