/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;

public class BreakpointAnnotationListener
extends DebuggerManagerAdapter {
    private HashMap breakpointToAnnotation = new HashMap();
    private boolean listen = true;

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (!this.listen) {
            return;
        }
        if (!(propertyName.equals(LineBreakpoint.PROP_CONDITION) || propertyName.equals(LineBreakpoint.PROP_URL) || propertyName.equals(LineBreakpoint.PROP_LINE_NUMBER) || propertyName.equals("enabled"))) {
            return;
        }
        LineBreakpoint b = (LineBreakpoint)e.getSource();
        this.annotate(b);
    }

    public void breakpointAdded(Breakpoint b) {
        if (b instanceof LineBreakpoint) {
            ((LineBreakpoint)b).addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.annotate((LineBreakpoint)b);
        }
    }

    public void breakpointRemoved(Breakpoint b) {
        if (b instanceof LineBreakpoint) {
            ((LineBreakpoint)b).removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.removeAnnotation((LineBreakpoint)b);
        }
    }

    public LineBreakpoint findBreakpoint(String url, int lineNumber) {
        Iterator i = this.breakpointToAnnotation.keySet().iterator();
        while (i.hasNext()) {
            Object annotation;
            int ln;
            LineBreakpoint lb = (LineBreakpoint)i.next();
            if (!lb.getURL().equals(url) || (ln = EditorContextBridge.getLineNumber(annotation = this.breakpointToAnnotation.get(lb), null)) != lineNumber) continue;
            return lb;
        }
        return null;
    }

    private void annotate(LineBreakpoint b) {
        Object annotation = this.breakpointToAnnotation.get(b);
        if (annotation != null) {
            EditorContextBridge.removeAnnotation(annotation);
        }
        if (b.isHidden()) {
            return;
        }
        annotation = EditorContextBridge.annotate(b);
        if (annotation == null) {
            return;
        }
        this.breakpointToAnnotation.put(b, annotation);
        DebuggerEngine de = DebuggerManager.getDebuggerManager().getCurrentEngine();
        Object timeStamp = null;
        if (de != null) {
            timeStamp = de.lookupFirst(null, JPDADebugger.class);
        }
        this.update(b, timeStamp);
    }

    public void updateLineBreakpoints() {
        Iterator it = this.breakpointToAnnotation.keySet().iterator();
        while (it.hasNext()) {
            LineBreakpoint lb = (LineBreakpoint)it.next();
            this.update(lb, null);
        }
    }

    private void update(LineBreakpoint b, Object timeStamp) {
        Object annotation = this.breakpointToAnnotation.get(b);
        int ln = EditorContextBridge.getLineNumber(annotation, timeStamp);
        this.listen = false;
        b.setLineNumber(ln);
        this.listen = true;
    }

    private void removeAnnotation(LineBreakpoint b) {
        Object annotation = this.breakpointToAnnotation.remove(b);
        if (annotation != null) {
            EditorContextBridge.removeAnnotation(annotation);
        }
    }
}

