/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.ui.FilteredKeymap;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class WatchPanel {
    private JPanel panel;
    private JEditorPane editorPane;
    private String expression;

    public WatchPanel(String expression) {
        this.expression = expression;
    }

    public JComponent getPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel();
        ResourceBundle bundle = NbBundle.getBundle((Class)WatchPanel.class);
        this.panel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_WatchPanel"));
        JLabel textLabel = new JLabel(bundle.getString("CTL_Watch_Name"));
        this.editorPane = new JEditorPane("text/x-java", this.expression);
        this.editorPane.setKeymap(new FilteredKeymap(this.editorPane.getKeymap()));
        DebuggerEngine en = DebuggerManager.getDebuggerManager().getCurrentEngine();
        JPDADebugger d = (JPDADebugger)en.lookupFirst(null, JPDADebugger.class);
        CallStackFrame csf = d.getCurrentCallStackFrame();
        if (csf != null) {
            DataObject dobj = null;
            SourcePath sp = (SourcePath)en.lookupFirst(null, SourcePath.class);
            String url = sp.getURL(csf, "Java");
            try {
                FileObject file = URLMapper.findFileObject((URL)new URL(url));
                if (file != null) {
                    try {
                        dobj = DataObject.find((FileObject)file);
                    }
                    catch (DataObjectNotFoundException ex) {}
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            this.editorPane.getDocument().putProperty("stream", dobj);
        }
        JScrollPane sp = new JScrollPane(this.editorPane, 21, 31);
        textLabel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(11, 12, 1, 11));
        this.panel.add("North", textLabel);
        this.panel.add("Center", sp);
        FontMetrics fm = this.editorPane.getFontMetrics(this.editorPane.getFont());
        int size = 2 * fm.getLeading() + fm.getMaxAscent() + fm.getMaxDescent() + 4;
        this.editorPane.setPreferredSize(new Dimension(30 * size, 1 * size));
        this.editorPane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Watch_Name"));
        this.editorPane.setBorder(new CompoundBorder(this.editorPane.getBorder(), new EmptyBorder(2, 0, 2, 0)));
        textLabel.setDisplayedMnemonic(bundle.getString("CTL_Watch_Name_Mnemonic").charAt(0));
        this.editorPane.setText(this.expression);
        this.editorPane.selectAll();
        textLabel.setLabelFor(this.editorPane);
        this.editorPane.requestFocus();
        return this.panel;
    }

    public String getExpression() {
        return this.editorPane.getText().trim();
    }
}

