/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.StackFrame;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;

public class SourcePath {
    private ContextProvider contextProvider;
    private SourcePathProvider sourcePathProvider;
    private JPDADebugger debugger;

    public SourcePath(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    private SourcePathProvider getContext() {
        if (this.sourcePathProvider == null) {
            List l = this.contextProvider.lookup(null, SourcePathProvider.class);
            this.sourcePathProvider = (SourcePathProvider)l.get(0);
            int k = l.size();
            for (int i = 1; i < k; ++i) {
                this.sourcePathProvider = new CompoundContextProvider((SourcePathProvider)l.get(i), this.sourcePathProvider);
            }
            this.initSourcePaths();
        }
        return this.sourcePathProvider;
    }

    public String getRelativePath(String url, char directorySeparator, boolean includeExtension) {
        return this.getContext().getRelativePath(url, directorySeparator, includeExtension);
    }

    public String getURL(String relativePath, boolean global) {
        return this.getContext().getURL(relativePath, global);
    }

    public String getURL(StackFrame sf, String stratumn) {
        try {
            return this.getURL(SourcePath.convertSlash(sf.location().sourcePath(stratumn)), true);
        }
        catch (AbsentInformationException e) {
            return this.getURL(SourcePath.convertClassNameToRelativePath(sf.location().declaringType().name()), true);
        }
    }

    public String[] getSourceRoots() {
        return this.getContext().getSourceRoots();
    }

    public void setSourceRoots(String[] sourceRoots) {
        this.getContext().setSourceRoots(sourceRoots);
    }

    public String[] getOriginalSourceRoots() {
        return this.getContext().getOriginalSourceRoots();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getContext().addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getContext().removePropertyChangeListener(l);
    }

    public boolean sourceAvailable(String relativePath, boolean global) {
        return this.getURL(relativePath, global) != null;
    }

    public boolean sourceAvailable(JPDAThread t, String stratumn, boolean global) {
        try {
            return this.sourceAvailable(SourcePath.convertSlash(t.getSourcePath(stratumn)), global);
        }
        catch (AbsentInformationException e) {
            return this.sourceAvailable(SourcePath.convertClassNameToRelativePath(t.getClassName()), global);
        }
    }

    public boolean sourceAvailable(Field f) {
        String className = f.getClassName();
        return this.sourceAvailable(className, true);
    }

    public boolean sourceAvailable(CallStackFrame csf, String stratumn) {
        try {
            return this.sourceAvailable(SourcePath.convertSlash(csf.getSourcePath(stratumn)), true);
        }
        catch (AbsentInformationException e) {
            return this.sourceAvailable(SourcePath.convertClassNameToRelativePath(csf.getClassName()), true);
        }
    }

    public String getURL(CallStackFrame csf, String stratumn) {
        try {
            return this.getURL(SourcePath.convertSlash(csf.getSourcePath(stratumn)), true);
        }
        catch (AbsentInformationException e) {
            return this.getURL(SourcePath.convertClassNameToRelativePath(csf.getClassName()), true);
        }
    }

    public boolean showSource(JPDAThread t, String stratumn) {
        int lineNumber = t.getLineNumber(stratumn);
        if (lineNumber < 1) {
            lineNumber = 1;
        }
        try {
            return EditorContextBridge.showSource(this.getURL(SourcePath.convertSlash(t.getSourcePath(stratumn)), true), lineNumber, this.debugger);
        }
        catch (AbsentInformationException e) {
            return EditorContextBridge.showSource(this.getURL(SourcePath.convertClassNameToRelativePath(t.getClassName()), true), lineNumber, this.debugger);
        }
    }

    public boolean showSource(CallStackFrame csf, String stratumn) {
        try {
            String url = this.getURL(SourcePath.convertSlash(csf.getSourcePath(stratumn)), true);
            if (url == null) {
                stratumn = csf.getDefaultStratum();
                url = this.getURL(SourcePath.convertSlash(csf.getSourcePath(stratumn)), true);
            }
            if (url == null) {
                return false;
            }
            int lineNumber = csf.getLineNumber(stratumn);
            if (lineNumber < 1) {
                lineNumber = 1;
            }
            return EditorContextBridge.showSource(url, lineNumber, this.debugger);
        }
        catch (AbsentInformationException e) {
            return EditorContextBridge.showSource(this.getURL(SourcePath.convertClassNameToRelativePath(csf.getClassName()), true), 1, this.debugger);
        }
    }

    public boolean showSource(Field v) {
        String fieldName = v.getName();
        String className = v.getClassName();
        String url = this.getURL(EditorContextBridge.getRelativePath(className), true);
        if (url == null) {
            return false;
        }
        int lineNumber = EditorContextBridge.getFieldLineNumber(url, className, fieldName);
        if (lineNumber < 1) {
            lineNumber = 1;
        }
        return EditorContextBridge.showSource(url, lineNumber, this.debugger);
    }

    private static String convertSlash(String original) {
        return original.replace(File.separatorChar, '/');
    }

    public static String convertClassNameToRelativePath(String className) {
        int i = className.indexOf(36);
        if (i > 0) {
            className = className.substring(0, i);
        }
        String sourceName = className.replace('.', '/') + ".java";
        return sourceName;
    }

    public Object annotate(JPDAThread t, String stratumn) {
        int lineNumber = t.getLineNumber(stratumn);
        if (lineNumber < 1) {
            return null;
        }
        try {
            return EditorContextBridge.annotate(this.getURL(SourcePath.convertSlash(t.getSourcePath(stratumn)), true), lineNumber, EditorContext.CURRENT_LINE_ANNOTATION_TYPE, this.debugger);
        }
        catch (AbsentInformationException e) {
            return EditorContextBridge.annotate(this.getURL(SourcePath.convertClassNameToRelativePath(t.getClassName()), true), lineNumber, EditorContext.CURRENT_LINE_ANNOTATION_TYPE, this.debugger);
        }
    }

    public Object annotate(CallStackFrame csf, String stratumn) {
        int lineNumber = csf.getLineNumber(stratumn);
        if (lineNumber < 1) {
            return null;
        }
        try {
            return EditorContextBridge.annotate(this.getURL(SourcePath.convertSlash(csf.getSourcePath(stratumn)), true), lineNumber, EditorContext.CALL_STACK_FRAME_ANNOTATION_TYPE, this.debugger);
        }
        catch (AbsentInformationException e) {
            return EditorContextBridge.annotate(this.getURL(SourcePath.convertClassNameToRelativePath(csf.getClassName()), true), lineNumber, EditorContext.CALL_STACK_FRAME_ANNOTATION_TYPE, this.debugger);
        }
    }

    private void initSourcePaths() {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        HashSet<String> originalSourceRoots = new HashSet<String>(Arrays.asList(this.sourcePathProvider.getOriginalSourceRoots()));
        HashSet<String> sourceRoots = new HashSet<String>(Arrays.asList(this.sourcePathProvider.getSourceRoots()));
        Iterator enabledSourceRoots = properties.getProperties("source_roots").getCollection("enabled", (Collection)Collections.EMPTY_SET).iterator();
        while (enabledSourceRoots.hasNext()) {
            String root = (String)enabledSourceRoots.next();
            if (!originalSourceRoots.contains(root)) continue;
            sourceRoots.add(root);
        }
        Iterator disabledSourceRoots = properties.getProperties("source_roots").getCollection("disabled", (Collection)Collections.EMPTY_SET).iterator();
        while (disabledSourceRoots.hasNext()) {
            String root = (String)disabledSourceRoots.next();
            sourceRoots.remove(root);
        }
        String[] ss = new String[sourceRoots.size()];
        this.sourcePathProvider.setSourceRoots(sourceRoots.toArray(ss));
    }

    private static class CompoundAnnotation {
        Object annotation1;
        Object annotation2;

        private CompoundAnnotation() {
        }
    }

    private static class CompoundContextProvider
    extends SourcePathProvider {
        private SourcePathProvider cp1;
        private SourcePathProvider cp2;

        CompoundContextProvider(SourcePathProvider cp1, SourcePathProvider cp2) {
            this.cp1 = cp1;
            this.cp2 = cp2;
        }

        public String getURL(String relativePath, boolean global) {
            String p1 = this.cp1.getURL(relativePath, global);
            if (p1 != null) {
                return p1;
            }
            return this.cp2.getURL(relativePath, global);
        }

        public String getRelativePath(String url, char directorySeparator, boolean includeExtension) {
            String p1 = this.cp1.getRelativePath(url, directorySeparator, includeExtension);
            if (p1 != null) {
                return p1;
            }
            return this.cp2.getRelativePath(url, directorySeparator, includeExtension);
        }

        public String[] getSourceRoots() {
            String[] fs1 = this.cp1.getSourceRoots();
            String[] fs2 = this.cp2.getSourceRoots();
            String[] fs = new String[fs1.length + fs2.length];
            System.arraycopy(fs1, 0, fs, 0, fs1.length);
            System.arraycopy(fs2, 0, fs, fs1.length, fs2.length);
            return fs;
        }

        public String[] getOriginalSourceRoots() {
            String[] fs1 = this.cp1.getOriginalSourceRoots();
            String[] fs2 = this.cp2.getOriginalSourceRoots();
            String[] fs = new String[fs1.length + fs2.length];
            System.arraycopy(fs1, 0, fs, 0, fs1.length);
            System.arraycopy(fs2, 0, fs, fs1.length, fs2.length);
            return fs;
        }

        public void setSourceRoots(String[] sourceRoots) {
            this.cp1.setSourceRoots(sourceRoots);
            this.cp2.setSourceRoots(sourceRoots);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.cp1.addPropertyChangeListener(l);
            this.cp2.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.cp1.removePropertyChangeListener(l);
            this.cp2.removePropertyChangeListener(l);
        }
    }
}

