/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.openfile.OpenFileImpl;
import org.netbeans.modules.openfile.cli.Callback;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOperation;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class DefaultOpenFileImpl
implements OpenFileImpl {
    static final String JAVA_EXT = ".JAVA";
    static final String TXT_EXT = ".TXT";
    private static final int OPEN_EDITOR_WAIT_PERIOD_MS = 100;
    private static final int OPEN_EDITOR_TOTAL_TIMEOUT_MS = 1000;
    private static final String ZIP_EXT = "zip";
    private static final String JAR_EXT = "jar";
    static final /* synthetic */ boolean $assertionsDisabled;

    protected final void setStatusLine(String text) {
        StatusDisplayer.getDefault().setStatusText(text);
    }

    protected final void clearStatusLine() {
        this.setStatusLine("");
    }

    protected void setStatusLineOpening(String fileName, boolean waiting) {
        this.setStatusLine(NbBundle.getMessage((Class)OpenFileImpl.class, (String)(waiting ? "MSG_openingAndWaiting" : "MSG_opening"), (Object)fileName));
    }

    protected void notifyCannotOpen(String fileName) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)OpenFileImpl.class, (String)"MSG_cannotOpenWillClose", (Object)fileName)));
    }

    private boolean openEditor(EditorCookie editorCookie, int line) {
        StyledDocument doc;
        JEditorPane[] openPanes = editorCookie.getOpenedPanes();
        if (openPanes != null) {
            if (line >= 0) {
                int cursorOffset = this.getCursorOffset(editorCookie.getDocument(), line);
                openPanes[0].setCaretPosition(cursorOffset);
            }
            Container c = SwingUtilities.getAncestorOfClass(TopComponent.class, openPanes[0]);
            if (!$assertionsDisabled && c == null) {
                throw new AssertionError();
            }
            final TopComponent tc = (TopComponent)c;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    tc.requestActive();
                }
            });
            return true;
        }
        try {
            doc = editorCookie.openDocument();
        }
        catch (IOException ex) {
            String msg = NbBundle.getMessage((Class)OpenFileImpl.class, (String)"MSG_cannotOpenWillClose");
            ErrorManager.getDefault().notify(4096, ErrorManager.getDefault().annotate((Throwable)ex, msg));
            this.clearStatusLine();
            return false;
        }
        if (line < 0) {
            editorCookie.open();
        } else {
            this.openDocAtLine(editorCookie, doc, line);
        }
        return true;
    }

    private void openDocAtLine(EditorCookie editorCookie, StyledDocument doc, int line) {
        if (!$assertionsDisabled && line < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && editorCookie.getDocument() != doc) {
            throw new AssertionError();
        }
        int offset = this.getCursorOffset(doc, line);
        class SetCursorTask
        implements Runnable {
            private boolean completed = false;
            private PropertyChangeListener listenerToUnregister;
            static final /* synthetic */ boolean $assertionsDisabled;
            private final /* synthetic */ EditorCookie val$editorCookie;
            private final /* synthetic */ int val$offset;

            SetCursorTask(EditorCookie editorCookie, int n) {
                this.val$editorCookie = editorCookie;
                this.val$offset = n;
            }

            private boolean perform() {
                if (EventQueue.isDispatchThread()) {
                    this.run();
                } else {
                    try {
                        EventQueue.invokeAndWait(this);
                    }
                    catch (Exception ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                        this.completed = true;
                    }
                }
                return this.completed;
            }

            public void run() {
                if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
                    throw new AssertionError();
                }
                if (this.completed) {
                    return;
                }
                JEditorPane[] panes = this.val$editorCookie.getOpenedPanes();
                if (panes != null) {
                    panes[0].setCaretPosition(this.val$offset);
                    if (this.listenerToUnregister != null) {
                        ((EditorCookie.Observable)this.val$editorCookie).removePropertyChangeListener(this.listenerToUnregister);
                    }
                    this.completed = true;
                }
            }

            private void setListenerToUnregister(PropertyChangeListener l) {
                this.listenerToUnregister = l;
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$openfile$DefaultOpenFileImpl == null ? (class$org$netbeans$modules$openfile$DefaultOpenFileImpl = DefaultOpenFileImpl.class$("org.netbeans.modules.openfile.DefaultOpenFileImpl")) : class$org$netbeans$modules$openfile$DefaultOpenFileImpl).desiredAssertionStatus();
            }
        }
        final SetCursorTask setCursorTask = new SetCursorTask(editorCookie, offset);
        editorCookie.open();
        if (setCursorTask.perform()) {
            return;
        }
        if (editorCookie instanceof EditorCookie.Observable) {
            if (!setCursorTask.perform()) {
                PropertyChangeListener openPanesListener = new PropertyChangeListener(){
                    {
                    }

                    public void propertyChange(PropertyChangeEvent e) {
                        if ("openedPanes".equals(e.getPropertyName())) {
                            setCursorTask.perform();
                        }
                    }
                };
                setCursorTask.setListenerToUnregister(openPanesListener);
                ((EditorCookie.Observable)editorCookie).addPropertyChangeListener(openPanesListener);
                setCursorTask.perform();
            }
        } else {
            int numberOfTries = 10;
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    ErrorManager.getDefault().notify(4096, (Throwable)ex);
                }
                if (setCursorTask.perform()) break;
            }
            if (!setCursorTask.completed) {
                this.setStatusLine(NbBundle.getMessage((Class)OpenFileImpl.class, (String)"MSG_couldNotOpenAt"));
            }
        }
    }

    private int getCursorOffset(StyledDocument doc, int line) {
        if (!$assertionsDisabled && line < 0) {
            throw new AssertionError();
        }
        try {
            return NbDocument.findLineOffset((StyledDocument)doc, (int)line);
        }
        catch (IndexOutOfBoundsException ex) {
            Element lineRootElement = NbDocument.findLineRootElement((StyledDocument)doc);
            int lineCount = lineRootElement.getElementCount();
            if (line >= lineCount) {
                return NbDocument.findLineOffset((StyledDocument)doc, (int)(lineCount - 1));
            }
            throw ex;
        }
    }

    protected boolean openByCookie(Node.Cookie cookie, Class cookieClass, int line) {
        if (cookieClass == EditorCookie.Observable.class || cookieClass == EditorCookie.Observable.class) {
            return this.openEditor((EditorCookie)cookie, line);
        }
        if (cookieClass == OpenCookie.class) {
            ((OpenCookie)cookie).open();
        } else if (cookieClass == EditCookie.class) {
            ((EditCookie)cookie).edit();
        } else if (cookieClass == ViewCookie.class) {
            ((ViewCookie)cookie).view();
        } else {
            throw new IllegalArgumentException();
        }
        return true;
    }

    private final boolean openDataObjectByCookie(DataObject dataObject, int line) {
        Class cookieClass = OpenCookie.class;
        Node.Cookie cookie = dataObject.getCookie(cookieClass);
        if (cookie != null || (cookie = dataObject.getCookie(cookieClass = EditCookie.class)) != null || (cookie = dataObject.getCookie(cookieClass = ViewCookie.class)) != null) {
            return this.openByCookie(cookie, cookieClass, line);
        }
        return false;
    }

    private final DataLoader getDefaultLoader() {
        DataLoader defaultLoader = null;
        DataLoaderPool loaderPool = DataLoaderPool.getDefault();
        Enumeration loaders = loaderPool.allLoaders();
        while (loaders.hasMoreElements()) {
            defaultLoader = (DataLoader)loaders.nextElement();
        }
        return defaultLoader;
    }

    public boolean open(FileObject fileObject, int line, Callback.Waiter waiter) {
        Class cookieClass;
        Node.Cookie cookie;
        DataObject dataObject;
        String fileName = fileObject.getNameExt();
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return false;
        }
        if (line != -1 && ((cookie = dataObject.getCookie(cookieClass = EditorCookie.Observable.class)) != null || (cookie = dataObject.getCookie(cookieClass = EditorCookie.class)) != null)) {
            boolean ret = this.openByCookie(cookie, cookieClass, line);
            this.clearStatusLine();
            return ret;
        }
        final Node dataNode = dataObject.getNodeDelegate();
        final Action action = dataNode.getPreferredAction();
        if (action != null && !(action instanceof FileSystemAction)) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    action.actionPerformed(new ActionEvent(dataNode, 0, null));
                    DefaultOpenFileImpl.this.clearStatusLine();
                }
            });
            return true;
        }
        this.setStatusLineOpening(fileName, waiter != null);
        boolean success = this.openDataObjectByCookie(dataObject, line);
        this.clearStatusLine();
        if (success) {
            return true;
        }
        if (ZIP_EXT.equalsIgnoreCase(fileObject.getExt()) || JAR_EXT.equalsIgnoreCase(fileObject.getExt())) {
            Node node = dataObject.getNodeDelegate();
            if (node != null) {
                NodeOperation.getDefault().explore(node);
                return true;
            }
            return false;
        }
        return false;
    }

    public synchronized FileObject findFileObject(File f) {
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
    }

    static {
        $assertionsDisabled = !DefaultOpenFileImpl.class.desiredAssertionStatus();
    }
}

