/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.tools;

import java.awt.Component;
import java.lang.reflect.Modifier;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.util.Utilities;

public class ElementRenderer
extends DefaultListCellRenderer {
    private static ImageIcon[] elementIcons = new ImageIcon[8];
    private static final int PUBLIC_OFFSET = 0;
    private static final int PROTECTED_OFFSET = 1;
    private static final int PRIVATE_OFFSET = 2;
    private static final int PACKAGE_OFFSET = 3;
    private static final int METHOD_BASE = 0;
    private static final int CLASS_BASE = 4;
    private ElementFormat elementFormat;

    public ElementRenderer() {
    }

    public ElementRenderer(ElementFormat fmt) {
        this();
        this.setFormat(fmt);
    }

    public void setFormat(ElementFormat fmt) {
        this.elementFormat = fmt;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focused) {
        Component c = super.getListCellRendererComponent((JList<?>)list, (Object)null, index, selected, focused);
        if (!(c instanceof JLabel)) {
            return c;
        }
        JLabel label = (JLabel)c;
        label.setIcon(this.getIcon(value));
        label.setText(this.elementFormat.format((Element)((MethodElement)value)));
        return c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Icon getIcon(Object element) {
        int base;
        if (!(element instanceof MemberElement)) throw new IllegalArgumentException(element.getClass().toString());
        int modifiers = ((MemberElement)element).getModifiers();
        MemberElement el = (MemberElement)element;
        if (el instanceof ClassElement) {
            base = 4;
        } else {
            if (!(el instanceof MethodElement)) throw new IllegalArgumentException(element.getClass().toString());
            base = 0;
        }
        int offset = Modifier.isPublic(modifiers) ? 0 : (Modifier.isProtected(modifiers) ? 1 : (Modifier.isPrivate(modifiers) ? 2 : 3));
        return elementIcons[base + offset];
    }

    static {
        ElementRenderer.elementIcons[0] = new ImageIcon(Utilities.loadImage((String)"org/openide/src/resources/methodPublic.gif"));
        ElementRenderer.elementIcons[1] = new ImageIcon(Utilities.loadImage((String)"org/openide/src/resources/methodProtected.gif"));
        ElementRenderer.elementIcons[2] = new ImageIcon(Utilities.loadImage((String)"org/openide/src/resources/methodPrivate.gif"));
        ElementRenderer.elementIcons[3] = new ImageIcon(Utilities.loadImage((String)"org/openide/src/resources/methodPackage.gif"));
        ElementRenderer.elementIcons[4] = new ImageIcon(Utilities.loadImage((String)"org/openide/src/resources/class.gif"));
        ElementRenderer.elementIcons[5] = elementIcons[4];
        ElementRenderer.elementIcons[6] = elementIcons[4];
        ElementRenderer.elementIcons[7] = elementIcons[4];
    }
}

