/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.JmiException;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.events.ExtentEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.RenameHandler;
import org.netbeans.modules.java.Util;
import org.netbeans.modules.java.settings.JavaSettings;
import org.netbeans.modules.java.tools.BadgeCache;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.netbeans.modules.java.ui.nodes.elements.SourceChildren;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.ParsingListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.NewType;

public class JavaNode
extends DataNode {
    private static final boolean DONT_RESOLVE_JAVA_BADGES = Boolean.getBoolean("perf.dont.resolve.java.badges");
    private static final String SHEETNAME_TEXT_PROPERTIES = "textProperties";
    private static final String PROP_ENCODING = "encoding";
    private static final long serialVersionUID = -7396485743899766258L;
    private static final String ICON_BASE = "org/netbeans/modules/java/resources/";
    private static final String BADGE_MAIN = "org/netbeans/modules/java/resources/executable-badge";
    private static final String BADGE_ERROR = "org/netbeans/modules/java/resources/error-badge";
    private static final String BADGE_NEEDS_COMPILE = "org/netbeans/modules/java/resources/needs-compile";
    private static final String[] ICON_ATTRS_NONE = new String[0];
    protected static final String ICON_ATTR_NEEDS_COMPILE = "needsCompile";
    protected static final String ICON_ATTR_MAIN = "mainClass";
    protected static final String ICON_ATTR_ERROR = "error";
    private static final int ICON_REFRESH_DELAY_MSECS = 1000;
    private BadgeCache iconCache;
    private HashSet currentBadges;
    private StatePropagator statePropagator;

    public JavaNode(JavaDataObject jdo) {
        this(jdo, (Children)(jdo.isTemplate() ? Children.LEAF : new JavaSourceChildren(jdo)));
        this.currentBadges = new HashSet();
    }

    protected void initializeBadges(BadgeCache cache) {
        cache.registerBadge(ICON_ATTR_MAIN, BADGE_MAIN, 9, 8);
        cache.registerBadge(ICON_ATTR_ERROR, BADGE_ERROR, 8, 8);
        cache.registerBadge(ICON_ATTR_NEEDS_COMPILE, BADGE_NEEDS_COMPILE, 16, 0);
    }

    public JavaNode(JavaDataObject jdo, Children children) {
        super((DataObject)jdo, children);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIconBase(String base) {
        super.setIconBase(base);
        JavaNode javaNode = this;
        synchronized (javaNode) {
            this.iconCache = BadgeCache.getCache(base);
            this.initializeBadges(this.iconCache);
        }
    }

    private void initialize() {
        this.setIconBase(this.getBareIconBase());
        StateUpdater.registerNode(this);
    }

    protected void requestResolveIcons() {
        StateUpdater.registerNode(this);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.initialize();
    }

    static final void wrapThrowable(Throwable outer, Throwable inner, String message) {
        ErrorManager.getDefault().annotate(outer, 256, null, message, inner, null);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        if (JavaNode.getRenameHandler() != null) {
            sheet.get("properties").put(this.createNameProperty());
        }
        Sheet.Set ps = new Sheet.Set();
        ps.setName(SHEETNAME_TEXT_PROPERTIES);
        ps.setDisplayName(Util.getString("PROP_textfileSetName"));
        ps.setShortDescription(Util.getString("HINT_textfileSetName"));
        ps.put((Node.Property)new PropertySupport.ReadWrite(PROP_ENCODING, String.class, Util.getString("PROP_fileEncoding"), Util.getString("HINT_fileEncoding")){

            public Object getValue() {
                String enc = Util.getFileEncoding0(JavaNode.this.getDataObject().getPrimaryFile());
                if (enc == null) {
                    return "";
                }
                return enc;
            }

            public void setValue(Object enc) throws InvocationTargetException {
                String encoding = (String)enc;
                if (encoding != null) {
                    if (!"".equals(encoding)) {
                        try {
                            Charset.forName(encoding);
                        }
                        catch (IllegalArgumentException ex) {
                            InvocationTargetException t = new InvocationTargetException(ex);
                            JavaNode.wrapThrowable(t, ex, MessageFormat.format(Util.getString("FMT_UnsupportedEncoding"), encoding));
                            throw t;
                        }
                    } else {
                        encoding = null;
                    }
                }
                try {
                    Util.setFileEncoding(JavaNode.this.getDataObject().getPrimaryFile(), encoding);
                    ((JavaDataObject)JavaNode.this.getDataObject()).firePropertyChange0(JavaNode.PROP_ENCODING, null, null);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }
        });
        sheet.put(ps);
        ps = new Sheet.Set();
        ps.setName("classpaths");
        ps.setDisplayName(NbBundle.getMessage((Class)JavaNode.class, (String)"LBL_JavaNode_sheet_classpaths"));
        ps.setShortDescription(NbBundle.getMessage((Class)JavaNode.class, (String)"HINT_JavaNode_sheet_classpaths"));
        ps.put(new Node.Property[]{new ClasspathProperty("classpath/compile", NbBundle.getMessage((Class)JavaNode.class, (String)"PROP_JavaNode_compile_classpath"), NbBundle.getMessage((Class)JavaNode.class, (String)"HINT_JavaNode_compile_classpath")), new ClasspathProperty("classpath/execute", NbBundle.getMessage((Class)JavaNode.class, (String)"PROP_JavaNode_execute_classpath"), NbBundle.getMessage((Class)JavaNode.class, (String)"HINT_JavaNode_execute_classpath")), new ClasspathProperty("classpath/boot", NbBundle.getMessage((Class)JavaNode.class, (String)"PROP_JavaNode_boot_classpath"), NbBundle.getMessage((Class)JavaNode.class, (String)"HINT_JavaNode_boot_classpath"))});
        sheet.put(ps);
        return sheet;
    }

    private Node.Property createNameProperty() {
        PropertySupport.ReadWrite p = new PropertySupport.ReadWrite("name", String.class, NbBundle.getMessage((Class)DataObject.class, (String)"PROP_name"), NbBundle.getMessage((Class)DataObject.class, (String)"HINT_name")){

            public Object getValue() {
                return JavaNode.this.getName();
            }

            public Object getValue(String key) {
                if ("suppressCustomEditor".equals(key)) {
                    return Boolean.TRUE;
                }
                return super.getValue(key);
            }

            public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                if (!(val instanceof String)) {
                    throw new IllegalArgumentException();
                }
                JavaNode.this.setName((String)val);
            }

            public boolean canWrite() {
                return JavaNode.this.canRename();
            }
        };
        return p;
    }

    protected JavaDataObject getJavaDataObject() {
        return (JavaDataObject)this.getDataObject();
    }

    public Image getIcon(int type) {
        return this.iconCache.getIcon(super.getIcon(type), this.getBadges());
    }

    public Image getOpenedIcon(int type) {
        return this.iconCache.getIcon(super.getOpenedIcon(type), this.getBadges());
    }

    public void setName(String name) {
        RenameHandler handler = JavaNode.getRenameHandler();
        if (handler == null) {
            super.setName(name);
        } else {
            try {
                handler.handleRename((Node)this, name);
            }
            catch (IllegalArgumentException ioe) {
                super.setName(name);
            }
        }
    }

    private static synchronized RenameHandler getRenameHandler() {
        Lookup.Result renameImplementations = Lookup.getDefault().lookup(new Lookup.Template(RenameHandler.class));
        List handlers = (List)renameImplementations.allInstances();
        if (handlers.size() == 0) {
            return null;
        }
        if (handlers.size() > 1) {
            ErrorManager.getDefault().log(16, "Multiple instances of RenameHandler found in Lookup; only using first one: " + handlers);
        }
        return (RenameHandler)handlers.get(0);
    }

    protected String getIconBase() {
        return ICON_BASE;
    }

    protected String getBareIconBase() {
        return this.getIconBase() + this.getIcons()[0];
    }

    protected String[] getIcons() {
        return new String[]{"class"};
    }

    protected String[] getBadges() {
        if (this.currentBadges.isEmpty()) {
            return null;
        }
        return this.currentBadges.toArray(new String[this.currentBadges.size()]);
    }

    protected void setBadges(String[] badges) {
        if (badges == null) {
            badges = new String[]{};
        }
        if (this.currentBadges.size() == badges.length) {
            boolean match = true;
            for (int i = 0; i < badges.length; ++i) {
                if (this.currentBadges.contains(badges[i])) continue;
                match = false;
                break;
            }
            if (match) {
                return;
            }
        }
        this.currentBadges = new HashSet<String>(Arrays.asList(badges));
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveIcons() {
        String compBadge;
        String desc;
        boolean isTemplate;
        if (DONT_RESOLVE_JAVA_BADGES) {
            return;
        }
        if (this.statePropagator == null) {
            this.statePropagator = StatePropagator.getDefault(this);
        }
        JavaDataObject jdo = this.getJavaDataObject();
        FileObject fo = jdo.getPrimaryFile();
        try {
            isTemplate = fo.getFileSystem().isDefault() && jdo.isTemplate();
        }
        catch (FileStateInvalidException fse) {
            isTemplate = false;
        }
        if (isTemplate) {
            return;
        }
        if (fo.isVirtual()) {
            return;
        }
        final ArrayList<String> badges = new ArrayList<String>(3);
        String pack2 = "";
        boolean isValidResource = false;
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            JavaModel.setClassPath((FileObject)fo);
            Resource resource = JavaModel.getResource((FileObject)fo);
            boolean bl = isValidResource = resource != null && resource.isValid();
            if (isValidResource) {
                pack2 = resource.getPackageName();
            }
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
        if (isValidResource) {
            FileObject parent = fo.getParent();
            ClassPath cp = ClassPath.getClassPath((FileObject)parent, (String)"classpath/source");
            String pack = cp == null ? null : cp.getResourceName(parent, '.', false);
            desc = pack == null || !pack.equals(pack2) ? new MessageFormat(Util.getString("FMT_Bad_Package")).format(new Object[]{pack2}) : null;
            if (this.hasMain()) {
                badges.add(ICON_ATTR_MAIN);
            }
        } else {
            if (this.currentBadges.contains(ICON_ATTR_MAIN)) {
                badges.add(ICON_ATTR_MAIN);
            }
            desc = this.getShortDescription();
        }
        if (!isTemplate && (compBadge = this.resolveCompileBadge()) != null) {
            badges.add(compBadge);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavaNode.this.setShortDescription(desc);
                if (badges.isEmpty()) {
                    JavaNode.this.setBadges(ICON_ATTRS_NONE);
                } else {
                    JavaNode.this.setBadges(badges.toArray(new String[badges.size()]));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMain() {
        FileObject fo = this.getJavaDataObject().getPrimaryFile();
        if (!fo.isValid()) {
            return false;
        }
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            JavaModel.setClassPath((FileObject)fo);
            Resource r = JavaModel.getResource((FileObject)fo);
            boolean bl = r != null && !r.getMain().isEmpty();
            return bl;
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    protected String resolveCompileBadge() {
        if (!JavaSettings.getDefault().isCompileStatusEnabled()) {
            return null;
        }
        FileBuiltQuery.Status upToDate = FileBuiltQuery.getStatus((FileObject)this.getDataObject().getPrimaryFile());
        return upToDate != null && !upToDate.isBuilt() ? ICON_ATTR_NEEDS_COMPILE : null;
    }

    public NewType[] getNewTypes() {
        if (this.getJavaDataObject().isJavaFileReadOnly()) {
            return super.getNewTypes();
        }
        return SourceEditSupport.createJavaNodeNewTypes(this);
    }

    private static final class WeakParsingListener
    extends WeakReference
    implements Runnable,
    ParsingListener {
        public WeakParsingListener(ParsingListener delegate) {
            super(delegate, Utilities.activeReferenceQueue());
        }

        public void run() {
            JavaMetamodel.removeParsingListener((ParsingListener)this);
        }

        public void resourceParsed(Resource rsc) {
            ParsingListener delegate = (ParsingListener)this.get();
            if (delegate != null) {
                delegate.resourceParsed(rsc);
            }
        }
    }

    private static final class StatePropagator
    extends WeakReference
    implements PropertyChangeListener,
    ChangeListener,
    ParsingListener,
    Runnable {
        private FileBuiltQuery.Status upToDate;
        private final DataObject dobj;
        private final PropertyChangeListener weakPropLsnr;
        private final ParsingListener weakParsingLsnr;

        private StatePropagator(JavaNode node) {
            super(node, Utilities.activeReferenceQueue());
            this.dobj = node.getDataObject();
            this.dobj.addPropertyChangeListener((PropertyChangeListener)this);
            this.registerBuildStatusListener();
            this.weakPropLsnr = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)((Object)JavaSettings.getDefault()));
            JavaSettings.getDefault().addPropertyChangeListener(this.weakPropLsnr);
            this.weakParsingLsnr = new WeakParsingListener(this);
            JavaMetamodel.addParsingListener((ParsingListener)this.weakParsingLsnr);
        }

        public static StatePropagator getDefault(JavaNode node) {
            return new StatePropagator(node);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object src = evt.getSource();
            String name = evt.getPropertyName();
            JavaNode node = this.getJavaNode();
            if (("showCompileStatus".equals(name) || name == null) && src == JavaSettings.getDefault()) {
                this.registerBuildStatusListener();
                StateUpdater.registerNode(node);
            } else if (("primaryFile".equals(name) || name == null) && src == node.getDataObject()) {
                this.registerBuildStatusListener();
                StateUpdater.registerNode(node);
            }
        }

        public void stateChanged(ChangeEvent e) {
            JavaNode node = this.getJavaNode();
            if (node != null && JavaSettings.getDefault().isCompileStatusEnabled()) {
                StateUpdater.registerNode(node);
            }
        }

        public void resourceParsed(Resource rsc) {
            JavaNode node = this.getJavaNode();
            if (node != null) {
                FileObject fo = node.getDataObject().getPrimaryFile();
                try {
                    if (fo.getPath().endsWith(rsc.getName()) && fo.equals(JavaModel.getFileObject((Resource)rsc))) {
                        StateUpdater.registerNode(node);
                    }
                }
                catch (InvalidObjectException ioe) {
                    // empty catch block
                }
            }
        }

        public void run() {
            JavaSettings.getDefault().removePropertyChangeListener(this.weakPropLsnr);
            this.dobj.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.upToDate != null) {
                this.upToDate.removeChangeListener((ChangeListener)this);
            }
        }

        private JavaNode getJavaNode() {
            return (JavaNode)((Object)this.get());
        }

        private void registerBuildStatusListener() {
            JavaNode node = this.getJavaNode();
            if (node != null) {
                FileBuiltQuery.Status status = this.upToDate;
                if (status != null) {
                    status.removeChangeListener((ChangeListener)this);
                }
                if (JavaSettings.getDefault().isCompileStatusEnabled()) {
                    status = FileBuiltQuery.getStatus((FileObject)node.getDataObject().getPrimaryFile());
                    if (status != null) {
                        status.addChangeListener((ChangeListener)this);
                    }
                } else {
                    status = null;
                }
                this.upToDate = status;
            }
        }
    }

    private static final class StateUpdater
    implements Runnable {
        private static StateUpdater INSTANCE;
        private Set registeredNodes = new HashSet(37);
        private final RequestProcessor QUEUE = new RequestProcessor("Java Node State Updater");
        private RequestProcessor.Task task;

        private StateUpdater() {
        }

        public static void registerNode(JavaNode node) {
            StateUpdater.init();
            INSTANCE.scheduleNode(node);
        }

        private static void init() {
            if (INSTANCE == null) {
                INSTANCE = new StateUpdater();
            }
        }

        private synchronized void scheduleNode(JavaNode node) {
            if (!this.registeredNodes.contains((Object)node)) {
                this.registeredNodes.add(node);
                if (this.task == null) {
                    this.task = this.QUEUE.post((Runnable)this, 1000);
                } else {
                    this.task.schedule(1000);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList nodes;
            StateUpdater stateUpdater = this;
            synchronized (stateUpdater) {
                nodes = new ArrayList(this.registeredNodes);
                this.registeredNodes.clear();
            }
            this.updateNodes(nodes);
        }

        private void updateNodes(List nodes) {
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                JavaNode node = (JavaNode)((Object)it.next());
                if (node == null) continue;
                node.resolveIcons();
            }
        }
    }

    private final class ClasspathProperty
    extends PropertySupport.ReadOnly {
        private final String id;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ClasspathProperty(String id, String displayName, String shortDescription) {
            super(id, class$java$lang$String == null ? (class$java$lang$String = JavaNode.class$("java.lang.String")) : class$java$lang$String, displayName, shortDescription);
            this.id = id;
            this.setValue("oneline", Boolean.FALSE);
        }

        public Object getValue() {
            ClassPath cp = ClassPath.getClassPath((FileObject)JavaNode.this.getDataObject().getPrimaryFile(), (String)this.id);
            if (cp != null) {
                StringBuffer sb = new StringBuffer();
                Iterator entries = cp.entries().iterator();
                while (entries.hasNext()) {
                    ClassPath.Entry entry = (ClassPath.Entry)entries.next();
                    URL u = entry.getURL();
                    this.append(sb, u);
                }
                return sb.toString();
            }
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$java$JavaNode == null ? (class$org$netbeans$modules$java$JavaNode = JavaNode.class$("org.netbeans.modules.java.JavaNode")) : class$org$netbeans$modules$java$JavaNode), (String)"LBL_JavaNode_classpath_unknown");
        }

        private void append(StringBuffer sb, URL u) {
            String item = u.toExternalForm();
            if (u.getProtocol().equals("file")) {
                item = new File(URI.create(item)).getAbsolutePath();
            } else if (u.getProtocol().equals("jar") && item.endsWith("!/")) {
                URL embedded = FileUtil.getArchiveFile((URL)u);
                if (!$assertionsDisabled && embedded == null) {
                    throw new AssertionError(u);
                }
                if (embedded.getProtocol().equals("file")) {
                    item = new File(URI.create(embedded.toExternalForm())).getAbsolutePath();
                }
            }
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(item);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$JavaNode == null ? (class$org$netbeans$modules$java$JavaNode = JavaNode.class$("org.netbeans.modules.java.JavaNode")) : class$org$netbeans$modules$java$JavaNode).desiredAssertionStatus();
        }
    }

    private static final class JavaSourceChildren
    extends SourceChildren {
        JavaDataObject jdo;
        private ExtentListener wExtentL;

        public JavaSourceChildren(JavaDataObject jdo) {
            super(SourceNodes.getExplorerFactory());
            this.jdo = jdo;
        }

        protected void removeNotify() {
            super.removeNotify();
            this.setElement(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Resource createResource() {
            Resource r = null;
            JavaModel.getJavaRepository().beginTrans(false);
            try {
                r = JavaModel.getResource((FileObject)this.jdo.getPrimaryFile());
            }
            catch (JmiException jmiException) {
            }
            finally {
                JavaModel.getJavaRepository().endTrans();
            }
            return r;
        }

        public void setElement(Resource element) {
            MDRepository repository = JavaModel.getJavaRepository();
            if (this.element == null && element != null) {
                if (this.wExtentL == null) {
                    this.wExtentL = new ExtentListener(this, (MDRChangeSource)repository);
                }
                repository.addListener((MDRChangeListener)this.wExtentL);
            } else if (element == null) {
                repository.removeListener((MDRChangeListener)this.wExtentL);
            }
            super.setElement(element);
        }

        private static final class ExtentListener
        extends WeakReference
        implements MDRChangeListener,
        Runnable {
            private final MDRChangeSource source;

            public ExtentListener(JavaSourceChildren referent, MDRChangeSource source) {
                super(referent, Utilities.activeReferenceQueue());
                this.source = source;
            }

            public void change(MDRChangeEvent e) {
                JavaSourceChildren sc = (JavaSourceChildren)this.get();
                if (sc == null) {
                    return;
                }
                if (e instanceof ExtentEvent && ((ExtentEvent)e).getType() == 134283266) {
                    sc.setElement(JavaModel.getResource((FileObject)sc.jdo.getPrimaryFile()));
                }
            }

            public void run() {
                this.source.removeListener((MDRChangeListener)this);
            }
        }
    }
}

