/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.moduleinstall;

import java.net.URL;
import java.util.HashMap;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.openide.WizardDescriptor;

final class DataModel
extends BasicWizardIterator.BasicDataModel {
    static final String OPENIDE_MODULE_INSTALL = "OpenIDE-Module-Install";
    private static final String INSTALLER_CLASS_NAME = "Installer";
    private CreatedModifiedFiles cmf;

    DataModel(WizardDescriptor wiz) {
        super(wiz);
    }

    CreatedModifiedFiles getCreatedModifiedFiles() {
        if (this.cmf == null) {
            this.regenerate();
        }
        return this.cmf;
    }

    private void regenerate() {
        this.cmf = new CreatedModifiedFiles(this.getProject());
        String className = INSTALLER_CLASS_NAME;
        String path = this.getDefaultPackagePath(className + ".java");
        int i = 0;
        while (this.alreadyExist(path)) {
            className = "Installer_" + ++i;
            path = this.getDefaultPackagePath(className + ".java");
        }
        HashMap<String, String> basicTokens = new HashMap<String, String>();
        basicTokens.put("@@PACKAGE_NAME@@", this.getPackageName());
        basicTokens.put("@@CLASS_NAME@@", className);
        URL template = DataModel.class.getResource("moduleInstall.javx");
        this.cmf.add(this.cmf.createFileWithSubstitutions(path, template, basicTokens));
        this.cmf.add(this.cmf.addModuleDependency("org.openide.modules"));
        this.cmf.add(this.cmf.addModuleDependency("org.openide.util"));
        HashMap<String, String> attribs = new HashMap<String, String>();
        attribs.put(OPENIDE_MODULE_INSTALL, this.getPackageName().replace('.', '/') + '/' + className + ".class");
        this.cmf.add(this.cmf.manifestModification(null, attribs));
    }

    private void reset() {
        this.cmf = null;
    }

    public void setPackageName(String packageName) {
        super.setPackageName(packageName);
        this.reset();
    }

    private boolean alreadyExist(String relPath) {
        return this.getProject().getProjectDirectory().getFileObject(relPath) != null;
    }
}

