/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleProjectGenerator;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public final class SuiteUtils {
    private static final String ANT_PURE_PROPERTY_REFERENCE_REGEXP = "\\$\\{\\p{Graph}+\\}";
    private static final String PRIVATE_PLATFORM_PROPERTIES = "nbproject/private/platform-private.properties";
    static final String MODULES_PROPERTY = "modules";
    private final SuiteProperties suiteProps;
    static final /* synthetic */ boolean $assertionsDisabled;

    private SuiteUtils(SuiteProperties suiteProps) {
        this.suiteProps = suiteProps;
    }

    public static NbModuleProject[] getDependentModules(final NbModuleProject suiteComponent) throws IOException {
        final String cnb = suiteComponent.getCodeNameBase();
        try {
            return (NbModuleProject[])ProjectManager.mutex().readAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    HashSet<NbModuleProject> result = new HashSet<NbModuleProject>();
                    SuiteProject suite = SuiteUtils.findSuite(suiteComponent);
                    Set subProjects = SuiteUtils.getSubProjects(suite);
                    Iterator it = subProjects.iterator();
                    block0: while (it.hasNext()) {
                        NbModuleProject p = (NbModuleProject)it.next();
                        ProjectXMLManager pxm = new ProjectXMLManager(p);
                        Iterator depsIt = pxm.getDirectDependencies().iterator();
                        while (depsIt.hasNext()) {
                            ModuleDependency dep = (ModuleDependency)depsIt.next();
                            if (!dep.getModuleEntry().getCodeNameBase().equals(cnb)) continue;
                            result.add(p);
                            continue block0;
                        }
                    }
                    return result.toArray(new NbModuleProject[result.size()]);
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static void replaceSubModules(final SuiteProperties suiteProps) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    SuiteUtils utils = new SuiteUtils(suiteProps);
                    Set currentModules = suiteProps.getSubModules();
                    Set origSubModules = suiteProps.getOrigSubModules();
                    Iterator it = origSubModules.iterator();
                    while (it.hasNext()) {
                        NbModuleProject origModule = (NbModuleProject)it.next();
                        if (currentModules.contains(origModule)) continue;
                        Util.err.log("Removing module: " + origModule);
                        utils.removeModule(origModule);
                    }
                    it = currentModules.iterator();
                    while (it.hasNext()) {
                        NbModuleProject currentModule = (NbModuleProject)it.next();
                        if (SuiteUtils.contains(suiteProps.getProject(), currentModule)) {
                            Util.err.log("Module \"" + currentModule + "\" or a module with the same CNB is already contained in the suite.");
                            continue;
                        }
                        utils.addModule(currentModule);
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static void addModule(final SuiteProject suite, final NbModuleProject project) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    SuiteProperties suiteProps = new SuiteProperties(suite, suite.getHelper(), suite.getEvaluator(), SuiteUtils.getSubProjects(suite));
                    if (!SuiteUtils.contains(suite, project)) {
                        SuiteUtils utils = new SuiteUtils(suiteProps);
                        utils.addModule(project);
                        suiteProps.storeProperties();
                    } else {
                        Util.err.log("Module \"" + project + "\" or a module with the same CNB is already contained in the suite.");
                    }
                    ProjectManager.getDefault().saveProject((Project)suite);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static void removeModuleFromSuiteWithDependencies(final NbModuleProject suiteComponent) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    NbModuleProject[] modules = SuiteUtils.getDependentModules(suiteComponent);
                    String cnb = suiteComponent.getCodeNameBase();
                    for (int j = 0; j < modules.length; ++j) {
                        ProjectXMLManager pxm = new ProjectXMLManager(modules[j]);
                        pxm.removeDependency(cnb);
                        ProjectManager.getDefault().saveProject((Project)modules[j]);
                    }
                    SuiteUtils.removeModuleFromSuite(suiteComponent);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static void removeModuleFromSuite(final NbModuleProject suiteComponent) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    SuiteProject suite = SuiteUtils.findSuite(suiteComponent);
                    if (suite != null) {
                        SuiteProperties suiteProps = new SuiteProperties(suite, suite.getHelper(), suite.getEvaluator(), SuiteUtils.getSubProjects(suite));
                        SuiteUtils utils = new SuiteUtils(suiteProps);
                        utils.removeModule(suiteComponent);
                        suiteProps.storeProperties();
                        ProjectManager.getDefault().saveProject((Project)suite);
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private void addModule(NbModuleProject project) throws IOException, IllegalArgumentException {
        SuiteUtils.removeModuleFromSuite(project);
        this.attachSubModuleToSuite(project);
    }

    private void removeModule(final NbModuleProject subModule) {
        NbModuleTypeProvider.NbModuleType type = Util.getModuleType(subModule);
        if (!$assertionsDisabled && type != NbModuleTypeProvider.SUITE_COMPONENT) {
            throw new AssertionError((Object)"Not a suite component");
        }
        try {
            subModule.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    subModule.setRunInAtomicAction(true);
                    try {
                        EditableProperties props;
                        FileObject subModuleDir = subModule.getProjectDirectory();
                        FileObject fo = subModuleDir.getFileObject("nbproject/suite.properties");
                        if (fo != null) {
                            fo.delete();
                        }
                        if ((fo = subModuleDir.getFileObject("nbproject/private/suite-private.properties")) != null) {
                            fo.delete();
                        }
                        FileObject plafPropsFO = SuiteUtils.this.suiteProps.getProject().getProjectDirectory().getFileObject("nbproject/platform.properties");
                        FileObject subModuleNbProject = subModuleDir.getFileObject("nbproject");
                        if (subModuleNbProject.getFileObject("platform.properties") == null) {
                            FileUtil.copyFile((FileObject)plafPropsFO, (FileObject)subModuleNbProject, (String)"platform");
                        }
                        if ((props = subModule.getHelper().getProperties(SuiteUtils.PRIVATE_PLATFORM_PROPERTIES)).getProperty("user.properties.file") == null) {
                            String nbuser = System.getProperty("netbeans.user");
                            if (nbuser != null) {
                                props.setProperty("user.properties.file", new File(nbuser, "build.properties").getAbsolutePath());
                                subModule.getHelper().putProperties(SuiteUtils.PRIVATE_PLATFORM_PROPERTIES, props);
                            } else {
                                Util.err.log("netbeans.user system property is not defined. Skipping nbproject/private/platform-private.properties creation.");
                            }
                        }
                        SuiteUtils.setNbModuleType(subModule, NbModuleTypeProvider.STANDALONE);
                        ProjectManager.getDefault().saveProject((Project)subModule);
                    }
                    finally {
                        subModule.setRunInAtomicAction(false);
                    }
                }
            });
            this.removeFromProperties(subModule);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private boolean removeFromProperties(NbModuleProject moduleToRemove) {
        String modulesProp = this.suiteProps.getProperty(MODULES_PROPERTY);
        boolean removed = false;
        if (modulesProp != null) {
            ArrayList<String> pieces = new ArrayList<String>(Arrays.asList(PropertyUtils.tokenizePath((String)modulesProp)));
            Iterator piecesIt = pieces.iterator();
            while (piecesIt.hasNext()) {
                String unevaluated = (String)piecesIt.next();
                String evaluated = this.suiteProps.getEvaluator().evaluate(unevaluated);
                if (evaluated == null) {
                    Util.err.log("Cannot evaluate " + unevaluated + " property.");
                    continue;
                }
                if (moduleToRemove.getProjectDirectory() != this.suiteProps.getHelper().resolveFileObject(evaluated)) continue;
                piecesIt.remove();
                String[] newModulesProp = this.getAntProperty(pieces);
                this.suiteProps.setProperty(MODULES_PROPERTY, newModulesProp);
                removed = true;
                if (!unevaluated.matches(ANT_PURE_PROPERTY_REFERENCE_REGEXP)) break;
                String key = unevaluated.substring(2, unevaluated.length() - 1);
                this.suiteProps.removeProperty(key);
                this.suiteProps.removePrivateProperty(key);
                break;
            }
        }
        if (!removed) {
            Util.err.log("Removing of " + moduleToRemove + " was unsuccessful.");
        }
        return removed;
    }

    private void attachSubModuleToSuite(Project subModule) throws IOException {
        File projectDirF = FileUtil.toFile((FileObject)subModule.getProjectDirectory());
        File suiteDirF = this.suiteProps.getProjectDirectoryFile();
        String projectPropKey = this.generatePropertyKey(subModule);
        if (CollocationQuery.areCollocated((File)projectDirF, (File)suiteDirF)) {
            this.suiteProps.setProperty(projectPropKey, PropertyUtils.relativizeFile((File)suiteDirF, (File)projectDirF));
        } else {
            this.suiteProps.setPrivateProperty(projectPropKey, projectDirF.getAbsolutePath());
        }
        String origModules = this.suiteProps.getProperty(MODULES_PROPERTY);
        StringBuffer modules = new StringBuffer(origModules == null ? "" : origModules);
        if (modules.length() > 0) {
            modules.append(':');
        }
        modules.append("${").append(projectPropKey).append('}');
        this.suiteProps.setProperty(MODULES_PROPERTY, modules.toString().split("(?<=:)", -1));
        NbModuleProjectGenerator.createSuiteProperties(subModule.getProjectDirectory(), suiteDirF);
        SuiteUtils.setNbModuleType(subModule, NbModuleTypeProvider.SUITE_COMPONENT);
        ProjectManager.getDefault().saveProject(subModule);
    }

    private String generatePropertyKey(Project subModule) {
        String key = "project." + ProjectUtils.getInformation((Project)subModule).getName();
        Object[] keys = this.suiteProps.getProperty(MODULES_PROPERTY).split("(?<=:)", -1);
        int index = 0;
        while (Arrays.binarySearch(keys, "${" + key + "}") >= 0) {
            key = key + "_" + ++index;
        }
        return key;
    }

    private static void setNbModuleType(Project module, NbModuleTypeProvider.NbModuleType type) throws IOException {
        ProjectXMLManager pxm = new ProjectXMLManager((NbModuleProject)module);
        pxm.setModuleType(type);
    }

    private String[] getAntProperty(Collection pieces) {
        ArrayList<String> l = new ArrayList<String>();
        Iterator it = pieces.iterator();
        while (it.hasNext()) {
            String piece = (String)it.next() + (it.hasNext() ? ":" : "");
            l.add(piece);
        }
        String[] newPieces = new String[l.size()];
        return l.toArray(newPieces);
    }

    public static boolean isSuite(File maybeSuiteDir) {
        boolean isSuite = false;
        try {
            Project maybeSuite;
            FileObject dirFO = FileUtil.toFileObject((File)maybeSuiteDir);
            if (dirFO != null && (maybeSuite = ProjectManager.getDefault().findProject(dirFO)) != null) {
                isSuite = maybeSuiteDir.equals(SuiteUtils.getSuiteDirectory(maybeSuite));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isSuite;
    }

    public static SuiteProject findSuite(final Project suiteComponent) throws IOException {
        try {
            return (SuiteProject)ProjectManager.mutex().readAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    File suiteDir = SuiteUtils.getSuiteDirectory(suiteComponent);
                    return suiteDir == null ? null : ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)suiteDir));
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static boolean contains(SuiteProject suite, NbModuleProject project) {
        Set subModules = SuiteUtils.getSubProjects(suite);
        if (subModules.contains(project)) {
            return true;
        }
        Iterator it = subModules.iterator();
        while (it.hasNext()) {
            NbModuleProject p = (NbModuleProject)it.next();
            if (!p.getCodeNameBase().equals(project.getCodeNameBase())) continue;
            return true;
        }
        return false;
    }

    public static Set getSubProjects(Project suite) {
        SubprojectProvider spp = (SubprojectProvider)suite.getLookup().lookup(SubprojectProvider.class);
        return spp.getSubprojects();
    }

    public static File getSuiteDirectory(Project project) {
        File suiteDir = null;
        SuiteProvider sp = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
        if (sp != null) {
            suiteDir = sp.getSuiteDirectory();
        }
        return suiteDir;
    }

    public static String getSuiteDirectoryPath(Project project) {
        File suiteDir = SuiteUtils.getSuiteDirectory(project);
        return suiteDir != null ? suiteDir.getAbsolutePath() : null;
    }

    static {
        $assertionsDisabled = !SuiteUtils.class.desiredAssertionStatus();
    }
}

