/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class ModuleProjectClassPathExtender
implements ProjectClassPathExtender {
    private static final String LIBRARY_NAME = "swing-layout";
    private static final String MODULE_NAME = "org.jdesktop.layout";
    private final NbModuleProject project;

    public ModuleProjectClassPathExtender(NbModuleProject project) {
        this.project = project;
    }

    public boolean addLibrary(Library library) throws IOException {
        boolean cpChanged = false;
        if (library.getName().equals(LIBRARY_NAME)) {
            ModuleEntry entry = this.project.getModuleList().getEntry(MODULE_NAME);
            if (entry == null) {
                IOException e = new IOException("no module org.jdesktop.layout");
                Util.err.annotate((Throwable)e, NbBundle.getMessage((Class)ModuleProjectClassPathExtender.class, (String)"ERR_could_not_find_module", (Object)MODULE_NAME));
                throw e;
            }
        } else {
            IOException e = new IOException("unknown lib " + library.getName());
            Util.err.annotate((Throwable)e, NbBundle.getMessage((Class)ModuleProjectClassPathExtender.class, (String)"ERR_unsupported_library", (Object)library.getDisplayName()));
            throw e;
        }
        cpChanged = Util.addDependency(this.project, MODULE_NAME);
        if (cpChanged) {
            ProjectManager.getDefault().saveProject((Project)this.project);
        }
        return cpChanged;
    }

    public boolean addArchiveFile(FileObject archiveFile) throws IOException {
        IOException e = new IOException("not implemented: " + archiveFile);
        Util.err.annotate((Throwable)e, NbBundle.getMessage((Class)ModuleProjectClassPathExtender.class, (String)"ERR_jar", (Object)FileUtil.getFileDisplayName((FileObject)archiveFile)));
        throw e;
    }

    public boolean addAntArtifact(AntArtifact artifact, URI artifactElement) throws IOException {
        IOException e = new IOException("not implemented: " + artifactElement);
        String displayName = "file".equals(artifactElement.getScheme()) ? new File(artifactElement).getAbsolutePath() : artifactElement.toString();
        Util.err.annotate((Throwable)e, NbBundle.getMessage((Class)ModuleProjectClassPathExtender.class, (String)"ERR_jar", (Object)displayName));
        throw e;
    }
}

