/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.Util;
import org.openide.filesystems.FileObject;
import org.openide.modules.Dependency;

public final class ManifestManager {
    private String codeNameBase;
    private String releaseVersion;
    private String specificationVersion;
    private String implementationVersion;
    private String[] provTokens;
    private String provTokensString;
    private String[] requiredTokens;
    private String localizingBundle;
    private String layer;
    private String classPath;
    private PackageExport[] publicPackages;
    private String[] friendNames;
    private String moduleDependencies;
    private boolean deprecated;
    public static final String OPENIDE_MODULE = "OpenIDE-Module";
    public static final String OPENIDE_MODULE_SPECIFICATION_VERSION = "OpenIDE-Module-Specification-Version";
    public static final String OPENIDE_MODULE_IMPLEMENTATION_VERSION = "OpenIDE-Module-Implementation-Version";
    public static final String OPENIDE_MODULE_PROVIDES = "OpenIDE-Module-Provides";
    public static final String OPENIDE_MODULE_REQUIRES = "OpenIDE-Module-Requires";
    public static final String OPENIDE_MODULE_LAYER = "OpenIDE-Module-Layer";
    public static final String OPENIDE_MODULE_LOCALIZING_BUNDLE = "OpenIDE-Module-Localizing-Bundle";
    public static final String OPENIDE_MODULE_PUBLIC_PACKAGES = "OpenIDE-Module-Public-Packages";
    public static final String OPENIDE_MODULE_FRIENDS = "OpenIDE-Module-Friends";
    public static final String OPENIDE_MODULE_MODULE_DEPENDENCIES = "OpenIDE-Module-Module-Dependencies";
    public static final String CLASS_PATH = "Class-Path";
    static final PackageExport[] EMPTY_EXPORTED_PACKAGES = new PackageExport[0];
    public static final ManifestManager NULL_INSTANCE = new ManifestManager();

    private ManifestManager() {
        this.provTokens = new String[0];
        this.requiredTokens = new String[0];
    }

    private ManifestManager(String cnb, String releaseVersion, String specVer, String implVer, String provTokensString, String requiredTokens, String locBundle, String layer, String classPath, PackageExport[] publicPackages, String[] friendNames, boolean deprecated, String moduleDependencies) {
        this.codeNameBase = cnb;
        this.releaseVersion = releaseVersion;
        this.specificationVersion = specVer;
        this.implementationVersion = implVer;
        this.provTokensString = provTokensString;
        this.provTokens = this.parseTokens(provTokensString);
        this.requiredTokens = this.parseTokens(requiredTokens);
        this.localizingBundle = locBundle;
        this.layer = layer;
        this.classPath = classPath;
        this.publicPackages = publicPackages == null ? EMPTY_EXPORTED_PACKAGES : publicPackages;
        this.friendNames = friendNames;
        this.deprecated = deprecated;
        this.moduleDependencies = moduleDependencies;
    }

    private String[] parseTokens(String tokens) {
        if (tokens == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(tokens, ",");
        String[] result = new String[st.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = st.nextToken().trim();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManifestManager getInstance(File manifest, boolean loadPublicPackages) {
        ManifestManager mm = null;
        InputStream mis = null;
        try {
            if (manifest.exists()) {
                mis = new FileInputStream(manifest);
                Manifest mf = new Manifest(mis);
                mm = ManifestManager.getInstance(mf, loadPublicPackages);
            }
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
        }
        finally {
            try {
                if (mis != null) {
                    mis.close();
                }
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
            }
        }
        return mm == null ? new ManifestManager() : mm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManifestManager getInstanceFromJAR(File jar) {
        ManifestManager manifestManager;
        if (!jar.isFile()) {
            throw new IOException("No such JAR: " + jar);
        }
        JarFile jf = new JarFile(jar, false);
        try {
            manifestManager = ManifestManager.getInstance(jf.getManifest(), true);
        }
        catch (Throwable throwable) {
            try {
                jf.close();
                throw throwable;
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
                return new ManifestManager();
            }
        }
        jf.close();
        return manifestManager;
    }

    public static ManifestManager getInstance(Manifest manifest, boolean loadPublicPackages) {
        Attributes attr = manifest.getMainAttributes();
        String codename = attr.getValue(OPENIDE_MODULE);
        String codenamebase = null;
        String releaseVersion = null;
        if (codename != null) {
            int slash = codename.lastIndexOf(47);
            if (slash == -1) {
                codenamebase = codename;
            } else {
                codenamebase = codename.substring(0, slash);
                releaseVersion = codename.substring(slash + 1);
            }
        }
        PackageExport[] publicPackages = null;
        String[] friendNames = null;
        if (loadPublicPackages) {
            String friends;
            publicPackages = EMPTY_EXPORTED_PACKAGES;
            String pp = attr.getValue(OPENIDE_MODULE_PUBLIC_PACKAGES);
            if (pp != null) {
                publicPackages = ManifestManager.parseExportedPackages(pp);
            }
            if ((friends = attr.getValue(OPENIDE_MODULE_FRIENDS)) != null && (friendNames = ManifestManager.parseFriends(friends)).length > 0 && publicPackages.length == 0) {
                throw new IllegalArgumentException("No use specifying OpenIDE-Module-Friends without any public packages: " + friends);
            }
        }
        boolean deprecated = "true".equals(attr.getValue("OpenIDE-Module-Deprecated"));
        ManifestManager mm = new ManifestManager(codenamebase, releaseVersion, attr.getValue(OPENIDE_MODULE_SPECIFICATION_VERSION), attr.getValue(OPENIDE_MODULE_IMPLEMENTATION_VERSION), attr.getValue(OPENIDE_MODULE_PROVIDES), attr.getValue(OPENIDE_MODULE_REQUIRES), attr.getValue(OPENIDE_MODULE_LOCALIZING_BUNDLE), attr.getValue(OPENIDE_MODULE_LAYER), attr.getValue(CLASS_PATH), publicPackages, friendNames, deprecated, attr.getValue(OPENIDE_MODULE_MODULE_DEPENDENCIES));
        return mm;
    }

    static void createManifest(FileObject manifest, String cnb, String specVer, String bundlePath, String layerPath) throws IOException {
        EditableManifest em = new EditableManifest();
        em.setAttribute(OPENIDE_MODULE, cnb, null);
        em.setAttribute(OPENIDE_MODULE_SPECIFICATION_VERSION, specVer, null);
        em.setAttribute(OPENIDE_MODULE_LOCALIZING_BUNDLE, bundlePath, null);
        if (layerPath != null) {
            em.setAttribute(OPENIDE_MODULE_LAYER, layerPath, null);
        }
        Util.storeManifest(manifest, em);
    }

    private static PackageExport[] parseExportedPackages(String exportsS) {
        PackageExport[] exportedPackages = null;
        if (exportsS.trim().equals("-")) {
            exportedPackages = EMPTY_EXPORTED_PACKAGES;
        } else {
            StringTokenizer tok = new StringTokenizer(exportsS, ", ");
            ArrayList<PackageExport> exports = new ArrayList<PackageExport>(Math.max(tok.countTokens(), 1));
            while (tok.hasMoreTokens()) {
                String pkg;
                String piece = tok.nextToken();
                if (piece.endsWith(".*")) {
                    pkg = piece.substring(0, piece.length() - 2);
                    Dependency.create((int)1, (String)pkg);
                    if (pkg.lastIndexOf(47) != -1) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
                    }
                    exports.add(new PackageExport(pkg, false));
                    continue;
                }
                if (piece.endsWith(".**")) {
                    pkg = piece.substring(0, piece.length() - 3);
                    Dependency.create((int)1, (String)pkg);
                    if (pkg.lastIndexOf(47) != -1) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
                    }
                    exports.add(new PackageExport(pkg, true));
                    continue;
                }
                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
            }
            if (exports.isEmpty()) {
                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
            }
            exportedPackages = exports.toArray(new PackageExport[exports.size()]);
        }
        return exportedPackages;
    }

    private static String[] parseFriends(String friends) {
        HashSet<String> set = new HashSet<String>();
        StringTokenizer tok = new StringTokenizer(friends, ", ");
        while (tok.hasMoreTokens()) {
            String piece = tok.nextToken();
            if (piece.indexOf(47) != -1) {
                throw new IllegalArgumentException("May specify only module code name bases in OpenIDE-Module-Friends, not major release versions: " + piece);
            }
            Dependency.create((int)1, (String)piece);
            set.add(piece);
        }
        if (set.isEmpty()) {
            throw new IllegalArgumentException("Empty OpenIDE-Module-Friends: " + friends);
        }
        return set.toArray(new String[set.size()]);
    }

    public String getCodeNameBase() {
        return this.codeNameBase;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public String getProvidedTokensString() {
        return this.provTokensString;
    }

    public String[] getProvidedTokens() {
        return this.provTokens;
    }

    public String[] getRequiredTokens() {
        return this.requiredTokens;
    }

    public String getLocalizingBundle() {
        return this.localizingBundle;
    }

    public String getLayer() {
        return this.layer;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public PackageExport[] getPublicPackages() {
        return this.publicPackages;
    }

    public String[] getFriends() {
        return this.friendNames;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public Set getModuleDependencies() {
        if (this.moduleDependencies != null) {
            return Dependency.create((int)1, (String)this.moduleDependencies);
        }
        return Collections.EMPTY_SET;
    }

    public static final class PackageExport {
        private final String pkg;
        private final boolean recursive;

        public PackageExport(String pkg, boolean recursive) {
            this.pkg = pkg;
            this.recursive = recursive;
        }

        public String getPackage() {
            return this.pkg;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public String toString() {
            return "PackageExport[" + this.pkg + (this.recursive ? "/**" : "") + "]";
        }
    }
}

