/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.blueprints.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JTextPane;
import org.netbeans.modules.j2ee.blueprints.catalog.bpcatalogxmlparser.Nbcategory;
import org.netbeans.modules.j2ee.blueprints.ui.BluePrintsPanel;
import org.netbeans.modules.j2ee.blueprints.ui.BluePrintsTabPanel;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;

public class ExampleTab
extends BluePrintsTabPanel {
    private JButton installBtn;
    private JTextPane launchExampleText;
    private static final String OPEN_SAMPLE_ACTION = "org-netbeans-modules-project-ui-WelcomeScreenHack/org-netbeans-modules-project-ui-NewSample.instance";
    private static final String BUNDLE_PROPERTY_PREFIX = "Samples/Blueprints";
    private static final String PRESELECT_CATEGORY = "PRESELECT_CATEGORY";
    private static final String PRESELECT_TEMPLATE = "PRESELECT_TEMPLATE";

    public ExampleTab(BluePrintsPanel bluePrintsPanel) {
        super(bluePrintsPanel);
        this.initComponents();
    }

    private void initComponents() {
        this.launchExampleText = new JTextPane();
        this.installBtn = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.launchExampleText.setEditable(false);
        this.launchExampleText.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString("launchExampleText"));
        this.launchExampleText.setMargin(new Insets(12, 12, 12, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 7, 0);
        this.add((Component)this.launchExampleText, gridBagConstraints);
        this.installBtn.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString("launchBtn"));
        this.installBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExampleTab.this.installBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.installBtn, gridBagConstraints);
    }

    private void installBtnActionPerformed(ActionEvent evt) {
        this.installExample();
    }

    public void setScrollPosition(int scrollPosition) {
    }

    public int getScrollPosition() {
        return 0;
    }

    public void updateTab() {
    }

    private void installExample() {
        this.performAction(OPEN_SAMPLE_ACTION, "");
    }

    private Action findAction(String key) {
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(key);
        if (fo != null && fo.isValid()) {
            try {
                Object instance;
                DataObject dob = DataObject.find((FileObject)fo);
                InstanceCookie ic = (InstanceCookie)dob.getCookie(InstanceCookie.class);
                if (ic != null && (instance = ic.instanceCreate()) instanceof Action) {
                    return (Action)instance;
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private boolean performAction(String key, String command) {
        Action a = this.findAction(key);
        if (a == null) {
            return false;
        }
        Nbcategory category = this.bluePrintsPanel.getSelectedCategory();
        String categoryId = category.getId();
        if (category.getShowSpec().equals("true")) {
            categoryId = category.getSpec() + "/" + categoryId;
        }
        a.putValue(PRESELECT_CATEGORY, "Samples/Blueprints/" + categoryId);
        a.putValue(PRESELECT_TEMPLATE, this.bluePrintsPanel.getExampleId());
        ActionEvent ae = new ActionEvent(this, 1001, command);
        try {
            a.actionPerformed(ae);
            return true;
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
            return false;
        }
    }
}

