/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.clientproject.AppClientActionProvider;
import org.netbeans.modules.j2ee.clientproject.AppClientFileBuiltQuery;
import org.netbeans.modules.j2ee.clientproject.AppClientPersistenceProvider;
import org.netbeans.modules.j2ee.clientproject.AppClientProjectOperations;
import org.netbeans.modules.j2ee.clientproject.AppClientProvider;
import org.netbeans.modules.j2ee.clientproject.AppClientSharabilityQuery;
import org.netbeans.modules.j2ee.clientproject.AppClientSources;
import org.netbeans.modules.j2ee.clientproject.JarContainerImpl;
import org.netbeans.modules.j2ee.clientproject.MainClassUpdater;
import org.netbeans.modules.j2ee.clientproject.ProjectAppClientProvider;
import org.netbeans.modules.j2ee.clientproject.SourceRoots;
import org.netbeans.modules.j2ee.clientproject.UpdateHelper;
import org.netbeans.modules.j2ee.clientproject.Utils;
import org.netbeans.modules.j2ee.clientproject.classpath.AppClientProjectClassPathExtender;
import org.netbeans.modules.j2ee.clientproject.classpath.ClassPathProviderImpl;
import org.netbeans.modules.j2ee.clientproject.queries.CompiledSourceForBinaryQuery;
import org.netbeans.modules.j2ee.clientproject.queries.JavadocForBinaryQueryImpl;
import org.netbeans.modules.j2ee.clientproject.queries.SourceLevelQueryImpl;
import org.netbeans.modules.j2ee.clientproject.queries.UnitTestForSourceQueryImpl;
import org.netbeans.modules.j2ee.clientproject.ui.AppClientLogicalViewProvider;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.AppClientProjectProperties;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.j2ee.clientproject.wsclient.AppClientProjectJAXWSClientSupport;
import org.netbeans.modules.j2ee.clientproject.wsclient.AppClientProjectWebServicesClientSupport;
import org.netbeans.modules.j2ee.clientproject.wsclient.AppClientProjectWebServicesSupportProvider;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.spi.ejbjar.CarFactory;
import org.netbeans.modules.j2ee.spi.ejbjar.CarImplementation;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.GeneratedFilesHelper;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModelProvider;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportFactory;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportImpl;
import org.netbeans.modules.websvc.spi.jaxws.client.JAXWSClientSupportFactory;
import org.netbeans.modules.websvc.spi.jaxws.client.JAXWSClientSupportImpl;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class AppClientProject
implements Project,
AntProjectListener,
FileChangeListener {
    private static final Icon CAR_PROJECT_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/j2ee/clientproject/ui/resources/appclient.gif"));
    private final AuxiliaryConfiguration aux;
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final ReferenceHelper refHelper;
    private final GeneratedFilesHelper genFilesHelper;
    private final Lookup lookup;
    private final UpdateHelper updateHelper;
    private MainClassUpdater mainClassUpdater;
    private SourceRoots sourceRoots;
    private SourceRoots testRoots;
    private AppClientProjectWebServicesClientSupport carProjectWebServicesClientSupport;
    private AppClientProjectJAXWSClientSupport jaxWsClientSupport;
    private WebServicesClientSupport apiWebServicesClientSupport;
    private JAXWSClientSupport apiJAXWSClientSupport;
    private JaxWsModel jaxWsModel;
    private JaxWsListener jaxWsListener;
    private FileObject jaxWsFo;
    private PropertyChangeListener j2eePlatformListener;
    private final AppClientProvider appClient;
    private final Car apiJar;
    private JarContainerImpl enterpriseResourceSupport;
    private FileObject libFolder;
    private final AppClientProjectClassPathExtender classpathExtender;

    AppClientProject(AntProjectHelper helper) throws IOException {
        this.helper = helper;
        this.eval = this.createEvaluator();
        this.aux = helper.createAuxiliaryConfiguration();
        this.refHelper = new ReferenceHelper(helper, this.aux, this.eval);
        this.genFilesHelper = new GeneratedFilesHelper(helper);
        this.updateHelper = new UpdateHelper(this, this.helper, this.aux, this.genFilesHelper, UpdateHelper.createDefaultNotifier());
        this.carProjectWebServicesClientSupport = new AppClientProjectWebServicesClientSupport(this, helper, this.refHelper);
        this.jaxWsClientSupport = new AppClientProjectJAXWSClientSupport(this, helper);
        this.apiWebServicesClientSupport = WebServicesClientSupportFactory.createWebServicesClientSupport((WebServicesClientSupportImpl)this.carProjectWebServicesClientSupport);
        this.apiJAXWSClientSupport = JAXWSClientSupportFactory.createJAXWSClientSupport((JAXWSClientSupportImpl)this.jaxWsClientSupport);
        this.appClient = new AppClientProvider(this, helper);
        this.apiJar = CarFactory.createCar((CarImplementation)this.appClient);
        this.enterpriseResourceSupport = new JarContainerImpl(this, this.refHelper, helper);
        this.classpathExtender = new AppClientProjectClassPathExtender(this, this.updateHelper, this.evaluator(), this.refHelper);
        this.lookup = this.createLookup(this.aux);
        helper.addAntProjectListener((AntProjectListener)this);
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public String toString() {
        return "CarProject[" + this.getProjectDirectory() + "]";
    }

    private PropertyEvaluator createEvaluator() {
        return this.helper.getStandardPropertyEvaluator();
    }

    PropertyEvaluator evaluator() {
        return this.eval;
    }

    public ReferenceHelper getReferenceHelper() {
        return this.refHelper;
    }

    public UpdateHelper getUpdateHelper() {
        return this.updateHelper;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    private Lookup createLookup(AuxiliaryConfiguration aux) {
        SubprojectProvider spp = this.refHelper.createSubprojectProvider();
        final SourcesHelper sourcesHelper = new SourcesHelper(this.helper, this.evaluator());
        String configFilesLabel = NbBundle.getMessage(AppClientLogicalViewProvider.class, (String)"LBL_Node_ConfFiles");
        sourcesHelper.addPrincipalSourceRoot("${meta.inf}", configFilesLabel, null, null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                sourcesHelper.registerExternalRoots(0);
            }
        });
        return Lookups.fixed((Object[])new Object[]{new Info(), aux, this.helper.createCacheDirectoryProvider(), spp, new AppClientActionProvider(this, this.helper, this.updateHelper), new AppClientLogicalViewProvider(this, this.updateHelper, this.evaluator(), this.refHelper), new CustomizerProviderImpl(this, this.updateHelper, this.evaluator(), this.refHelper, this.genFilesHelper), new ClassPathProviderImpl(this.helper, this.evaluator(), this.getSourceRoots(), this.getTestSourceRoots()), new CompiledSourceForBinaryQuery(this.helper, this.evaluator(), this.getSourceRoots(), this.getTestSourceRoots()), new JavadocForBinaryQueryImpl(this.helper, this.evaluator()), new AntArtifactProviderImpl(), new ProjectXmlSavedHookImpl(), new ProjectOpenedHookImpl(), new UnitTestForSourceQueryImpl(this.getSourceRoots(), this.getTestSourceRoots()), new SourceLevelQueryImpl(this.evaluator()), new AppClientSources(this.helper, this.evaluator(), this.getSourceRoots(), this.getTestSourceRoots()), new AppClientSharabilityQuery(this.helper, this.evaluator(), this.getSourceRoots(), this.getTestSourceRoots()), new AppClientFileBuiltQuery(this.helper, this.evaluator(), this.getSourceRoots(), this.getTestSourceRoots()), new RecommendedTemplatesImpl(this.updateHelper), this.classpathExtender, this, new AppClientProjectOperations(this), new AppClientProjectWebServicesSupportProvider(), new ProjectAppClientProvider(this), this.appClient, new AppClientPersistenceProvider(this, this.evaluator()), this.enterpriseResourceSupport, this.getJaxWsModel()});
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        if (ev.getPath().equals("nbproject/project.xml")) {
            Info info = (Info)this.getLookup().lookup(ProjectInformation.class);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    public synchronized SourceRoots getSourceRoots() {
        if (this.sourceRoots == null) {
            this.sourceRoots = new SourceRoots(this.updateHelper, this.evaluator(), this.getReferenceHelper(), "source-roots", false, "src.{0}{1}.dir");
        }
        return this.sourceRoots;
    }

    public synchronized SourceRoots getTestSourceRoots() {
        if (this.testRoots == null) {
            this.testRoots = new SourceRoots(this.updateHelper, this.evaluator(), this.getReferenceHelper(), "test-roots", true, "test.{0}{1}.dir");
        }
        return this.testRoots;
    }

    File getTestClassesDirectory() {
        String testClassesDir = this.evaluator().getProperty("build.test.classes.dir");
        if (testClassesDir == null) {
            return null;
        }
        return this.helper.resolveFile(testClassesDir);
    }

    public void setName(final String name) {
        ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                Element nameEl;
                Element data = AppClientProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/car-project/1", "name");
                if (nl.getLength() == 1) {
                    nameEl = (Element)nl.item(0);
                    NodeList deadKids = nameEl.getChildNodes();
                    while (deadKids.getLength() > 0) {
                        nameEl.removeChild(deadKids.item(0));
                    }
                } else {
                    nameEl = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/car-project/1", "name");
                    data.insertBefore(nameEl, data.getChildNodes().item(0));
                }
                nameEl.appendChild(data.getOwnerDocument().createTextNode(name));
                AppClientProject.this.helper.putPrimaryConfigurationData(data, true);
                return null;
            }
        });
    }

    public String getName() {
        return (String)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                Element data = AppClientProject.this.updateHelper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/car-project/1", "name");
                if (nl.getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                    return ((Text)nl.item(0)).getNodeValue();
                }
                return "CAR???";
            }
        });
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
        FileObject fo = fe.getFile();
        this.checkLibraryFolder(fo);
    }

    public void fileDeleted(FileEvent fe) {
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileRenamed(FileRenameEvent fe) {
        FileObject fo = fe.getFile();
        this.checkLibraryFolder(fo);
    }

    private void checkLibraryFolder(FileObject fo) {
        if (!FileUtil.isArchiveFile((FileObject)fo)) {
            return;
        }
        if (fo.getParent().equals(this.libFolder)) {
            try {
                this.classpathExtender.addArchiveFile(fo);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    public void registerJ2eePlatformListener(final J2eePlatform platform) {
        this.j2eePlatformListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("classpath")) {
                    ProjectManager.mutex().writeAccess(new Mutex.Action(){

                        public Object run() {
                            EditableProperties ep = AppClientProject.this.helper.getProperties("nbproject/private/private.properties");
                            String classpath = Utils.toClasspathString(platform.getClasspathEntries());
                            ep.setProperty("j2ee.platform.classpath", classpath);
                            AppClientProject.this.helper.putProperties("nbproject/private/private.properties", ep);
                            try {
                                ProjectManager.getDefault().saveProject((Project)AppClientProject.this);
                            }
                            catch (IOException e) {
                                ErrorManager.getDefault().notify((Throwable)e);
                            }
                            return null;
                        }
                    });
                }
            }
        };
        platform.addPropertyChangeListener(this.j2eePlatformListener);
    }

    public void unregisterJ2eePlatformListener(J2eePlatform platform) {
        if (this.j2eePlatformListener != null) {
            platform.removePropertyChangeListener(this.j2eePlatformListener);
        }
    }

    public Car getAPICar() {
        return this.apiJar;
    }

    public AppClientProvider getCarModule() {
        return this.appClient;
    }

    private String getProperty(String path, String name) {
        return this.helper.getProperties(path).getProperty(name);
    }

    String getBuildXmlName() {
        String storedName = this.helper.getStandardPropertyEvaluator().getProperty("buildfile");
        return storedName == null ? "build.xml" : storedName;
    }

    private void refreshBuildImplXml(int askUserIfFlags, boolean askInCurrentThread) {
        int flags = this.genFilesHelper.getBuildScriptState("nbproject/build-impl.xml", AppClientProject.class.getResource("resources/build-impl.xsl"), this.jaxWsFo);
        if ((flags & (askUserIfFlags |= 4)) == askUserIfFlags) {
            Runnable run = new Runnable(){

                public void run() {
                    JButton updateOption = new JButton(NbBundle.getMessage(AppClientProject.class, (String)"CTL_Regenerate"));
                    if (DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(AppClientProject.class, (String)"TXT_BuildImplRegenerate"), NbBundle.getMessage(AppClientProject.class, (String)"TXT_BuildImplRegenerateTitle"), -1, 2, new Object[]{updateOption, NotifyDescriptor.CANCEL_OPTION}, (Object)updateOption)) == updateOption) {
                        try {
                            AppClientProject.this.genFilesHelper.generateBuildScriptFromStylesheet("nbproject/build-impl.xml", AppClientProject.class.getResource("resources/build-impl.xsl"), AppClientProject.this.jaxWsFo);
                        }
                        catch (IOException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                        catch (IllegalStateException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                    }
                }
            };
            if (askInCurrentThread) {
                run.run();
            } else {
                RequestProcessor.getDefault().post(run);
            }
        } else {
            try {
                this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", AppClientProject.class.getResource("resources/build-impl.xsl"), this.jaxWsFo, false);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    public WebServicesClientSupport getAPIWebServicesClientSupport() {
        return this.apiWebServicesClientSupport;
    }

    public JAXWSClientSupport getAPIJAXWSClientSupport() {
        return this.apiJAXWSClientSupport;
    }

    public void createJaxWsFileObject() throws IOException {
        FileObject projectDir = this.helper.getProjectDirectory();
        WSUtils.retrieveJaxWsFromResource((FileObject)projectDir);
        this.jaxWsFo = this.findJaxWsFileObject(projectDir);
        if (this.jaxWsFo != null) {
            this.jaxWsListener = new JaxWsListener();
            this.jaxWsFo.addFileChangeListener((FileChangeListener)this.jaxWsListener);
            if (this.jaxWsModel != null) {
                this.jaxWsModel.setJaxWsFile(this.jaxWsFo);
            } else {
                this.jaxWsModel = JaxWsModelProvider.getDefault().getJaxWsModel(this.jaxWsFo);
            }
        }
    }

    private JaxWsModel getJaxWsModel() {
        if (this.jaxWsModel == null) {
            try {
                final FileObject projectDir = this.helper.getProjectDirectory();
                this.jaxWsFo = this.findJaxWsFileObject(projectDir);
                if (this.jaxWsFo == null) {
                    this.jaxWsModel = JaxWsModelProvider.getDefault().getJaxWsModel(WSUtils.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/jax-ws.xml"));
                    this.jaxWsModel.setJaxWsFile(projectDir);
                } else {
                    this.jaxWsListener = new JaxWsListener();
                    try {
                        this.jaxWsModel = JaxWsModelProvider.getDefault().getJaxWsModel(this.jaxWsFo);
                        this.jaxWsFo.addFileChangeListener((FileChangeListener)this.jaxWsListener);
                    }
                    catch (RuntimeException ex) {
                        this.jaxWsModel = JaxWsModelProvider.getDefault().getJaxWsModel(WSUtils.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/jax-ws.xml"));
                        this.jaxWsModel.setJaxWsFile(projectDir);
                        final FileObject oldJaxWsFo = this.jaxWsFo;
                        this.jaxWsFo = null;
                        final RuntimeException exception = ex;
                        RequestProcessor.getDefault().post(new Runnable(){

                            public void run() {
                                try {
                                    AppClientProject.this.jaxWsFo = WSUtils.backupAndGenerateJaxWs((FileObject)projectDir, (FileObject)oldJaxWsFo, (RuntimeException)exception);
                                    if (AppClientProject.this.jaxWsFo != null) {
                                        AppClientProject.this.jaxWsModel.setJaxWsFile(AppClientProject.this.jaxWsFo);
                                        AppClientProject.this.jaxWsFo.addFileChangeListener((FileChangeListener)AppClientProject.this.jaxWsListener);
                                    }
                                }
                                catch (IOException ex) {
                                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                                }
                            }
                        });
                    }
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
        }
        return this.jaxWsModel;
    }

    public FileObject findJaxWsFileObject() {
        return this.findJaxWsFileObject(this.helper.getProjectDirectory());
    }

    private FileObject findJaxWsFileObject(FileObject projectDir) {
        return projectDir.getFileObject("nbproject/jax-ws.xml");
    }

    private class JaxWsListener
    extends FileChangeAdapter {
        private JaxWsListener() {
        }

        public void fileChanged(FileEvent fe) {
            try {
                final JaxWsModel newModel = JaxWsModelProvider.getDefault().getJaxWsModel(fe.getFile());
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (AppClientProject.this.jaxWsModel != null && newModel != null) {
                            AppClientProject.this.jaxWsModel.merge(newModel);
                        }
                        try {
                            AppClientProject.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", AppClientProject.class.getResource("resources/build-impl.xsl"), AppClientProject.this.jaxWsFo, false);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private final class CarAntArtifact
    extends AntArtifact {
        private final AntArtifact impl;

        CarAntArtifact(AntArtifact aa) {
            this.impl = aa;
        }

        public String getID() {
            if ("j2ee_ear_archive".equals(this.getType())) {
                return "j2ee-module-car";
            }
            return this.impl.getID();
        }

        public String getType() {
            return this.impl.getType();
        }

        public String getTargetName() {
            return this.impl.getTargetName();
        }

        public File getScriptLocation() {
            return this.impl.getScriptLocation();
        }

        public String getCleanTargetName() {
            return this.impl.getCleanTargetName();
        }

        public URI[] getArtifactLocations() {
            return this.impl.getArtifactLocations();
        }

        public Project getProject() {
            return this.impl.getProject();
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private final transient UpdateHelper helper;
        private transient boolean isArchive = false;
        private static final String[] APPLICATION_TYPES = new String[]{"java-classes", "java-main-class", "j2ee-types", "java-forms", "gui-java-application", "java-beans", "persistence", "oasis-XML-catalogs", "XML", "ant-script", "ant-task", "web-service-clients", "wsdl", "sunresource-types", "junit", "simple-files"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/Classes/Class.java", "Templates/Classes/Package", "Templates/Classes/Interface.java", "Templates/GUIForms/JPanel.java", "Templates/GUIForms/JFrame.java", "Templates/J2EE/CachingServiceLocator.java", "Templates/WebServices/WebServiceClient"};
        private static final String[] APPLICATION_TYPES_ARCHIVE = new String[]{"deployment-descriptor", "XML"};
        private static final String[] PRIVILEGED_NAMES_ARCHIVE = new String[]{"Templates/J2EE/applicationClientXml,"};
        private transient boolean checked = false;

        RecommendedTemplatesImpl(UpdateHelper helper) {
            this.helper = helper;
        }

        public String[] getRecommendedTypes() {
            String[] retVal = null;
            this.checkEnvironment();
            retVal = this.isArchive ? (String[])APPLICATION_TYPES_ARCHIVE.clone() : (String[])APPLICATION_TYPES.clone();
            return retVal;
        }

        public String[] getPrivilegedTemplates() {
            String[] retVal = null;
            this.checkEnvironment();
            retVal = this.isArchive ? (String[])PRIVILEGED_NAMES_ARCHIVE.clone() : (String[])PRIVILEGED_NAMES.clone();
            return retVal;
        }

        private void checkEnvironment() {
            if (!this.checked) {
                String srcType = this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("java.source.based");
                if ("false".equals(srcType)) {
                    this.isArchive = true;
                }
                this.checked = true;
            }
        }
    }

    private final class AntArtifactProviderImpl
    implements AntArtifactProvider {
        private AntArtifactProviderImpl() {
        }

        public AntArtifact[] getBuildArtifacts() {
            return new AntArtifact[]{AppClientProject.this.helper.createSimpleAntArtifact("jar", "dist.jar", AppClientProject.this.helper.getStandardPropertyEvaluator(), "dist", "clean"), new CarAntArtifact(AppClientProject.this.helper.createSimpleAntArtifact("j2ee_ear_archive", "dist.ear.jar", AppClientProject.this.helper.getStandardPropertyEvaluator(), "dist-ear", "clean-ear"))};
        }
    }

    final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        ProjectOpenedHookImpl() {
        }

        protected void projectOpened() {
            try {
                String libFolderName = AppClientProject.this.helper.getStandardPropertyEvaluator().getProperty("lib.dir");
                try {
                    FileObject ddFO = AppClientProject.this.appClient.getDeploymentDescriptor();
                    if (ddFO != null) {
                        DataObject.find((FileObject)ddFO);
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    // empty catch block
                }
                if (libFolderName != null && AppClientProject.this.helper.resolveFile(libFolderName).isDirectory()) {
                    AppClientProject.this.libFolder = AppClientProject.this.helper.resolveFileObject(libFolderName);
                    FileObject[] children = AppClientProject.this.libFolder.getChildren();
                    LinkedList<FileObject> libs = new LinkedList<FileObject>();
                    for (int i = 0; i < children.length; ++i) {
                        if (!FileUtil.isArchiveFile((FileObject)children[i])) continue;
                        libs.add(children[i]);
                    }
                    FileObject[] libsArray = new FileObject[libs.size()];
                    libs.toArray(libsArray);
                    AppClientProject.this.classpathExtender.addArchiveFiles("javac.classpath", libsArray, "included-library");
                    AppClientProject.this.libFolder.addFileChangeListener((FileChangeListener)AppClientProject.this);
                }
                AppClientProject.this.refreshBuildImplXml(8, true);
                AppClientProject.this.genFilesHelper.refreshBuildScript(AppClientProject.this.getBuildXmlName(), AppClientProject.class.getResource("resources/build.xsl"), AppClientProject.this.jaxWsFo, true);
                String servInstID = AppClientProject.this.getProperty("nbproject/private/private.properties", "j2ee.server.instance");
                J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(servInstID);
                if (platform != null) {
                    AppClientProjectProperties.setServerInstance(AppClientProject.this, AppClientProject.this.helper, servInstID);
                } else {
                    String[] servInstIDs;
                    String serverType = AppClientProject.this.getProperty("nbproject/project.properties", "j2ee.server.type");
                    if (serverType != null && (servInstIDs = Deployment.getDefault().getInstancesOfServer(serverType)).length > 0) {
                        AppClientProjectProperties.setServerInstance(AppClientProject.this, AppClientProject.this.helper, servInstIDs[0]);
                        platform = Deployment.getDefault().getJ2eePlatform(servInstIDs[0]);
                    }
                    if (platform == null) {
                        BrokenServerSupport.showAlert();
                    }
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)AppClientProject.this.lookup.lookup(ClassPathProviderImpl.class);
            GlobalPathRegistry.getDefault().register("classpath/boot", cpProvider.getProjectClassPaths("classpath/boot"));
            GlobalPathRegistry.getDefault().register("classpath/source", cpProvider.getProjectClassPaths("classpath/source"));
            GlobalPathRegistry.getDefault().register("classpath/compile", cpProvider.getProjectClassPaths("classpath/compile"));
            AppClientProject.this.appClient.getConfigSupport().ensureConfigurationReady();
            AppClientProject.this.mainClassUpdater = new MainClassUpdater(AppClientProject.this, AppClientProject.this.eval, AppClientProject.this.updateHelper, cpProvider.getProjectClassPaths("classpath/source")[0], "main.class");
            ProjectManager.mutex().writeAccess(new Mutex.Action(){

                public Object run() {
                    EditableProperties ep = AppClientProject.this.updateHelper.getProperties("nbproject/private/private.properties");
                    File buildProperties = new File(System.getProperty("netbeans.user"), "build.properties");
                    ep.setProperty("user.properties.file", buildProperties.getAbsolutePath());
                    AppClientProject.this.updateHelper.putProperties("nbproject/private/private.properties", ep);
                    try {
                        ProjectManager.getDefault().saveProject((Project)AppClientProject.this);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    return null;
                }
            });
            AppClientLogicalViewProvider physicalViewProvider = (AppClientLogicalViewProvider)AppClientProject.this.getLookup().lookup(AppClientLogicalViewProvider.class);
            if (physicalViewProvider != null && physicalViewProvider.hasBrokenLinks()) {
                BrokenReferencesSupport.showAlert();
            }
        }

        protected void projectClosed() {
            String servInstID = AppClientProject.this.getProperty("nbproject/private/private.properties", "j2ee.server.instance");
            J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(servInstID);
            if (platform != null) {
                AppClientProject.this.unregisterJ2eePlatformListener(platform);
            }
            if (AppClientProject.this.jaxWsFo != null) {
                AppClientProject.this.jaxWsFo.removeFileChangeListener((FileChangeListener)AppClientProject.this.jaxWsListener);
            }
            try {
                ProjectManager.getDefault().saveProject((Project)AppClientProject.this);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)AppClientProject.this.lookup.lookup(ClassPathProviderImpl.class);
            GlobalPathRegistry.getDefault().unregister("classpath/boot", cpProvider.getProjectClassPaths("classpath/boot"));
            GlobalPathRegistry.getDefault().unregister("classpath/source", cpProvider.getProjectClassPaths("classpath/source"));
            GlobalPathRegistry.getDefault().unregister("classpath/compile", cpProvider.getProjectClassPaths("classpath/compile"));
            if (AppClientProject.this.mainClassUpdater != null) {
                AppClientProject.this.mainClassUpdater.unregister();
                AppClientProject.this.mainClassUpdater = null;
            }
        }
    }

    private final class ProjectXmlSavedHookImpl
    extends ProjectXmlSavedHook {
        ProjectXmlSavedHookImpl() {
        }

        protected void projectXmlSaved() throws IOException {
            AppClientProject.this.refreshBuildImplXml(0, false);
            AppClientProject.this.genFilesHelper.refreshBuildScript(AppClientProject.this.getBuildXmlName(), AppClientProject.class.getResource("resources/build.xsl"), AppClientProject.this.jaxWsFo, false);
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
        }

        void firePropertyChange(String prop) {
            this.pcs.firePropertyChange(prop, null, null);
        }

        public String getName() {
            return PropertyUtils.getUsablePropertyName((String)this.getDisplayName());
        }

        public String getDisplayName() {
            return (String)ProjectManager.mutex().readAccess(new Mutex.Action(){

                public Object run() {
                    Element data = AppClientProject.this.updateHelper.getPrimaryConfigurationData(true);
                    NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/car-project/1", "name");
                    if (nl.getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                        return ((Text)nl.item(0)).getNodeValue();
                    }
                    return "???";
                }
            });
        }

        public Icon getIcon() {
            return CAR_PROJECT_ICON;
        }

        public Project getProject() {
            return AppClientProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }
}

