/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.xml.retriever.DocumentTypeSchemaWsdlParser;
import org.netbeans.modules.xml.retriever.ResourceRetriever;
import org.netbeans.modules.xml.retriever.ResourceRetrieverFactory;
import org.netbeans.modules.xml.retriever.RetrieveEntry;
import org.netbeans.modules.xml.retriever.RetrieverEngine;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetrieverTask {
    private File saveFile;
    private String baseAddress;
    private String sourceToBeGot;
    private RetrieveEntry rent;
    private RetrieverEngine retEngine = null;

    public RetrieverTask(RetrieveEntry rent, RetrieverEngine retEngine) {
        this.retEngine = retEngine;
        this.sourceToBeGot = rent.getCurrentAddress();
        this.baseAddress = rent.getBaseAddress();
        this.saveFile = rent.getSaveFile();
        this.rent = rent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, File> goGetIt() throws IOException, URISyntaxException {
        Class<RetrieverTask> clazz = RetrieverTask.class;
        synchronized (RetrieverTask.class) {
            if (this.saveFile != null && this.saveFile.isFile() && this.saveFile.length() != 0L) {
                throw new IOException("File already exists");
            }
            ResourceRetriever rr = ResourceRetrieverFactory.getResourceRetriever(this.baseAddress, this.sourceToBeGot);
            if (rr == null) {
                throw new RuntimeException("No Retriever for this Resource address :" + this.sourceToBeGot);
            }
            if (this.isAlreadyDownloadedInThisSession(rr.getEffectiveAddress(this.baseAddress, this.sourceToBeGot))) {
                String fileExists = NbBundle.getMessage(RetrieverTask.class, (String)"EXCEPTION_CYCLIC_REFERENCE_INDICATOR");
                throw new IOException(fileExists);
            }
            HashMap<String, InputStream> srcAddrNContent = rr.retrieveDocument(this.baseAddress, this.sourceToBeGot);
            if (srcAddrNContent == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            String effectiveSrcAddr = srcAddrNContent.keySet().iterator().next();
            InputStream is = srcAddrNContent.get(effectiveSrcAddr);
            if (this.saveFile == null) {
                this.saveFile = this.guessSaveFile(this.rent);
            }
            if (this.saveFile == null) {
                throw new IOException("Could not determine the save file.");
            }
            this.checkForCycle(this.saveFile, rr.getStreamLength(), is);
            if (this.retEngine.isSave2SingleFolder() && !this.retEngine.getFileOverwrite()) {
                int i = 0;
                File curFile = this.saveFile;
                String fileName = this.saveFile.getName();
                while (curFile.isFile()) {
                    curFile = new File(this.retEngine.getCurrentSaveRootFile() + File.separator + "new" + i++ + fileName);
                }
                this.saveFile = curFile;
            }
            BufferedInputStream bis = new BufferedInputStream(is, 1024);
            FileObject saveFileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.saveFile));
            this.saveFile.getParentFile().mkdirs();
            FileObject parent = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.saveFile.getParentFile()));
            saveFileObject = FileUtil.createData((FileObject)parent, (String)this.saveFile.getName());
            FileLock saveFileLock = saveFileObject.lock();
            try {
                OutputStream saveFileOutputStream = saveFileObject.getOutputStream(saveFileLock);
                BufferedOutputStream bos = new BufferedOutputStream(saveFileOutputStream, 1024);
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = bis.read(buffer)) != -1) {
                    bos.write(buffer, 0, len);
                }
                bos.close();
                bis.close();
            }
            finally {
                saveFileLock.releaseLock();
            }
            HashMap<String, File> result = new HashMap<String, File>();
            String modifiedFileExtn = null;
            try {
                modifiedFileExtn = new DocumentTypeSchemaWsdlParser().getFileExtensionByParsing(this.saveFile);
                if (modifiedFileExtn != null && !saveFileObject.getNameExt().endsWith("." + modifiedFileExtn)) {
                    File newFile;
                    String fileName = saveFileObject.getNameExt();
                    if (saveFileObject.getNameExt().endsWith("_" + modifiedFileExtn)) {
                        fileName = fileName.substring(0, fileName.length() - ("_" + modifiedFileExtn).length());
                    }
                    if ((newFile = new File(this.saveFile.getParent() + File.separator + fileName + "." + modifiedFileExtn)).isFile() && this.retEngine.getFileOverwrite()) {
                        newFile.delete();
                    }
                    FileObject newsaveFileObject = FileUtil.copyFile((FileObject)saveFileObject, (FileObject)saveFileObject.getParent(), (String)fileName, (String)modifiedFileExtn);
                    saveFileObject.delete();
                    saveFileObject = newsaveFileObject;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            result.put(effectiveSrcAddr, FileUtil.toFile((FileObject)saveFileObject));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private File guessSaveFile(RetrieveEntry rent) throws URISyntaxException, IOException {
        if (rent.getSaveFile() != null) {
            return rent.getSaveFile();
        }
        URI curUri = new URI(rent.getCurrentAddress());
        String curAddr = rent.getCurrentAddress();
        String curFileName = null;
        int index = curAddr.lastIndexOf("/");
        curFileName = index != -1 ? curAddr.substring(index + 1) : curAddr;
        if (this.retEngine.isSave2SingleFolder()) {
            curFileName = this.convertAllSpecialChars(curFileName);
            return new File(this.retEngine.getCurrentSaveRootFile() + File.separator + curFileName);
        }
        File result = null;
        if (curUri.isAbsolute()) {
            result = "http".equalsIgnoreCase(curUri.getScheme()) || "https".equalsIgnoreCase(curUri.getScheme()) ? this.getSaveFileForURL(curUri) : new File(new URI(this.retEngine.getFixedSaveRootFolder().toURI().toString() + "/" + curFileName));
        } else {
            File newFile = new File(new URI(rent.getLocalBaseFile().getParentFile().toURI().normalize().toString() + "/" + rent.getCurrentAddress())).getCanonicalFile();
            File newParentFile = this.getModifiedParentFile(rent.getLocalBaseFile(), newFile);
            result = rent.getLocalBaseFile() != newParentFile ? new File(new URI(newParentFile.getParentFile().toURI().toString() + "/" + rent.getCurrentAddress())) : newFile;
        }
        return result;
    }

    private File getModifiedParentFile(File parentFile, File curSaveFile) {
        String saveRootStr;
        File result = parentFile;
        String curSaveStr = curSaveFile.toURI().toString();
        if (curSaveStr.startsWith(saveRootStr = this.retEngine.getFixedSaveRootFolder().toURI().toString())) {
            return result;
        }
        Object newRootFile = null;
        int pushCount = Utilities.countPushdownFolders(curSaveFile.toURI(), this.retEngine.getFixedSaveRootFolder().toURI());
        this.retEngine.pushDownRoot(pushCount);
        result = this.retEngine.getNewFileForOld(parentFile, pushCount);
        return result;
    }

    private File getSaveFileForURL(URI absURI) {
        String fileExtension;
        String rootFolderStr = this.retEngine.getFixedSaveRootFolder().toURI().toString();
        String absURIStr = absURI.toString();
        String resultStr = absURI.getSchemeSpecificPart().replace(':', '_');
        if ((resultStr = resultStr.replace('?', '.')).lastIndexOf(".") != -1 && !(fileExtension = resultStr.substring(resultStr.lastIndexOf("."), resultStr.length())).equals(fileExtension.toLowerCase())) {
            resultStr = resultStr.substring(0, resultStr.lastIndexOf(".")) + fileExtension.toLowerCase();
        }
        resultStr = this.convertAllSpecialChars(resultStr);
        resultStr = rootFolderStr + "/" + resultStr;
        try {
            return new File(new URI(resultStr).normalize());
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public String convertAllSpecialChars(String resultStr) {
        StringBuffer sb = new StringBuffer(resultStr);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '/' || c == '.' || c == '_' || c == ' ' || c == '-') continue;
            sb.setCharAt(i, '_');
        }
        return sb.toString();
    }

    private void createReferenceFile(String effectiveSrcAddr, File saveFile) {
        Properties prop = new Properties();
        prop.setProperty("SOURCE_URL", effectiveSrcAddr);
        File propsFile = new File(saveFile.toString() + ".ref");
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(propsFile));
            prop.store(bos, " This file is a A pair of:" + saveFile + " . Do not delete.");
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "createReferenceFile", e);
        }
    }

    private void checkForCycle(File saveFile, long l, InputStream is) throws IOException {
        String fileExists = NbBundle.getMessage(RetrieverTask.class, (String)"EXCEPTION_CYCLIC_REFERENCE_INDICATOR");
        if (saveFile.isFile()) {
            if (this.isAlreadyDownloadedInThisSession(saveFile) || saveFile.length() == l && !this.retEngine.getFileOverwrite()) {
                is.close();
                throw new IOException(fileExists + " : " + saveFile);
            }
            if (this.retEngine.getFileOverwrite()) {
                return;
            }
            is.close();
            throw new IOException(fileExists + " : " + saveFile);
        }
        if (saveFile.isDirectory()) {
            is.close();
            String dirExists = NbBundle.getMessage(RetrieverTask.class, (String)"EXCEPTION_DIRECTORY_ALREADY_EXISTS");
            throw new IOException(dirExists + " : " + saveFile.getCanonicalPath());
        }
    }

    private boolean isAlreadyDownloadedInThisSession(File thisFile) {
        for (RetrieveEntry rent : this.retEngine.retrievedList) {
            if (!rent.getSaveFile().equals(thisFile)) continue;
            return true;
        }
        return false;
    }

    private boolean isAlreadyDownloadedInThisSession(String uri) {
        for (RetrieveEntry rent : this.retEngine.retrievedList) {
            if (!rent.getEffectiveAddress().equals(uri)) continue;
            return true;
        }
        return false;
    }
}

