/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.xml.retriever.FileResourceRetriever;
import org.netbeans.modules.xml.retriever.ResourceRetriever;
import org.netbeans.modules.xml.retriever.SecureURLResourceRetriever;
import org.netbeans.modules.xml.retriever.URLResourceRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRetrieverFactory {
    private static ArrayList<ResourceRetriever> registeredResourceRetrievers = new ArrayList();

    public static ResourceRetriever getResourceRetriever(String baseAddress, String address) throws URISyntaxException {
        for (ResourceRetriever retriever : registeredResourceRetrievers) {
            if (!retriever.accept(baseAddress, address)) continue;
            return retriever;
        }
        return null;
    }

    public static List<ResourceRetriever> getRegisteredResourceRetrievers() {
        return registeredResourceRetrievers;
    }

    public static boolean removeRegisteredResourceRetriever(ResourceRetriever oldResourceRetriever) {
        return registeredResourceRetrievers.remove(oldResourceRetriever);
    }

    public static void addResourceRetriever(ResourceRetriever newResourceRetriever) {
        registeredResourceRetrievers.add(newResourceRetriever);
    }

    static {
        registeredResourceRetrievers.add(new FileResourceRetriever());
        registeredResourceRetrievers.add(new URLResourceRetriever());
        registeredResourceRetrievers.add(new SecureURLResourceRetriever());
    }
}

