/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.protocol.xml.server;

import com.sun.xml.ws.encoding.xml.XMLMessage;
import com.sun.xml.ws.handler.HandlerChainCaller;
import com.sun.xml.ws.handler.MessageContextUtil;
import com.sun.xml.ws.handler.XMLHandlerContext;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.pept.presentation.TargetFinder;
import com.sun.xml.ws.pept.presentation.Tie;
import com.sun.xml.ws.pept.protocol.MessageDispatcher;
import com.sun.xml.ws.server.AppMsgContextImpl;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.server.RuntimeEndpointInfo;
import com.sun.xml.ws.server.provider.ProviderModel;
import com.sun.xml.ws.server.provider.ProviderPeptTie;
import com.sun.xml.ws.spi.runtime.Binding;
import com.sun.xml.ws.spi.runtime.Invoker;
import com.sun.xml.ws.spi.runtime.SystemHandlerDelegate;
import com.sun.xml.ws.spi.runtime.WSConnection;
import com.sun.xml.ws.spi.runtime.WebServiceContext;
import com.sun.xml.ws.util.MessageInfoUtil;
import com.sun.xml.ws.util.XMLConnectionUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.ws.handler.MessageContext;

public abstract class XMLMessageDispatcher
implements MessageDispatcher {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.xmlmd");

    public void send(MessageInfo messageInfo) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(MessageInfo messageInfo) {
        boolean sent;
        block16: {
            XMLMessage xmlMessage = null;
            try {
                xmlMessage = this.getXMLMessage(messageInfo);
            }
            catch (Exception e) {
                this.sendResponseError(messageInfo, e);
                return;
            }
            sent = false;
            try {
                if (xmlMessage.acceptFastInfoset()) {
                    messageInfo.setMetaData("com.sun.xml.ws.client.ContentNegotiation", "optimistic");
                }
                XMLHandlerContext context = new XMLHandlerContext(messageInfo, null, xmlMessage);
                this.updateHandlerContext(messageInfo, context);
                SystemHandlerDelegate shd = this.getSystemHandlerDelegate(messageInfo);
                XmlInvoker implementor = new XmlInvoker(messageInfo, xmlMessage, context, shd);
                try {
                    if (shd == null) {
                        implementor.invoke();
                    } else {
                        context.setInvoker(implementor);
                        if (shd.processRequest(context.getSHDXMLMessageContext())) {
                            implementor.invoke();
                            context.getMessageContext().put("javax.xml.ws.handler.message.outbound", Boolean.TRUE);
                            shd.processResponse(context.getSHDXMLMessageContext());
                        }
                    }
                }
                finally {
                    sent = implementor.isSent();
                }
                if (!XMLMessageDispatcher.isOneway(messageInfo)) {
                    sent = true;
                    this.sendResponse(messageInfo, context);
                } else if (!sent) {
                    sent = true;
                    this.sendResponseOneway(messageInfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log(Level.SEVERE, e.getMessage(), e);
                if (sent) break block16;
                this.sendResponseError(messageInfo, e);
            }
        }
        assert (sent);
    }

    protected abstract void toMessageInfo(MessageInfo var1, XMLHandlerContext var2);

    private XMLMessage getXMLMessage(MessageInfo messageInfo) {
        WSConnection con = messageInfo.getConnection();
        return XMLConnectionUtil.getXMLMessage(con, messageInfo);
    }

    private void invokeEndpoint(MessageInfo messageInfo, XMLHandlerContext hc) {
        TargetFinder targetFinder = messageInfo.getEPTFactory().getTargetFinder(messageInfo);
        Tie tie = targetFinder.findTarget(messageInfo);
        tie._invoke(messageInfo);
    }

    protected XMLMessage getResponse(MessageInfo messageInfo, XMLHandlerContext context) {
        XMLMessage xmlMessage;
        this.setResponseInContext(messageInfo, context);
        try {
            HandlerChainCaller handlerCaller = this.getCallerFromMessageInfo(messageInfo);
            if (handlerCaller != null && handlerCaller.hasHandlers()) {
                int messageType = messageInfo.getResponseType();
                if (messageType == 1 || messageType == 2) {
                    this.callHandleFault(handlerCaller, context);
                } else {
                    this.callHandlersOnResponse(handlerCaller, context);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            boolean useFastInfoset = messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation") == "optimistic";
            xmlMessage = new XMLMessage(e, useFastInfoset);
            context.setXMLMessage(xmlMessage);
        }
        MessageContext msgCtxt = context.getMessageContext();
        Map atts = (Map)msgCtxt.get("javax.xml.ws.binding.attachments.outbound");
        if (atts != null) {
            xmlMessage = context.getXMLMessage();
            Map allAtts = xmlMessage.getAttachments();
            if (allAtts != null) {
                allAtts.putAll(atts);
            } else {
                allAtts = atts;
            }
            xmlMessage = new XMLMessage(xmlMessage.getSource(), allAtts, xmlMessage.isFastInfoset());
            context.setXMLMessage(xmlMessage);
        }
        return context.getXMLMessage();
    }

    protected abstract void setResponseInContext(MessageInfo var1, XMLHandlerContext var2);

    private void sendResponse(MessageInfo messageInfo, XMLHandlerContext ctxt) throws IOException {
        XMLMessage xmlMessage = ctxt.getXMLMessage();
        MessageContext msgCtxt = ctxt.getMessageContext();
        WSConnection con = messageInfo.getConnection();
        Integer status = MessageContextUtil.getHttpStatusCode(msgCtxt);
        int statusCode = status == null ? xmlMessage.getStatus() : status.intValue();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        Map<String, List<String>> ctxtHdrs = MessageContextUtil.getHttpResponseHeaders(msgCtxt);
        if (ctxtHdrs != null) {
            headers.putAll(ctxtHdrs);
        }
        MimeHeaders mhs = xmlMessage.getMimeHeaders();
        Iterator i = mhs.getAllHeaders();
        while (i.hasNext()) {
            MimeHeader mh = (MimeHeader)i.next();
            String name = mh.getName();
            ArrayList<String> values = (ArrayList<String>)headers.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                headers.put(name, values);
            }
            values.add(mh.getValue());
        }
        con.setStatus(statusCode);
        con.setHeaders(headers);
        xmlMessage.writeTo(con.getOutput());
        con.closeOutput();
    }

    protected void sendResponseOneway(MessageInfo messageInfo) {
        WSConnection con = messageInfo.getConnection();
        XMLConnectionUtil.sendResponseOneway(con);
    }

    private void sendResponseError(MessageInfo messageInfo, Exception e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
        WSConnection con = messageInfo.getConnection();
        XMLConnectionUtil.sendResponseError(con, messageInfo);
    }

    private boolean callHandlersOnRequest(MessageInfo messageInfo, XMLHandlerContext context, boolean responseExpected) {
        boolean skipEndpoint = false;
        HandlerChainCaller handlerCaller = this.getCallerFromMessageInfo(messageInfo);
        if (handlerCaller != null && handlerCaller.hasHandlers()) {
            skipEndpoint = !handlerCaller.callHandlers(HandlerChainCaller.Direction.INBOUND, HandlerChainCaller.RequestOrResponse.REQUEST, context, responseExpected);
        }
        return skipEndpoint;
    }

    private boolean hasHandlers(MessageInfo messageInfo) {
        HandlerChainCaller handlerCaller = this.getCallerFromMessageInfo(messageInfo);
        return handlerCaller != null && handlerCaller.hasHandlers();
    }

    private HandlerChainCaller getCallerFromMessageInfo(MessageInfo info) {
        HandlerChainCaller caller = MessageInfoUtil.getHandlerChainCaller(info);
        if (caller == null) {
            RuntimeContext context = (RuntimeContext)info.getMetaData("com.sun.xml.ws.runtime.context");
            Binding binding = context.getRuntimeEndpointInfo().getBinding();
            caller = new HandlerChainCaller(binding.getHandlerChain());
            MessageInfoUtil.setHandlerChainCaller(info, caller);
        }
        return caller;
    }

    protected boolean callHandlersOnResponse(HandlerChainCaller caller, XMLHandlerContext context) {
        return caller.callHandlers(HandlerChainCaller.Direction.OUTBOUND, HandlerChainCaller.RequestOrResponse.RESPONSE, context, false);
    }

    protected boolean callHandleFault(HandlerChainCaller caller, XMLHandlerContext context) {
        return false;
    }

    private void closeHandlers(MessageInfo info, XMLHandlerContext context) {
        HandlerChainCaller handlerCaller = this.getCallerFromMessageInfo(info);
        if (handlerCaller != null && handlerCaller.hasHandlers()) {
            handlerCaller.forceCloseHandlersOnServer(context);
        }
    }

    private static boolean isFailure(MessageInfo messageInfo) {
        return messageInfo.getResponseType() == 2;
    }

    public static boolean isOneway(MessageInfo messageInfo) {
        return messageInfo.getMEP() == 2;
    }

    protected void updateWebServiceContext(MessageInfo messageInfo, XMLHandlerContext hc) {
        RuntimeEndpointInfo endpointInfo = MessageInfoUtil.getRuntimeContext(messageInfo).getRuntimeEndpointInfo();
        WebServiceContext wsContext = endpointInfo.getWebServiceContext();
        if (wsContext != null) {
            AppMsgContextImpl appCtxt = new AppMsgContextImpl(hc.getMessageContext());
            wsContext.setMessageContext(appCtxt);
        }
    }

    private void updateHandlerContext(MessageInfo messageInfo, XMLHandlerContext context) {
        RuntimeEndpointInfo endpointInfo = MessageInfoUtil.getRuntimeContext(messageInfo).getRuntimeEndpointInfo();
        WebServiceContext wsContext = endpointInfo.getWebServiceContext();
        if (wsContext != null) {
            context.setMessageContext(wsContext.getMessageContext());
        }
    }

    private SystemHandlerDelegate getSystemHandlerDelegate(MessageInfo mi) {
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(mi);
        RuntimeEndpointInfo endpointInfo = rtCtxt.getRuntimeEndpointInfo();
        return endpointInfo.getBinding().getSystemHandlerDelegate();
    }

    private void setInboundAttachments(MessageInfo messageInfo, XMLHandlerContext context) {
        XMLMessage xmlMessage;
        Map<String, DataHandler> atts;
        if (this.hasHandlers(messageInfo) && (atts = (xmlMessage = context.getXMLMessage()).getAttachments()) != null) {
            MessageContext msgCtxt = context.getMessageContext();
            msgCtxt.put("javax.xml.ws.binding.attachments.inbound", atts);
            msgCtxt.setScope("javax.xml.ws.binding.attachments.inbound", MessageContext.Scope.APPLICATION);
            xmlMessage = new XMLMessage(xmlMessage.getSource(), xmlMessage.isFastInfoset());
            context.setXMLMessage(xmlMessage);
        }
    }

    private void processInboundAttachments(MessageInfo messageInfo, XMLHandlerContext context) {
        RuntimeContext rtCtxt;
        RuntimeEndpointInfo endpointInfo;
        ProviderModel model;
        boolean isSource;
        if (this.hasHandlers(messageInfo) && !(isSource = (model = (endpointInfo = (rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo)).getRuntimeEndpointInfo()).getProviderModel()).isSource())) {
            XMLMessage xmlMessage = context.getXMLMessage();
            MessageContext msgCtxt = context.getMessageContext();
            Map atts = (Map)msgCtxt.get("javax.xml.ws.binding.attachments.inbound");
            xmlMessage = new XMLMessage(xmlMessage.getSource(), atts, xmlMessage.isFastInfoset());
            context.setXMLMessage(xmlMessage);
        }
    }

    private class XmlInvoker
    implements Invoker {
        MessageInfo messageInfo;
        XMLMessage xmlMessage;
        XMLHandlerContext context;
        SystemHandlerDelegate shd;
        boolean sent;

        XmlInvoker(MessageInfo messageInfo, XMLMessage xmlMessage, XMLHandlerContext context, SystemHandlerDelegate shd) {
            this.messageInfo = messageInfo;
            this.xmlMessage = xmlMessage;
            this.context = context;
            this.shd = shd;
        }

        public void invoke() throws Exception {
            boolean skipEndpoint = false;
            XMLMessageDispatcher.this.setInboundAttachments(this.messageInfo, this.context);
            skipEndpoint = XMLMessageDispatcher.this.callHandlersOnRequest(this.messageInfo, this.context, true);
            if (!skipEndpoint) {
                XMLMessageDispatcher.this.processInboundAttachments(this.messageInfo, this.context);
                XMLMessageDispatcher.this.toMessageInfo(this.messageInfo, this.context);
                if (!XMLMessageDispatcher.isFailure(this.messageInfo)) {
                    if (this.shd != null) {
                        this.shd.preInvokeEndpointHook(this.context.getSHDXMLMessageContext());
                    }
                    XMLMessageDispatcher.this.updateWebServiceContext(this.messageInfo, this.context);
                    XMLMessageDispatcher.this.invokeEndpoint(this.messageInfo, this.context);
                    if (!this.sent && XMLMessageDispatcher.isOneway(this.messageInfo)) {
                        this.sent = true;
                        XMLMessageDispatcher.this.sendResponseOneway(this.messageInfo);
                    }
                }
                if (XMLMessageDispatcher.isOneway(this.messageInfo)) {
                    if (XMLMessageDispatcher.isFailure(this.messageInfo)) {
                        // empty if block
                    }
                } else {
                    XMLMessageDispatcher.this.updateHandlerContext(this.messageInfo, this.context);
                    this.xmlMessage = XMLMessageDispatcher.this.getResponse(this.messageInfo, this.context);
                    this.context.setXMLMessage(this.xmlMessage);
                }
            }
        }

        public Method getMethod(QName name) {
            return ProviderPeptTie.invoke_Method;
        }

        public boolean isSent() {
            return this.sent;
        }
    }
}

