/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.soap;

import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.encoding.internal.InternalEncoder;
import com.sun.xml.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.ws.encoding.jaxb.RpcLitPayload;
import com.sun.xml.ws.encoding.soap.EncoderDecoder;
import com.sun.xml.ws.encoding.soap.SerializationException;
import com.sun.xml.ws.encoding.soap.internal.AttachmentBlock;
import com.sun.xml.ws.encoding.soap.internal.BodyBlock;
import com.sun.xml.ws.encoding.soap.internal.HeaderBlock;
import com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.ws.encoding.soap.message.FaultReasonText;
import com.sun.xml.ws.encoding.soap.message.SOAP12FaultInfo;
import com.sun.xml.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.ws.model.CheckedException;
import com.sun.xml.ws.model.ExceptionType;
import com.sun.xml.ws.model.JavaMethod;
import com.sun.xml.ws.model.Parameter;
import com.sun.xml.ws.model.ParameterBinding;
import com.sun.xml.ws.model.RuntimeModel;
import com.sun.xml.ws.model.WrapperParameter;
import com.sun.xml.ws.model.soap.SOAPBinding;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.ws.soap.SOAPFaultException;

public class ClientEncoderDecoder
extends EncoderDecoder
implements InternalEncoder {
    public void toMessageInfo(Object intMessage, MessageInfo mi) {
        boolean isResponseAsynWrapper;
        Object bodyValue;
        InternalMessage im = (InternalMessage)intMessage;
        BodyBlock bodyBlock = im.getBody();
        RuntimeContext rtContext = (RuntimeContext)mi.getMetaData("com.sun.xml.ws.runtime.context");
        JavaMethod jm = rtContext.getModel().getJavaMethod(mi.getMethod());
        mi.setMEP(jm.getMEP());
        Object object = bodyValue = bodyBlock == null ? null : bodyBlock.getValue();
        if (bodyValue instanceof SOAPFaultInfo) {
            SOAPFaultInfo sfi = (SOAPFaultInfo)bodyValue;
            Object detail = sfi.getDetail();
            if (detail == null || detail instanceof Detail) {
                SOAPFaultException sfe = new SOAPFaultException(sfi.getSOAPFault());
                mi.setResponseType(1);
                mi.setResponse(sfe);
                return;
            }
            JAXBBridgeInfo bi = (JAXBBridgeInfo)detail;
            CheckedException ce = jm.getCheckedException(bi.getType());
            Exception ex = this.createCheckedException(sfi.getString(), ce, bi.getValue());
            mi.setResponseType(1);
            mi.setResponse(ex);
            return;
        }
        if (bodyValue instanceof SOAP12FaultInfo) {
            SOAP12FaultInfo sfi = (SOAP12FaultInfo)bodyValue;
            Object detail = sfi.getDetail();
            if (detail == null || detail instanceof Detail) {
                SOAPFaultException sfe = new SOAPFaultException(sfi.getSOAPFault());
                mi.setResponseType(1);
                mi.setResponse(sfe);
                return;
            }
            JAXBBridgeInfo bi = (JAXBBridgeInfo)detail;
            CheckedException ce = jm.getCheckedException(bi.getType());
            String reason = null;
            List<FaultReasonText> frt = sfi.getReasons().getFaultReasonTexts();
            if (frt != null && !frt.isEmpty()) {
                reason = frt.get(0).getValue();
            }
            Exception ex = this.createCheckedException(reason, ce, bi.getValue());
            mi.setResponseType(1);
            mi.setResponse(ex);
            return;
        }
        List<HeaderBlock> headers = im.getHeaders();
        Map<String, AttachmentBlock> attachments = im.getAttachments();
        Object[] data = mi.getData();
        SOAPBinding soapBinding = (SOAPBinding)jm.getBinding();
        int bBlocks = bodyValue != null ? 1 : 0;
        int hBlocks = im.getHeaders() != null ? im.getHeaders().size() : 0;
        int mBlocks = im.getAttachments() != null ? im.getAttachments().size() : 0;
        boolean bl = isResponseAsynWrapper = bBlocks + hBlocks + mBlocks > 1;
        if (bodyValue instanceof RpcLitPayload && !isResponseAsynWrapper) {
            boolean bl2 = isResponseAsynWrapper = ((RpcLitPayload)bodyValue).getBridgeParameters().size() > 1;
        }
        if (jm.isAsync() && isResponseAsynWrapper) {
            Object asyncWrapper = this.createAsyncResponseClass(jm.getResponseParameters().get(0));
            if (bodyValue instanceof RpcLitPayload) {
                RpcLitPayload payload = (RpcLitPayload)bodyValue;
                for (JAXBBridgeInfo bi : payload.getBridgeParameters()) {
                    this.setAsyncResponseWrapperValue(rtContext, asyncWrapper, bi.getValue(), bi.getType().tagName);
                }
            } else {
                JAXBBridgeInfo value = (JAXBBridgeInfo)bodyValue;
                this.setAsyncResponseWrapperValue(rtContext, asyncWrapper, value.getValue(), value.getType().tagName);
            }
            if (im.getHeaders() != null) {
                for (HeaderBlock hb : im.getHeaders()) {
                    JAXBBridgeInfo value = (JAXBBridgeInfo)hb.getValue();
                    this.setAsyncResponseWrapperValue(rtContext, asyncWrapper, value.getValue(), value.getType().tagName);
                }
            } else if (attachments != null) {
                for (String id : attachments.keySet()) {
                    AttachmentBlock ab = attachments.get(id);
                    if (ab == null) {
                        return;
                    }
                    String part = ab.getWSDLPartName();
                    this.setAsyncResponseWrapperValue(rtContext, asyncWrapper, ab.asDataHandler(), new QName("", part));
                }
            }
            mi.setResponse(asyncWrapper);
            return;
        }
        if (jm.isAsync() && bBlocks + hBlocks + mBlocks == 1) {
            Object value = null;
            if (bodyValue instanceof RpcLitPayload) {
                RpcLitPayload payload = (RpcLitPayload)bodyValue;
                Iterator<JAXBBridgeInfo> i$ = payload.getBridgeParameters().iterator();
                if (i$.hasNext()) {
                    JAXBBridgeInfo bi = i$.next();
                    value = bi.getValue();
                }
            } else {
                value = ((JAXBBridgeInfo)bodyValue).getValue();
            }
            if (value != null) {
                mi.setResponse(value);
                return;
            }
            if (headers != null) {
                for (HeaderBlock hb : headers) {
                    value = ((JAXBBridgeInfo)hb.getValue()).getValue();
                    if (value == null) continue;
                    mi.setResponse(value);
                    return;
                }
            }
            if (attachments != null) {
                for (String id : attachments.keySet()) {
                    AttachmentBlock ab = attachments.get(id);
                    if (ab == null) continue;
                    mi.setResponse(ab.asDataHandler());
                    return;
                }
            }
            assert (false);
        }
        for (Parameter param : jm.getResponseParameters()) {
            Object obj = null;
            ParameterBinding paramBinding = param.getOutBinding();
            if (paramBinding.isBody()) {
                obj = bodyValue;
            } else if (headers != null && paramBinding.isHeader()) {
                HeaderBlock header = this.getHeaderBlock(param.getName(), headers);
                obj = header != null ? header.getValue() : null;
            } else if (paramBinding.isAttachment()) {
                obj = this.getAttachment(rtContext, attachments, param, paramBinding);
            }
            Object resp = this.fillData(rtContext, param, obj, data, soapBinding, paramBinding);
            if (!param.isResponse()) continue;
            mi.setResponse(resp);
        }
    }

    private void setAsyncResponseWrapperValue(RuntimeContext rtContext, Object bean, Object value, QName tag) {
        if (value != null) {
            this.setWrapperChildValue(rtContext, bean, value, tag.getNamespaceURI(), tag.getLocalPart());
        }
    }

    private Object createAsyncResponseClass(Parameter parameter) {
        WrapperParameter wp;
        Class asyncWrapper = (Class)parameter.getTypeReference().type;
        if (RpcLitPayload.class.isAssignableFrom(asyncWrapper) && (wp = (WrapperParameter)parameter).getWrapperChildren().size() > 0) {
            Parameter p = wp.getWrapperChildren().get(0);
            asyncWrapper = (Class)p.getTypeReference().type;
        }
        try {
            return asyncWrapper.newInstance();
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    private Exception createCheckedException(String message, CheckedException ce, Object detail) {
        if (ce.getExceptionType().equals((Object)ExceptionType.UserDefined)) {
            return this.createUserDefinedException(message, ce, detail);
        }
        Class exceptionClass = ce.getExcpetionClass();
        try {
            Constructor constructor = exceptionClass.getConstructor(String.class, (Class)ce.getDetailType().type);
            Object exception = constructor.newInstance(message, detail);
            return (Exception)exception;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    private Exception createUserDefinedException(String message, CheckedException ce, Object detail) {
        Class exceptionClass = ce.getExcpetionClass();
        try {
            Field[] fields;
            Constructor constructor = exceptionClass.getConstructor(String.class);
            Object exception = constructor.newInstance(message);
            for (Field f : fields = detail.getClass().getFields()) {
                Method m = exceptionClass.getMethod(this.getWriteMethod(f), new Class[0]);
                m.invoke(exception, f.get(detail));
            }
            return (Exception)exception;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    private String getWriteMethod(Field f) {
        return "set" + StringUtils.capitalize(f.getName());
    }

    public InternalMessage toInternalMessage(MessageInfo mi) {
        RuntimeContext rtContext = (RuntimeContext)mi.getMetaData("com.sun.xml.ws.runtime.context");
        RuntimeModel model = rtContext.getModel();
        JavaMethod jm = model.getJavaMethod(mi.getMethod());
        Object[] data = mi.getData();
        InternalMessage im = new InternalMessage();
        RequestContext ctxt = (RequestContext)mi.getMetaData("com.sun.xml.ws.context.request");
        this.copyAttachmentProperty(ctxt, im);
        Iterator<Parameter> iter = jm.getRequestParameters().iterator();
        SOAPBinding soapBinding = (SOAPBinding)jm.getBinding();
        while (iter.hasNext()) {
            Parameter param = iter.next();
            ParameterBinding paramBinding = param.getInBinding();
            Object obj = this.createPayload(rtContext, param, data, null, soapBinding, paramBinding);
            if (paramBinding.isBody()) {
                im.setBody(new BodyBlock(obj));
                continue;
            }
            if (paramBinding.isHeader()) {
                im.addHeader(new HeaderBlock((JAXBBridgeInfo)obj));
                continue;
            }
            if (!paramBinding.isAttachment()) continue;
            this.addAttachmentPart(rtContext, im, obj, param);
        }
        return im;
    }
}

