/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client;

import com.sun.xml.ws.client.ClientConfigurationException;
import com.sun.xml.ws.client.EndpointIFContext;
import com.sun.xml.ws.client.ServiceContext;
import com.sun.xml.ws.handler.HandlerResolverImpl;
import com.sun.xml.ws.model.RuntimeModel;
import com.sun.xml.ws.modeler.RuntimeModeler;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.wsdl.WSDLContext;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.jws.HandlerChain;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceContextBuilder {
    private ServiceContextBuilder() {
    }

    public static ServiceContext build(URL wsdlLocation, QName serviceName, final Class service, EntityResolver er) throws WebServiceException {
        HandlerChain handlerChain;
        ServiceContext serviceContext = new ServiceContext(service, serviceName, er);
        if (wsdlLocation != null) {
            WSDLContext wsCtx = new WSDLContext(wsdlLocation, er);
            if (!wsCtx.contains(serviceName)) {
                throw new ClientConfigurationException("service.invalidServiceName", serviceName, wsdlLocation);
            }
            serviceContext.setWsdlContext(wsCtx);
        }
        if ((handlerChain = (HandlerChain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return service.getAnnotation(HandlerChain.class);
            }
        })) != null) {
            HandlerResolverImpl hresolver = new HandlerResolverImpl(serviceContext);
            serviceContext.setHandlerResolver(hresolver);
        }
        return serviceContext;
    }

    public static void completeServiceContext(QName portName, ServiceContext serviceContext, Class portInterface) {
        if (portInterface != null) {
            ServiceContextBuilder.processAnnotations(portName, serviceContext, portInterface);
        }
    }

    private static void processAnnotations(QName portName, ServiceContext serviceContext, Class portInterface) throws WebServiceException {
        WSDLContext wsdlContext = serviceContext.getWsdlContext();
        EndpointIFContext eifc = serviceContext.getEndpointIFContext(portInterface.getName());
        if (eifc != null && eifc.getRuntimeContext() != null) {
            return;
        }
        if (eifc == null) {
            eifc = new EndpointIFContext(portInterface);
            serviceContext.addEndpointIFContext(eifc);
        }
        QName serviceName = serviceContext.getServiceName();
        if (portName == null) {
            QName portTypeName = RuntimeModeler.getPortTypeName(portInterface);
            portName = wsdlContext.getWsdlDocument().getPortName(serviceContext.getServiceName(), portTypeName);
        }
        if (portName == null) {
            throw new ClientConfigurationException("service.noPortName", portInterface.getName(), wsdlContext.getWsdlLocation().toString());
        }
        eifc.setPortName(portName);
        String bindingId = wsdlContext.getBindingID(serviceName, portName);
        RuntimeModeler modeler = new RuntimeModeler(portInterface, serviceName, bindingId);
        modeler.setPortName(portName);
        RuntimeModel model = modeler.buildRuntimeModel();
        eifc.setRuntimeContext(new RuntimeContext(model));
    }

    private ArrayList<Class<?>> getSEI(final Class sc) {
        if (sc == null) {
            throw new WebServiceException();
        }
        if (!Service.class.isAssignableFrom(sc)) {
            throw new WebServiceException("service.interface.required" + sc.getName());
        }
        final ArrayList classes = new ArrayList();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method[] methods;
                for (Method method : methods = sc.getDeclaredMethods()) {
                    method.setAccessible(true);
                    Class<?> seiClazz = method.getReturnType();
                    if (seiClazz == null || seiClazz.equals("void")) continue;
                    classes.add(seiClazz);
                }
                return null;
            }
        });
        return classes;
    }
}

