/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.dd.api.ejb.Query;
import org.netbeans.modules.j2ee.ddloaders.multiview.CmpFieldHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.CmpFieldsTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.EntityAndSessionHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.FinderMethodsTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.PropertyChangeSource;
import org.netbeans.modules.j2ee.ddloaders.multiview.QueryMethodHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.SelectMethodsTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.j2ee.ejbcore.api.codegeneration.EntityAndSessionGenerator;
import org.netbeans.modules.j2ee.ejbcore.api.codegeneration.EntityGenerator;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.ui.CallEjb;
import org.openide.filesystems.FileObject;

public class EntityHelper
extends EntityAndSessionHelper {
    private final Entity entity;
    public final CmpFields cmpFields;
    public final Queries queries;
    private static final String PRIMARY_KEY_FINDER_METHOD = "findByPrimaryKey";
    private EntityMethodController entityMethodController;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EntityHelper(EjbJarMultiViewDataObject ejbJarMultiViewDataObject, Entity entity) {
        super(ejbJarMultiViewDataObject, (EntityAndSession)entity);
        this.entity = (Entity)this.ejb;
        this.cmpFields = new CmpFields();
        this.queries = new Queries();
        this.entityMethodController = new EntityMethodController(entity, this.sourceClassPath, ejbJarMultiViewDataObject.getEjbJar());
        this.abstractMethodController = this.entityMethodController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method createAccessMethod(String fieldName, Type type, boolean get) {
        this.entityMethodController.beginWriteJmiTransaction();
        boolean rollback = true;
        try {
            JavaClass beanClass = this.getBeanClass();
            if (!$assertionsDisabled && beanClass == null) {
                throw new AssertionError();
            }
            this.entityMethodController.registerClassForSave(beanClass);
            Method prototype = JMIUtils.createMethod((JavaClass)beanClass);
            prototype.setName(EntityMethodController.getMethodName((String)fieldName, (boolean)get));
            if (get) {
                prototype.setType(type);
            } else {
                prototype.getParameters().add(JMIUtils.createParameter((Method)prototype, (String)fieldName, (Type)type, (boolean)false));
                prototype.setType(JMIUtils.resolveType((String)"void"));
            }
            Utils.addMethod(beanClass, prototype, false, 1025);
            Method accessMethod = Utils.getMethod(beanClass, prototype);
            rollback = false;
            Method method = accessMethod;
            return method;
        }
        finally {
            this.entityMethodController.endWriteJmiTransaction(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getSetterMethod(String fieldName, Method getterMethod) {
        if (getterMethod == null) {
            return null;
        }
        JMIUtils.beginJmiTransaction();
        try {
            Method method = EntityMethodController.getSetterMethod((JavaClass)this.getBeanClass(), (String)fieldName, (Type)getterMethod.getType());
            return method;
        }
        finally {
            JMIUtils.endJmiTransaction();
        }
    }

    public Method getGetterMethod(String fieldName) {
        return EntityHelper.getGetterMethod(this.getBeanClass(), fieldName);
    }

    private static Method getGetterMethod(JavaClass javaClass, String fieldName) {
        Method result = javaClass.getMethod(EntityMethodController.getMethodName((String)fieldName, (boolean)true), Collections.EMPTY_LIST, false);
        if (result != null) {
            return result;
        }
        JavaClass superClass = javaClass.getSuperClass();
        if (superClass == null) {
            return null;
        }
        return EntityHelper.getGetterMethod(superClass, fieldName);
    }

    public void removeQuery(Query query) {
        this.entity.removeQuery(query);
        this.modelUpdatedFromUI();
    }

    public boolean hasLocalInterface() {
        return this.ejb.getLocal() != null;
    }

    public boolean hasRemoteInterface() {
        return this.ejb.getRemote() != null;
    }

    public String getPrimkeyField() {
        return this.entity.getPrimkeyField();
    }

    public String getPrimKeyClass() {
        return this.entity.getPrimKeyClass();
    }

    public void setPrimkeyFieldName(String fieldName) {
        this.entity.setPrimkeyField(fieldName);
    }

    public void setPrimkeyField(String fieldName) throws ClassNotFoundException {
        this.setPrimkeyFieldName(fieldName);
        if (fieldName != null) {
            CmpFieldHelper helper = this.cmpFields.getCmpFieldHelper(fieldName);
            helper.reloadType();
        }
        this.modelUpdatedFromUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrimKeyClass(Type newType) {
        LinkedList<Type> params = new LinkedList<Type>();
        params.add(JMIUtils.resolveType((String)this.entity.getPrimKeyClass()));
        this.changeFinderMethodParam(this.getLocalHomeInterfaceClass(), params, newType);
        this.changeFinderMethodParam(this.getHomeInterfaceClass(), params, newType);
        this.entity.setPrimKeyClass(newType.getName());
        JavaClass beanClass = this.getBeanClass();
        if (beanClass != null) {
            boolean rollback = true;
            JMIUtils.beginJmiTransaction((boolean)true);
            try {
                this.entityMethodController.registerClassForSave(beanClass);
                Method[] methods = JMIUtils.getMethods((JavaClass)beanClass);
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    if (!"ejbCreate".equals(method.getName())) continue;
                    method.setType(newType);
                }
                rollback = false;
            }
            finally {
                JMIUtils.endJmiTransaction((boolean)rollback);
            }
        }
    }

    private void changeFinderMethodParam(JavaClass javaClass, List params, Type newType) {
        if (javaClass != null) {
            this.entityMethodController.registerClassForSave(javaClass);
            Method method = javaClass.getMethod(PRIMARY_KEY_FINDER_METHOD, params, false);
            Utils.changeParameterType(method, newType);
        }
    }

    protected EntityAndSessionGenerator getGenerator() {
        EntityGenerator generator = new EntityGenerator(this.entity.getPrimKeyClass());
        generator.setCMP("Container".equals(this.entity.getPersistenceType()));
        return generator;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (this.queries == null) {
            return;
        }
        Object source = evt.getSource();
        String propertyName = evt.getPropertyName();
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        if (source == this.entity) {
            if (oldValue instanceof CmpField || newValue instanceof CmpField) {
                this.cmpFields.change(source, propertyName, oldValue, newValue);
            } else if (oldValue instanceof Query || newValue instanceof Query) {
                this.queries.change(source, propertyName, oldValue, newValue);
            }
        } else if (source instanceof CmpField) {
            this.cmpFields.change(source, propertyName, oldValue, newValue);
        } else if (source instanceof Query) {
            this.queries.change(source, propertyName, oldValue, newValue);
        }
    }

    public EntityMethodController getEntityMethodController() {
        return this.entityMethodController;
    }

    public void updateMethod(Method method, boolean local, boolean isComponent, boolean shouldExist) {
        this.entityMethodController.updateMethod(method, local, isComponent, shouldExist);
    }

    public void updateFieldAccessor(String fieldName, boolean getter, boolean local, boolean shouldExist) {
        if (local && this.hasLocalInterface() || !local && this.hasRemoteInterface()) {
            this.entityMethodController.updateFieldAccessor(fieldName, getter, local, shouldExist);
        }
    }

    static {
        $assertionsDisabled = !EntityHelper.class.desiredAssertionStatus();
    }

    public class Queries
    implements PropertyChangeSource {
        private List listeners = new LinkedList();
        private HashMap queryMethodHelperMap = new HashMap();
        private Query[] selectMethods;
        private Query[] finderMethods;
        public static final String SELECT_PREFIX = "ejbSelect";
        public static final String FIND_PREFIX = "find";
        private FinderMethodsTableModel finderMethodsTableModel = new FinderMethodsTableModel(this);
        private SelectMethodsTableModel selectMethodsTableModel = new SelectMethodsTableModel(this);

        public Queries() {
            this.initQueryMethods();
        }

        private void initQueryMethods() {
            this.selectMethods = this.getQueries(SELECT_PREFIX);
            this.finderMethods = this.getQueries(FIND_PREFIX);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QueryMethodHelper getQueryMethodHelper(Query query) {
            JMIUtils.beginJmiTransaction();
            try {
                QueryMethodHelper queryMethodHelper = (QueryMethodHelper)this.queryMethodHelperMap.get(query);
                if (queryMethodHelper == null) {
                    queryMethodHelper = new QueryMethodHelper(EntityHelper.this, query);
                    this.queryMethodHelperMap.put(query, queryMethodHelper);
                }
                QueryMethodHelper queryMethodHelper2 = queryMethodHelper;
                return queryMethodHelper2;
            }
            finally {
                JMIUtils.endJmiTransaction();
            }
        }

        public QueryMethodHelper getFinderMethodHelper(int row) {
            return this.getQueryMethodHelper(this.finderMethods[row]);
        }

        public QueryMethodHelper getSelectMethodHelper(int row) {
            return this.getQueryMethodHelper(this.selectMethods[row]);
        }

        private Query[] getQueries(String s) {
            LinkedList<Query> list = new LinkedList<Query>();
            Query[] queries = EntityHelper.this.entity.getQuery();
            for (int i = 0; i < queries.length; ++i) {
                Query query = queries[i];
                if (!query.getQueryMethod().getMethodName().startsWith(s)) continue;
                list.add(query);
                QueryMethodHelper helper = (QueryMethodHelper)this.queryMethodHelperMap.get(query);
                if (helper == null) continue;
                helper.init();
            }
            return list.toArray(new Query[0]);
        }

        public void addFinderMethod() {
            CallEjb.addFinderMethod((JavaClass)EntityHelper.this.getBeanClass());
            EntityHelper.this.modelUpdatedFromUI();
        }

        public void addSelectMethod() {
            CallEjb.addSelectMethod((JavaClass)EntityHelper.this.getBeanClass());
        }

        public int getFinderMethodCount() {
            return this.finderMethods.length;
        }

        public int getSelectMethodCount() {
            return this.selectMethods.length;
        }

        public Query getFinderMethod(int rowIndex) {
            return this.finderMethods[rowIndex];
        }

        public Query getSelecMethod(int rowIndex) {
            return this.selectMethods[rowIndex];
        }

        public void change(Object source, String propertyName, Object oldValue, Object newValue) {
            this.initQueryMethods();
            this.queryMethodHelperMap.keySet().retainAll(Arrays.asList(EntityHelper.this.entity.getQuery()));
            this.firePropertyChange(new PropertyChangeEvent(source, propertyName, oldValue, newValue));
        }

        public Query[] getQuery() {
            return EntityHelper.this.entity.getQuery();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.add(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.remove(listener);
        }

        protected void firePropertyChange(PropertyChangeEvent evt) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((PropertyChangeListener)iterator.next()).propertyChange(evt);
            }
        }

        public String getLocal() {
            return EntityHelper.this.getLocal();
        }

        public String getRemote() {
            return EntityHelper.this.getRemote();
        }

        public FinderMethodsTableModel getFinderMethodsTableModel() {
            return this.finderMethodsTableModel;
        }

        public SelectMethodsTableModel getSelectMethodsTableModel() {
            return this.selectMethodsTableModel;
        }

        public int getSelectMethodRow(Query query) {
            for (int i = 0; i < this.selectMethods.length; ++i) {
                if (!query.equals(this.selectMethods[i])) continue;
                return i;
            }
            return -1;
        }

        public int getFinderMethodRow(Query query) {
            for (int i = 0; i < this.finderMethods.length; ++i) {
                if (!query.equals(this.finderMethods[i])) continue;
                return i;
            }
            return -1;
        }
    }

    public class CmpFields
    implements PropertyChangeSource {
        private List listeners = new LinkedList();
        private HashMap cmpFieldHelperMap = new HashMap();
        private CmpFieldsTableModel cmpFieldsTableModel = new CmpFieldsTableModel(this);

        public int getCmpFieldCount() {
            return EntityHelper.this.entity.getCmpField().length;
        }

        public CmpFieldHelper getCmpFieldHelper(int row) {
            CmpField field = this.getCmpField(row);
            CmpFieldHelper cmpFieldHelper = (CmpFieldHelper)this.cmpFieldHelperMap.get(field);
            if (cmpFieldHelper == null) {
                cmpFieldHelper = this.createCmpFieldHelper(field);
            }
            return cmpFieldHelper;
        }

        private CmpFieldHelper getCmpFieldHelper(String fieldName) {
            CmpFieldHelper cmpFieldHelper = (CmpFieldHelper)this.cmpFieldHelperMap.get(fieldName);
            if (cmpFieldHelper == null) {
                CmpField[] cmpFields = EntityHelper.this.entity.getCmpField();
                for (int i = 0; i < cmpFields.length; ++i) {
                    CmpField field = cmpFields[i];
                    if (!fieldName.equals(field.getFieldName())) continue;
                    cmpFieldHelper = this.createCmpFieldHelper(field);
                }
            }
            return cmpFieldHelper;
        }

        private CmpFieldHelper createCmpFieldHelper(CmpField field) {
            CmpFieldHelper cmpFieldHelper = new CmpFieldHelper(EntityHelper.this, field);
            this.cmpFieldHelperMap.put(field, cmpFieldHelper);
            return cmpFieldHelper;
        }

        private CmpField getCmpField(int row) {
            return this.getCmpFields()[row];
        }

        public CmpField[] getCmpFields() {
            CmpField[] cmpFields = EntityHelper.this.entity.getCmpField();
            Arrays.sort(cmpFields, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s1 = ((CmpField)o1).getFieldName();
                    String s2 = ((CmpField)o2).getFieldName();
                    if (s1 == null) {
                        s1 = "";
                    }
                    if (s2 == null) {
                        s2 = "";
                    }
                    return s1.compareTo(s2);
                }
            });
            return cmpFields;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.add(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.remove(listener);
        }

        public void change(Object source, String propertyName, Object oldValue, Object newValue) {
            if (source instanceof Entity) {
                this.cmpFieldHelperMap.keySet().retainAll(Arrays.asList(EntityHelper.this.entity.getCmpField()));
            }
            this.firePropertyChange(new PropertyChangeEvent(source, propertyName, oldValue, newValue));
        }

        protected void firePropertyChange(PropertyChangeEvent evt) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((PropertyChangeListener)iterator.next()).propertyChange(evt);
            }
        }

        public void addCmpField() {
            CallEjb.addCmpField((JavaClass)EntityHelper.this.getBeanClass(), (FileObject)EntityHelper.this.ejbJarFile);
            EntityHelper.this.modelUpdatedFromUI();
        }

        public CmpFieldsTableModel getCmpFieldsTableModel() {
            return this.cmpFieldsTableModel;
        }

        public int getFieldRow(CmpField cmpField) {
            CmpField[] fields = this.getCmpFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].equals(cmpField)) continue;
                return i;
            }
            return -1;
        }
    }
}

