/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.j2ee.persistence.entitygenerator.DbSchemaEjbGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSchemaTableProvider
implements TableProvider {
    private final SchemaElement schemaElement;
    private final PersistenceGenerator persistenceGen;
    private final Set<Table> tables;

    public DBSchemaTableProvider(SchemaElement schemaElement, PersistenceGenerator persistenceGen) {
        this.schemaElement = schemaElement;
        this.persistenceGen = persistenceGen;
        this.tables = this.buildTables();
    }

    @Override
    public Set<Table> getTables() {
        return this.tables;
    }

    private Set<Table> buildTables() {
        TableElement[] tableElements;
        HashMap<String, DBSchemaTable> name2Table = new HashMap<String, DBSchemaTable>();
        HashMap name2Referenced = new HashMap();
        HashMap name2ReferencedBy = new HashMap();
        HashMap name2Join = new HashMap();
        for (TableElement tableElement : tableElements = this.schemaElement.getTables()) {
            if (!tableElement.isTable()) continue;
            boolean join = DbSchemaEjbGenerator.isJoinTable(tableElement);
            List<Table.DisabledReason> disabledReasons = DBSchemaTableProvider.getDisabledReasons(tableElement, this.persistenceGen);
            Table.DisabledReason disabledReason = null;
            for (Table.DisabledReason reason : disabledReasons) {
                if (join && reason instanceof Table.NoPrimaryKeyDisabledReason) continue;
                disabledReason = reason;
                break;
            }
            String tableName = tableElement.getName().getName();
            DBSchemaTable table = new DBSchemaTable(tableName, join, disabledReason, this.persistenceGen);
            name2Table.put(tableName, table);
            name2Referenced.put(tableName, new HashSet());
            name2ReferencedBy.put(tableName, new HashSet());
            name2Join.put(tableName, new HashSet());
        }
        for (TableElement tableElement : tableElements) {
            if (!tableElement.isTable()) continue;
            String tableName = tableElement.getName().getName();
            Table table = (Table)name2Table.get(tableName);
            ForeignKeyElement[] foreignKeyElements = tableElement.getForeignKeys();
            if (foreignKeyElements == null) continue;
            for (ForeignKeyElement foreignKeyElement : foreignKeyElements) {
                TableElement referencedTableElement = foreignKeyElement.getReferencedTable();
                String referencedTableName = referencedTableElement.getName().getName();
                Table referencedTable = (Table)name2Table.get(referencedTableName);
                ((Set)name2Referenced.get(tableName)).add(referencedTable);
                ((Set)name2ReferencedBy.get(referencedTableName)).add(table);
                if (!table.isJoin()) continue;
                ((Set)name2Join.get(referencedTableName)).add(table);
            }
        }
        HashSet<DBSchemaTable> result = new HashSet<DBSchemaTable>();
        for (DBSchemaTable table : name2Table.values()) {
            String tableName = table.getName();
            table.setReferencedTables(Collections.unmodifiableSet((Set)name2Referenced.get(tableName)));
            table.setReferencedByTables(Collections.unmodifiableSet((Set)name2ReferencedBy.get(tableName)));
            table.setJoinTables(Collections.unmodifiableSet((Set)name2Join.get(tableName)));
            result.add(table);
        }
        return Collections.unmodifiableSet(result);
    }

    private static List<Table.DisabledReason> getDisabledReasons(TableElement tableElement, PersistenceGenerator persistenceGen) {
        String fqClassName;
        ArrayList<Table.DisabledReason> result = new ArrayList<Table.DisabledReason>();
        if (DBSchemaTableProvider.hasNoPrimaryKey(tableElement)) {
            result.add(new Table.NoPrimaryKeyDisabledReason());
        }
        if ((fqClassName = persistenceGen.getFQClassName(tableElement.getName().getName())) != null) {
            result.add(new Table.ExistingDisabledReason(fqClassName));
        }
        return result;
    }

    private static boolean hasNoPrimaryKey(TableElement tableElement) {
        return tableElement.getPrimaryKey() == null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DBSchemaTable
    extends Table {
        private final PersistenceGenerator persistenceGen;
        private Set<Table> referencedTables;
        private Set<Table> referencedByTables;
        private Set<Table> joinTables;

        public DBSchemaTable(String name, boolean join, Table.DisabledReason disabledReason, PersistenceGenerator persistenceGen) {
            super(name, join, disabledReason);
            this.persistenceGen = persistenceGen;
        }

        @Override
        public Set<Table> getReferencedTables() {
            return this.referencedTables;
        }

        private void setReferencedTables(Set<Table> referencedTables) {
            this.referencedTables = referencedTables;
        }

        @Override
        public Set<Table> getReferencedByTables() {
            return this.referencedByTables;
        }

        private void setReferencedByTables(Set<Table> referencedByTables) {
            this.referencedByTables = referencedByTables;
        }

        @Override
        public Set<Table> getJoinTables() {
            return this.joinTables;
        }

        private void setJoinTables(Set<Table> joinTables) {
            this.joinTables = joinTables;
        }
    }
}

