/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.html;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.editor.ext.html.dtd.ReaderProvider;
import org.netbeans.editor.ext.html.dtd.Registry;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.Repository;

public class NbReaderProvider
implements ReaderProvider {
    private static final String DTD_FOLDER = "DTDs";
    private static final String CATALOG_FILE_NAME = "catalog";
    Map mapping = null;
    boolean valid = false;
    FileObject dtdSetFolder;
    static Map folder2provider = new HashMap();

    public static void setupReaders() {
        FileObject rootFolder = Repository.getDefault().getDefaultFileSystem().getRoot();
        rootFolder.addFileChangeListener((FileChangeListener)new RootFolderListener());
        FileObject dtdFolder = rootFolder.getFileObject(DTD_FOLDER);
        if (dtdFolder != null) {
            dtdFolder.addFileChangeListener((FileChangeListener)new DTDFolderListener());
            NbReaderProvider.processSubfolders(dtdFolder);
        }
    }

    public NbReaderProvider(FileObject folder) {
        this.dtdSetFolder = folder;
        this.revalidate(true);
        folder.addFileChangeListener((FileChangeListener)new ProviderFolderListener());
    }

    public Collection getIdentifiers() {
        return this.valid ? this.mapping.keySet() : new HashSet(0);
    }

    public Reader getReaderForIdentifier(String identifier, String filename) {
        if (!this.valid) {
            return null;
        }
        String fileName = (String)this.mapping.get(identifier);
        if (fileName == null) {
            return null;
        }
        if (this.dtdSetFolder == null) {
            return null;
        }
        FileObject file = this.dtdSetFolder.getFileObject(fileName);
        if (fileName == null) {
            return null;
        }
        try {
            return new InputStreamReader(file.getInputStream());
        }
        catch (FileNotFoundException exc) {
            return null;
        }
    }

    private void invalidate() {
        if (this.valid) {
            this.valid = false;
            Registry.invalidateReaderProvider((ReaderProvider)this);
        }
    }

    private boolean revalidate(boolean flag) {
        if (this.mapping == null || flag) {
            FileObject catalog = this.dtdSetFolder.getFileObject(CATALOG_FILE_NAME);
            if (catalog == null) {
                this.mapping = null;
            } else {
                try {
                    this.mapping = this.parseCatalog(new InputStreamReader(catalog.getInputStream()));
                }
                catch (FileNotFoundException exc) {
                    this.mapping = null;
                }
            }
            if (this.mapping == null) {
                this.invalidate();
                return false;
            }
        }
        Collection files = this.mapping.values();
        boolean all = true;
        Iterator it = files.iterator();
        while (it.hasNext()) {
            String fname = (String)it.next();
            if (this.dtdSetFolder.getFileObject(fname) != null) continue;
            all = false;
            break;
        }
        if (!all) {
            this.invalidate();
        }
        this.valid = all;
        return this.valid;
    }

    private Map parseCatalog(Reader catalogReader) {
        HashMap<String, String> hashmap = new HashMap<String, String>();
        LineNumberReader reader = new LineNumberReader(catalogReader);
        while (true) {
            String line;
            try {
                line = reader.readLine();
            }
            catch (IOException exc) {
                return null;
            }
            if (line == null) break;
            StringTokenizer st = new StringTokenizer(line);
            if (!st.hasMoreTokens() || !"PUBLIC".equals(st.nextToken()) || !st.hasMoreTokens()) continue;
            st.nextToken("\"");
            if (!st.hasMoreTokens()) continue;
            String id = st.nextToken("\"");
            if (!st.hasMoreTokens()) continue;
            st.nextToken(" \t\n\r\f");
            if (!st.hasMoreTokens()) continue;
            String file = st.nextToken();
            hashmap.put(id, file);
        }
        return hashmap;
    }

    private static void processSubfolders(FileObject dtdFolder) {
        Enumeration en = dtdFolder.getFolders(false);
        while (en.hasMoreElements()) {
            FileObject folder = (FileObject)en.nextElement();
            NbReaderProvider.addFolder(folder);
        }
    }

    private static void removeSubfolders() {
        Iterator it = folder2provider.entrySet().iterator();
        folder2provider = new HashMap();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ReaderProvider prov = (ReaderProvider)entry.getValue();
            Registry.unregisterReaderProvider((ReaderProvider)prov);
        }
    }

    private static void addFolder(FileObject folder) {
        NbReaderProvider prov = new NbReaderProvider(folder);
        folder2provider.put(folder.getNameExt(), prov);
        Registry.registerReaderProvider((ReaderProvider)prov);
    }

    private static void removeFolder(FileObject folder) {
        NbReaderProvider prov = (NbReaderProvider)folder2provider.remove(folder.getNameExt());
        if (prov != null) {
            Registry.unregisterReaderProvider((ReaderProvider)prov);
        }
    }

    private static class DTDFolderListener
    extends FileChangeAdapter {
        private DTDFolderListener() {
        }

        public void fileFolderCreated(FileEvent fev) {
            FileObject file = fev.getFile();
            NbReaderProvider.addFolder(file);
        }

        public void fileDeleted(FileEvent fev) {
            FileObject file = fev.getFile();
            NbReaderProvider.removeFolder(file);
        }
    }

    private static class RootFolderListener
    extends FileChangeAdapter {
        private RootFolderListener() {
        }

        public void fileFolderCreated(FileEvent fev) {
            FileObject file = fev.getFile();
            if (NbReaderProvider.DTD_FOLDER.equals(file.getNameExt())) {
                file.addFileChangeListener((FileChangeListener)new DTDFolderListener());
                NbReaderProvider.processSubfolders(file);
            }
        }

        public void fileDeleted(FileEvent fev) {
            FileObject file = fev.getFile();
            if (NbReaderProvider.DTD_FOLDER.equals(file.getNameExt())) {
                NbReaderProvider.removeSubfolders();
            }
        }
    }

    private class ProviderFolderListener
    extends FileChangeAdapter {
        private ProviderFolderListener() {
        }

        public void fileDataCreated(FileEvent fev) {
            FileObject file = fev.getFile();
            if (!NbReaderProvider.this.valid) {
                boolean flag = true;
                NbReaderProvider.this.revalidate(flag);
            }
        }

        public void fileDeleted(FileEvent fev) {
            if (NbReaderProvider.this.valid) {
                NbReaderProvider.this.revalidate(true);
            }
        }

        public void fileRenamed(FileRenameEvent fev) {
            NbReaderProvider.this.invalidate();
            NbReaderProvider.this.revalidate(true);
        }

        public void fileChanged(FileEvent fev) {
            NbReaderProvider.this.invalidate();
            NbReaderProvider.this.revalidate(true);
        }
    }
}

