/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseImageTokenID;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.modules.editor.java.JavaKit;

class BracketCompletion {
    BracketCompletion() {
    }

    static void charInserted(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
        SyntaxSupport syntaxSupport = doc.getSyntaxSupport();
        if (!(syntaxSupport instanceof ExtSyntaxSupport) || !BracketCompletion.completionSettingEnabled()) {
            return;
        }
        ExtSyntaxSupport support = (ExtSyntaxSupport)syntaxSupport;
        if (ch == ')' || ch == ']' || ch == '(' || ch == '[') {
            TokenID tokenAtDot = support.getTokenID(dotPos);
            if (tokenAtDot == JavaTokenContext.RBRACKET || tokenAtDot == JavaTokenContext.RPAREN) {
                BracketCompletion.skipClosingBracket(doc, caret, ch);
            } else if (tokenAtDot == JavaTokenContext.LBRACKET || tokenAtDot == JavaTokenContext.LPAREN) {
                BracketCompletion.completeOpeningBracket(doc, dotPos, caret, ch);
            }
        } else if (ch == ';') {
            BracketCompletion.moveSemicolon(doc, dotPos, caret);
        }
    }

    private static void moveSemicolon(BaseDocument doc, int dotPos, Caret caret) throws BadLocationException {
        int eolPos = Utilities.getRowEnd((BaseDocument)doc, (int)dotPos);
        ExtSyntaxSupport ssup = (ExtSyntaxSupport)doc.getSyntaxSupport();
        int lastParenPos = dotPos;
        TokenItem token = ssup.getTokenChain(dotPos, eolPos);
        for (TokenItem item = token.getNext(); item != null && item.getOffset() <= eolPos; item = item.getNext()) {
            TokenID tokenID = item.getTokenID();
            if (tokenID == JavaTokenContext.RPAREN) {
                lastParenPos = item.getOffset();
                continue;
            }
            if (tokenID == JavaTokenContext.WHITESPACE) continue;
            return;
        }
        if (BracketCompletion.isForLoopSemicolon(token) || BracketCompletion.posWithinAnyQuote(doc, dotPos)) {
            return;
        }
        doc.remove(dotPos, 1);
        doc.insertString(lastParenPos, ";", null);
        caret.setDot(lastParenPos + 1);
    }

    private static boolean isForLoopSemicolon(TokenItem token) {
        if (token == null || token.getTokenID() != JavaTokenContext.SEMICOLON) {
            return false;
        }
        int parDepth = 0;
        int braceDepth = 0;
        boolean semicolonFound = false;
        for (token = token.getPrevious(); token != null; token = token.getPrevious()) {
            if (token.getTokenID() == JavaTokenContext.LPAREN) {
                if (parDepth == 0) {
                    for (token = token.getPrevious(); token != null && (token.getTokenID() == JavaTokenContext.WHITESPACE || token.getTokenID() == JavaTokenContext.BLOCK_COMMENT || token.getTokenID() == JavaTokenContext.LINE_COMMENT); token = token.getPrevious()) {
                    }
                    return token.getTokenID() == JavaTokenContext.FOR;
                }
                --parDepth;
                continue;
            }
            if (token.getTokenID() == JavaTokenContext.RPAREN) {
                ++parDepth;
                continue;
            }
            if (token.getTokenID() == JavaTokenContext.LBRACE) {
                if (braceDepth == 0) {
                    return false;
                }
                --braceDepth;
                continue;
            }
            if (token.getTokenID() == JavaTokenContext.RBRACE) {
                ++braceDepth;
                continue;
            }
            if (token.getTokenID() != JavaTokenContext.SEMICOLON) continue;
            if (semicolonFound) {
                return false;
            }
            semicolonFound = true;
        }
        return false;
    }

    static void charBackspaced(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
        if (BracketCompletion.completionSettingEnabled()) {
            char[] match;
            if (ch == '(' || ch == '[') {
                TokenID tokenAtDot = ((ExtSyntaxSupport)doc.getSyntaxSupport()).getTokenID(dotPos);
                if (tokenAtDot == JavaTokenContext.RBRACKET && BracketCompletion.tokenBalance(doc, (TokenID)JavaTokenContext.LBRACKET, (TokenID)JavaTokenContext.RBRACKET) != 0 || tokenAtDot == JavaTokenContext.RPAREN && BracketCompletion.tokenBalance(doc, (TokenID)JavaTokenContext.LPAREN, (TokenID)JavaTokenContext.RPAREN) != 0) {
                    doc.remove(dotPos, 1);
                }
            } else if (ch == '\"') {
                char[] match2 = doc.getChars(dotPos, 1);
                if (match2 != null && match2[0] == '\"') {
                    doc.remove(dotPos, 1);
                }
            } else if (ch == '\'' && (match = doc.getChars(dotPos, 1)) != null && match[0] == '\'') {
                doc.remove(dotPos, 1);
            }
        }
    }

    static boolean isAddRightBrace(BaseDocument doc, int caretOffset) throws BadLocationException {
        boolean addRightBrace = false;
        if (BracketCompletion.completionSettingEnabled() && caretOffset > 0) {
            int tokenOffset = caretOffset;
            TokenItem token = ((ExtSyntaxSupport)doc.getSyntaxSupport()).getTokenChain(tokenOffset - 1, tokenOffset);
            addRightBrace = true;
            int off = caretOffset - token.getOffset();
            if (off > 0 && off < token.getImage().length()) {
                switch (token.getTokenID().getNumericID()) {
                    case 5: 
                    case 7: {
                        break;
                    }
                    default: {
                        addRightBrace = false;
                    }
                }
            }
            if (addRightBrace) {
                int caretRowStartOffset = Utilities.getRowStart((BaseDocument)doc, (int)caretOffset);
                while (token != null && token.getOffset() >= caretRowStartOffset) {
                    boolean ignore = false;
                    switch (token.getTokenID().getNumericID()) {
                        case 5: 
                        case 7: 
                        case 8: {
                            ignore = true;
                        }
                    }
                    if (!ignore) break;
                    token = token.getPrevious();
                }
                if (token == null || token.getTokenID() != JavaTokenContext.LBRACE || token.getOffset() < caretRowStartOffset) {
                    addRightBrace = false;
                }
            }
            if (addRightBrace) {
                addRightBrace = BracketCompletion.braceBalance(doc) > 0;
            }
        }
        return addRightBrace;
    }

    static int getRowOrBlockEnd(BaseDocument doc, int caretOffset) throws BadLocationException {
        int rowEnd = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)caretOffset);
        if (rowEnd == -1 || caretOffset >= rowEnd) {
            return caretOffset;
        }
        int parenBalance = 0;
        int braceBalance = 0;
        int bracketBalance = 0;
        ExtSyntaxSupport ssup = (ExtSyntaxSupport)doc.getSyntaxSupport();
        block8: for (TokenItem token = ssup.getTokenChain(caretOffset, ++rowEnd); token != null && token.getOffset() < rowEnd; token = token.getNext()) {
            switch (token.getTokenID().getNumericID()) {
                case 53: {
                    ++parenBalance;
                    continue block8;
                }
                case 54: {
                    if (parenBalance-- == 0) {
                        return token.getOffset();
                    }
                }
                case 57: {
                    ++braceBalance;
                    continue block8;
                }
                case 58: {
                    if (braceBalance-- == 0) {
                        return token.getOffset();
                    }
                }
                case 55: {
                    ++bracketBalance;
                    continue block8;
                }
                case 56: {
                    if (bracketBalance-- != 0) continue block8;
                    return token.getOffset();
                }
            }
        }
        return rowEnd;
    }

    private static int braceBalance(BaseDocument doc) throws BadLocationException {
        return BracketCompletion.tokenBalance(doc, (TokenID)JavaTokenContext.LBRACE, (TokenID)JavaTokenContext.RBRACE);
    }

    private static int tokenBalance(BaseDocument doc, TokenID open, TokenID close) throws BadLocationException {
        ExtSyntaxSupport sup = (ExtSyntaxSupport)doc.getSyntaxSupport();
        BalanceTokenProcessor balanceTP = new BalanceTokenProcessor(open, close);
        sup.tokenizeText((TokenProcessor)balanceTP, 0, doc.getLength(), true);
        return balanceTP.getBalance();
    }

    private static void skipClosingBracket(BaseDocument doc, Caret caret, char bracket) throws BadLocationException {
        BaseImageTokenID bracketId = bracket == ')' ? JavaTokenContext.RPAREN : JavaTokenContext.RBRACKET;
        int caretOffset = caret.getDot();
        if (BracketCompletion.isSkipClosingBracket(doc, caretOffset, (TokenID)bracketId)) {
            doc.remove(caretOffset - 1, 1);
            caret.setDot(caretOffset);
        }
    }

    static boolean isSkipClosingBracket(BaseDocument doc, int caretOffset, TokenID bracketId) throws BadLocationException {
        if (caretOffset == doc.getLength()) {
            return false;
        }
        boolean skipClosingBracket = false;
        TokenItem token = ((ExtSyntaxSupport)doc.getSyntaxSupport()).getTokenChain(caretOffset, caretOffset + 1);
        if (token != null && token.getTokenID() == bracketId) {
            int tokenIntId;
            int bracketIntId = bracketId.getNumericID();
            int leftBracketIntId = bracketIntId == 54 ? 53 : 55;
            for (TokenItem nextToken = token.getNext(); nextToken != null && nextToken.getTokenID() == bracketId; nextToken = nextToken.getNext()) {
                token = nextToken;
            }
            int braceBalance = 0;
            int bracketBalance = -1;
            TokenItem lastRBracket = token;
            boolean finished = false;
            block13: for (token = token.getPrevious(); !finished && token != null; token = token.getPrevious()) {
                tokenIntId = token.getTokenID().getNumericID();
                switch (tokenIntId) {
                    case 53: 
                    case 55: {
                        if (tokenIntId != bracketIntId || ++bracketBalance != 0) continue block13;
                        if (braceBalance != 0) {
                            bracketBalance = 1;
                        }
                        finished = true;
                        continue block13;
                    }
                    case 54: 
                    case 56: {
                        if (tokenIntId != bracketIntId) continue block13;
                        --bracketBalance;
                        continue block13;
                    }
                    case 57: {
                        if (++braceBalance <= 0) continue block13;
                        finished = true;
                        continue block13;
                    }
                    case 58: {
                        --braceBalance;
                    }
                }
            }
            if (bracketBalance != 0) {
                skipClosingBracket = true;
            } else {
                braceBalance = 0;
                bracketBalance = 1;
                finished = false;
                block14: for (token = lastRBracket.getNext(); !finished && token != null; token = token.getPrevious()) {
                    tokenIntId = token.getTokenID().getNumericID();
                    switch (tokenIntId) {
                        case 53: 
                        case 55: {
                            if (tokenIntId != leftBracketIntId) continue block14;
                            ++bracketBalance;
                            continue block14;
                        }
                        case 54: 
                        case 56: {
                            if (tokenIntId != bracketIntId || --bracketBalance != 0) continue block14;
                            if (braceBalance != 0) {
                                bracketBalance = -1;
                            }
                            finished = true;
                            continue block14;
                        }
                        case 57: {
                            ++braceBalance;
                            continue block14;
                        }
                        case 58: {
                            if (--braceBalance >= 0) continue block14;
                            finished = true;
                        }
                    }
                }
                skipClosingBracket = bracketBalance == 0;
            }
        }
        return skipClosingBracket;
    }

    private static void completeOpeningBracket(BaseDocument doc, int dotPos, Caret caret, char bracket) throws BadLocationException {
        if (BracketCompletion.isCompletablePosition(doc, dotPos + 1)) {
            String matchinBracket = "" + BracketCompletion.matching(bracket);
            doc.insertString(dotPos + 1, matchinBracket, null);
            caret.setDot(dotPos + 1);
        }
    }

    private static boolean isEscapeSequence(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos <= 0) {
            return false;
        }
        char previousChar = doc.getChars(dotPos - 1, 1)[0];
        return previousChar == '\\';
    }

    static boolean completeQuote(BaseDocument doc, int dotPos, Caret caret, char bracket) throws BadLocationException {
        boolean insideString;
        if (!BracketCompletion.completionSettingEnabled()) {
            return false;
        }
        if (BracketCompletion.isEscapeSequence(doc, dotPos)) {
            return false;
        }
        SyntaxSupport s = doc.getSyntaxSupport();
        if (!(s instanceof ExtSyntaxSupport)) {
            return false;
        }
        ExtSyntaxSupport syntax = (ExtSyntaxSupport)s;
        TokenID token = null;
        if (doc.getLength() > dotPos) {
            token = syntax.getTokenID(dotPos);
        }
        if (token == JavaTokenContext.BLOCK_COMMENT || token == JavaTokenContext.LINE_COMMENT) {
            return false;
        }
        boolean completablePosition = BracketCompletion.isQuoteCompletablePosition(doc, dotPos);
        int lastNonWhite = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)dotPos);
        boolean eol = lastNonWhite < dotPos;
        boolean bl = insideString = token == JavaTokenContext.STRING_LITERAL || token == JavaTokenContext.CHAR_LITERAL;
        if (!insideString && token == JavaTokenContext.WHITESPACE && eol && dotPos - 1 > 0) {
            token = syntax.getTokenID(dotPos - 1);
            boolean bl2 = insideString = token == JavaTokenContext.STRING_LITERAL || token == JavaTokenContext.CHAR_LITERAL;
        }
        if (insideString) {
            if (eol) {
                return false;
            }
            char chr = doc.getChars(dotPos, 1)[0];
            if (chr == bracket) {
                doc.insertString(dotPos, "" + bracket, null);
                doc.remove(dotPos, 1);
                return true;
            }
        }
        if (completablePosition && !insideString || eol) {
            doc.insertString(dotPos, "" + bracket + bracket, null);
            return true;
        }
        return false;
    }

    private static boolean isCompletablePosition(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos == doc.getLength()) {
            return true;
        }
        char chr = doc.getChars(dotPos, 1)[0];
        return chr == ')' || chr == ',' || chr == '\"' || chr == '\'' || chr == ' ' || chr == ']' || chr == '}' || chr == '\n' || chr == '\t' || chr == ';';
    }

    private static boolean isQuoteCompletablePosition(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos == doc.getLength()) {
            return true;
        }
        int eol = Utilities.getRowEnd((BaseDocument)doc, (int)dotPos);
        if (dotPos == eol || eol == -1) {
            return false;
        }
        int firstNonWhiteFwd = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)dotPos, (int)eol);
        if (firstNonWhiteFwd == -1) {
            return false;
        }
        char chr = doc.getChars(firstNonWhiteFwd, 1)[0];
        return chr == ')' || chr == ',' || chr == '+' || chr == '}' || chr == ';';
    }

    private static boolean completionSettingEnabled() {
        return (Boolean)Settings.getValue((Class)JavaKit.class, (String)"pair-characters-completion");
    }

    private static char matching(char bracket) {
        switch (bracket) {
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
        }
        return ' ';
    }

    static boolean posWithinString(BaseDocument doc, int dotPos) {
        return BracketCompletion.posWithinQuotes(doc, dotPos, '\"', (TokenID)JavaTokenContext.STRING_LITERAL);
    }

    static boolean posWithinQuotes(BaseDocument doc, int dotPos, char quote, TokenID tokenID) {
        try {
            MyTokenProcessor proc = new MyTokenProcessor();
            doc.getSyntaxSupport().tokenizeText((TokenProcessor)proc, dotPos - 1, doc.getLength(), true);
            return proc.tokenID == tokenID && (dotPos - proc.tokenStart == 1 || doc.getChars(dotPos - 1, 1)[0] != quote);
        }
        catch (BadLocationException ex) {
            return false;
        }
    }

    static boolean posWithinAnyQuote(BaseDocument doc, int dotPos) {
        try {
            MyTokenProcessor proc = new MyTokenProcessor();
            doc.getSyntaxSupport().tokenizeText((TokenProcessor)proc, dotPos - 1, doc.getLength(), true);
            if (proc.tokenID == JavaTokenContext.STRING_LITERAL || proc.tokenID == JavaTokenContext.CHAR_LITERAL) {
                char[] ch = doc.getChars(dotPos - 1, 1);
                return dotPos - proc.tokenStart == 1 || ch[0] != '\"' && ch[0] != '\'';
            }
            return false;
        }
        catch (BadLocationException ex) {
            return false;
        }
    }

    static boolean isUnclosedStringAtLineEnd(BaseDocument doc, int dotPos) {
        try {
            MyTokenProcessor proc = new MyTokenProcessor();
            doc.getSyntaxSupport().tokenizeText((TokenProcessor)proc, Utilities.getRowLastNonWhite((BaseDocument)doc, (int)dotPos), doc.getLength(), true);
            return proc.tokenID == JavaTokenContext.STRING_LITERAL;
        }
        catch (BadLocationException ex) {
            return false;
        }
    }

    private static class BalanceTokenProcessor
    implements TokenProcessor {
        private TokenID leftTokenID;
        private TokenID rightTokenID;
        private int balance;

        BalanceTokenProcessor(TokenID leftTokenID, TokenID rightTokenID) {
            this.leftTokenID = leftTokenID;
            this.rightTokenID = rightTokenID;
        }

        public boolean token(TokenID tokenID, TokenContextPath tcp, int tokBuffOffset, int tokLength) {
            if (tokenID == this.leftTokenID) {
                ++this.balance;
            } else if (tokenID == this.rightTokenID) {
                --this.balance;
            }
            return true;
        }

        public int eot(int offset) {
            return 0;
        }

        public void nextBuffer(char[] buffer, int offset, int len, int startPos, int preScan, boolean lastBuffer) {
        }

        public int getBalance() {
            return this.balance;
        }
    }

    static class MyTokenProcessor
    implements TokenProcessor {
        public TokenID tokenID = null;
        public int tokenStart = -1;
        private int bufferStartPos = 0;

        MyTokenProcessor() {
        }

        public boolean token(TokenID tokenID, TokenContextPath tcp, int tokBuffOffset, int tokLength) {
            this.tokenStart = this.tokenBuffer2DocumentOffset(tokBuffOffset);
            this.tokenID = tokenID;
            return false;
        }

        public int eot(int offset) {
            return 0;
        }

        public void nextBuffer(char[] buffer, int offset, int len, int startPos, int preScan, boolean lastBuffer) {
            this.bufferStartPos = startPos - offset;
        }

        private int tokenBuffer2DocumentOffset(int offs) {
            return offs + this.bufferStartPos;
        }
    }
}

