/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.ConnectingDialog;
import org.netbeans.modules.autoupdate.ConnectingErrorDialog;
import org.netbeans.modules.autoupdate.DownloadProgressPanel;
import org.netbeans.modules.autoupdate.Downloader;
import org.netbeans.modules.autoupdate.FinishDialog;
import org.netbeans.modules.autoupdate.FirstPanel;
import org.netbeans.modules.autoupdate.LoginPanel;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Notification;
import org.netbeans.modules.autoupdate.PreparedModules;
import org.netbeans.modules.autoupdate.ResultsPanel;
import org.netbeans.modules.autoupdate.SafeModule;
import org.netbeans.modules.autoupdate.SelectModulesPanel;
import org.netbeans.modules.autoupdate.SignVerifier;
import org.netbeans.modules.autoupdate.UpdatePanel;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.XMLUpdates;
import org.netbeans.updater.UpdaterFrame;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class Wizard
implements WizardDescriptor.Iterator {
    private Updates updates;
    private static HashMap allUpdates = new HashMap();
    private static int errorType = 0;
    private static String errorMessage;
    private static RequestProcessor processor;
    private WizardPanel[][] panels = new WizardPanel[][]{{new StartPanel(), new PropPanel(), null, new ConfigPanel(), new DownloadPanel(), new LastPanel()}, {null, null, new SelectPanel(), null, null, null}};
    private int current = 0;
    private int modulesOK = 0;
    private boolean canceled = false;
    private int wizardType = 0;
    private WizardDescriptor wizardDescriptor;
    private List auTypesWithCust = new ArrayList();
    private HashMap installNow = new HashMap();
    static Dialog dialog;
    private PropertyChangeListener updater_listener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("FINISHED")) {
                Wizard.this.updaterFinished();
            }
        }
    };
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    Wizard() {
        this(null);
    }

    Wizard(HashMap allUpd) {
        this(allUpd, 0);
    }

    private void updaterFinished() {
        if (SafeModule.write(this.installNow)) {
            final String message = Wizard.getBundle("MSG_Install_Finished");
            StatusDisplayer.getDefault().setStatusText(message);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    if (message.equals(StatusDisplayer.getDefault().getStatusText())) {
                        StatusDisplayer.getDefault().setStatusText("");
                    }
                }
            }, 5000);
        } else {
            this.finishDialog(true);
        }
    }

    private void finishDialog(boolean all) {
        if (FinishDialog.showDialog()) {
            Collection modules = Wizard.getAllModules();
            Iterator it = modules.iterator();
            while (it.hasNext()) {
                ModuleUpdate mu = (ModuleUpdate)it.next();
                if (!mu.isInstallApproved() || !mu.isDownloadOK() || !all && mu.isSafeToInstall()) continue;
                if (!mu.isSafeToInstall() && mu.isToInstallDir() && !Downloader.tryMove(mu)) {
                    try {
                        mu.setToInstallDir(false);
                    }
                    catch (IllegalArgumentException iae) {
                        ErrorManager.getDefault().notify(1, (Throwable)iae);
                    }
                }
                PreparedModules.getPrepared().addModule(mu);
            }
            if (FinishDialog.isRestart()) {
                PreparedModules.getPrepared().delete();
                Autoupdater.restart();
            } else {
                PreparedModules.getPrepared().write();
            }
        } else {
            Downloader.deleteDownload();
        }
    }

    Wizard(HashMap allUpd, int wizardType) {
        this.wizardType = wizardType;
        PropertyChangeListener listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Object option;
                if (event.getPropertyName().equals("value") && ((option = event.getNewValue()) == WizardDescriptor.FINISH_OPTION || option == NotifyDescriptor.CANCEL_OPTION || option == NotifyDescriptor.CLOSED_OPTION)) {
                    if (option != WizardDescriptor.FINISH_OPTION) {
                        Wizard.this.canceled = true;
                        Downloader.deleteDownload();
                    }
                    Wizard.this.getCurrent().end(true);
                    dialog.setVisible(false);
                    Autoupdater.Support.deleteTempDir();
                    Autoupdater.setRunning(false);
                    dialog.dispose();
                    allUpdates.clear();
                    dialog = null;
                }
            }
        };
        Updates.reset();
        if (allUpd != null) {
            int ist = 3;
            allUpdates = allUpd;
            this.current = ist;
            if (wizardType == 0) {
                this.panels[0][ist].start(true);
            }
        }
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this);
        this.wizardDescriptor.setModal(false);
        this.wizardDescriptor.setTitle(Wizard.getBundle("CTL_Wizard"));
        this.wizardDescriptor.setTitleFormat(new MessageFormat(" {0}"));
        this.wizardDescriptor.setAdditionalOptions(new Object[0]);
        this.wizardDescriptor.addPropertyChangeListener(listener);
        this.wizardDescriptor.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
        this.wizardDescriptor.setOptions(new Object[]{WizardDescriptor.PREVIOUS_OPTION, WizardDescriptor.NEXT_OPTION, WizardDescriptor.FINISH_OPTION, NotifyDescriptor.CANCEL_OPTION});
    }

    static void go(HashMap allUpd) {
        Wizard.go(allUpd, 0);
    }

    static Wizard go(HashMap allUpd, int wizardType) {
        if (!Wizard.tryToRun()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Wizard.getBundle("MSG_WizardRunning"), 2));
            return null;
        }
        Wizard wiz = new Wizard(allUpd, wizardType);
        wiz.startDialog();
        return wiz;
    }

    void refreshUpdatePanel() {
        if (this.current == 3) {
            this.panels[0][this.current].start(true);
        }
    }

    public static void go() {
        if (!Wizard.tryToRun()) {
            if (dialog != null) {
                dialog.requestFocus();
                if (dialog instanceof JDialog) {
                    ((JDialog)dialog).getRootPane().requestDefaultFocus();
                }
            }
        } else {
            Wizard wiz = new Wizard();
            wiz.startDialog();
        }
    }

    private static synchronized boolean tryToRun() {
        if (!Autoupdater.isRunning()) {
            Autoupdater.setRunning(true);
            return true;
        }
        return false;
    }

    private void startDialog() {
        dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        this.canceled = false;
        dialog.setVisible(true);
        dialog.toFront();
    }

    public String name() {
        return this.getCurrent().getName();
    }

    public WizardDescriptor.Panel current() {
        return this.getCurrent();
    }

    private WizardPanel getCurrent() {
        return this.panels[this.wizardType][this.current] == null ? this.panels[0][this.current] : this.panels[this.wizardType][this.current];
    }

    public boolean hasNext() {
        if (this.current == 1 && this.getCurrent().nextPanelOffset() == -1) {
            return false;
        }
        return this.current < this.panels[this.wizardType].length - 1;
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public void nextPanel() {
        this.getCurrent().end(true);
        this.current = this.current < 0 && this.wizardType == 0 ? (this.current += 2) : (this.current == 0 && this.wizardType == 1 ? 2 : (this.current == 0 && this.wizardType == 0 && this.auTypesWithCust.size() == 0 ? 3 : (this.current == 1 && this.wizardType == 0 && this.auTypesWithCust.size() == 0 ? (this.current += 2) : (this.current == 1 && this.wizardType == 0 && this.auTypesWithCust.size() > 0 ? 1 : (this.current == 3 && this.getCurrent().nextPanelOffset() == 2 ? 5 : ++this.current)))));
        this.getCurrent().start(true);
    }

    public void previousPanel() {
        this.getCurrent().end(false);
        switch (this.current) {
            case 2: {
                if (this.wizardType == 1) {
                    this.current = 0;
                    break;
                }
                --this.current;
                break;
            }
            case 3: {
                if (this.wizardType == 0) {
                    this.current = 0;
                    break;
                }
                --this.current;
                break;
            }
            case 5: {
                this.current = 3;
                break;
            }
            default: {
                --this.current;
            }
        }
        this.getCurrent().start(false);
    }

    public synchronized void addChangeListener(ChangeListener listener) {
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
    }

    static HashMap getAllUpdates() {
        return allUpdates;
    }

    static void setAllUpdates(HashMap allUpd) {
        allUpdates = allUpd;
    }

    static Collection getAllModules() {
        HashSet ret = new HashSet();
        Iterator it = Wizard.getAllUpdates().values().iterator();
        while (it.hasNext()) {
            Collection modules = ((Updates)it.next()).getModules();
            if (modules == null) continue;
            ret.addAll(modules);
        }
        return ret;
    }

    static RequestProcessor getRequestProcessor() {
        if (processor == null) {
            processor = new RequestProcessor();
        }
        return processor;
    }

    private static String getBundle(String key) {
        return NbBundle.getMessage((Class)Wizard.class, (String)key);
    }

    static void resetErrorStore() {
        errorMessage = null;
        errorType = 0;
    }

    private static void storeError(int type, String msg) {
        if (type == 0) {
            throw new IllegalArgumentException("Type Updates.NO_ERROR is not error.");
        }
        errorType = type;
        errorMessage = msg;
    }

    static boolean isErrorStored() {
        return errorType != 0;
    }

    static int getStoredErrorType() {
        return errorType;
    }

    static String getStoredErrorMessage() {
        return errorMessage;
    }

    static int checkConnect(Updates updates, AutoupdateType at) {
        if (ConnectingDialog.isCanceled()) {
            return 1;
        }
        if (ConnectingDialog.isSkipped()) {
            return 2;
        }
        if (updates.isError()) {
            Wizard.storeError(updates.getError(), updates.getErrorMessage());
            return 2;
        }
        if (updates.getModules() != null && updates.getModules().size() > 0) {
            Notification.performNotification(updates, at);
        }
        return 0;
    }

    class SelectPanel
    extends WizardPanel {
        private SelectModulesPanel selectModulesPanel;

        SelectPanel() {
            this.selectModulesPanel = null;
        }

        String getName() {
            return Wizard.getBundle("CTL_SelectModulesPanel");
        }

        public Component getComponent() {
            if (this.selectModulesPanel == null) {
                this.selectModulesPanel = new SelectModulesPanel(this){

                    public Dimension getPreferredSize() {
                        return SelectPanel.this.WIZARD_SIZE;
                    }
                };
            }
            return this.selectModulesPanel;
        }

        public HelpCtx getHelp() {
            return null;
        }

        void start(boolean forward) {
            this.valid = false;
            if (forward) {
                ((SelectModulesPanel)this.getComponent()).reset();
            } else {
                this.setValid(true);
            }
        }

        void end(boolean forward) {
            if (forward && !Wizard.this.canceled) {
                Wizard.this.updates = new XMLUpdates(((SelectModulesPanel)this.getComponent()).getFiles());
                ((XMLUpdates)Wizard.this.updates).checkDownloadedModules();
                allUpdates.put(this, Wizard.this.updates);
            }
        }
    }

    class LastPanel
    extends WizardPanel {
        ResultsPanel resultsPanel;

        LastPanel() {
        }

        String getName() {
            return Wizard.getBundle(Wizard.this.wizardType == 0 ? "CTL_ResultsPanel" : "CTL_ResultsPanel_1");
        }

        public Component getComponent() {
            if (this.resultsPanel == null) {
                this.resultsPanel = new ResultsPanel(this){

                    public Dimension getPreferredSize() {
                        return LastPanel.this.WIZARD_SIZE;
                    }
                };
            }
            return this.resultsPanel;
        }

        public HelpCtx getHelp() {
            return null;
        }

        void start(boolean forward) {
            Wizard.this.modulesOK = ((ResultsPanel)this.getComponent()).generateResults();
        }

        void end(boolean forward) {
            if (Wizard.this.wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION && Wizard.this.modulesOK > 0) {
                Collection modules = Wizard.getAllModules();
                Iterator it = modules.iterator();
                Wizard.this.installNow = new HashMap();
                int otherCount = 0;
                while (it.hasNext()) {
                    ModuleUpdate mu = (ModuleUpdate)it.next();
                    if (!mu.isDownloadOK() || !Downloader.getNBM(mu).exists()) continue;
                    if (!mu.isInstallApproved()) {
                        Downloader.getNBM(mu).delete();
                        Downloader.getNBM(mu).deleteOnExit();
                        continue;
                    }
                    if (mu.isSafeToInstall()) {
                        if (mu.isToInstallDir() && !Downloader.tryMove(mu)) {
                            try {
                                mu.setToInstallDir(false);
                            }
                            catch (IllegalArgumentException iae) {
                                ErrorManager.getDefault().notify(1, (Throwable)iae);
                            }
                        }
                        Wizard.this.installNow.put(mu, Downloader.getMovedNBM(mu));
                        continue;
                    }
                    ++otherCount;
                }
                Autoupdater.Support.deleteTempDir();
                if (Wizard.this.installNow.size() > 0 && otherCount == 0) {
                    File[] filesInstallNow = new File[]{};
                    filesInstallNow = Wizard.this.installNow.values().toArray(filesInstallNow);
                    UpdaterFrame.runFromIDE(filesInstallNow, Wizard.this.updater_listener, NbBundle.getBranding());
                } else if (otherCount > 0) {
                    Wizard.this.finishDialog(false);
                } else {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Wizard.getBundle("MSG_WizardNoNbms"), 2));
                }
            }
            Autoupdater.setRunning(false);
        }
    }

    class DownloadPanel
    extends WizardPanel {
        private Downloader downloader;
        private SignVerifier signVerifier;
        private DownloadProgressPanel progressPanel;
        private boolean isDownloadFinished;

        DownloadPanel() {
            this.progressPanel = null;
        }

        String getName() {
            return Wizard.getBundle(Wizard.this.wizardType == 0 ? "CTL_DownloadPanel" : "CTL_CopyPanel");
        }

        public Component getComponent() {
            if (this.progressPanel == null) {
                this.progressPanel = new DownloadProgressPanel(this){

                    public Dimension getPreferredSize() {
                        return DownloadPanel.this.WIZARD_SIZE;
                    }
                };
            }
            return this.progressPanel;
        }

        public HelpCtx getHelp() {
            return null;
        }

        void start(boolean forward) {
            this.valid = false;
            this.isDownloadFinished = false;
            this.progressPanel = null;
            this.downloader = new Downloader((DownloadProgressPanel)this.getComponent(), this, Wizard.this.wizardType == 0);
            this.downloader.doDownload();
        }

        void end(boolean forward) {
            if (!this.valid) {
                if (!this.isDownloadFinished) {
                    this.downloader.cancelDownload();
                } else if (this.signVerifier != null) {
                    this.signVerifier.cancelVerify(Wizard.this.canceled);
                }
            }
        }
    }

    class ConfigPanel
    extends WizardPanel {
        private UpdatePanel updatePanel;

        ConfigPanel() {
            this.updatePanel = null;
        }

        public void setValid(boolean valid) {
            super.setValid(valid);
            if (dialog != null) {
                dialog.repaint();
            }
        }

        String getName() {
            return Wizard.getBundle("CTL_ConfigPanel");
        }

        public Component getComponent() {
            if (this.updatePanel == null) {
                this.updatePanel = new UpdatePanel(this){

                    public Dimension getPreferredSize() {
                        return ConfigPanel.this.WIZARD_SIZE;
                    }
                };
            }
            return this.updatePanel;
        }

        public HelpCtx getHelp() {
            return null;
        }

        public boolean isValid() {
            return this.valid;
        }

        void start(boolean forward) {
            this.valid = false;
            if (forward) {
                PreparedModules.readPrepared();
                if (Wizard.this.wizardType == 0) {
                    Iterator atypes = allUpdates.keySet().iterator();
                    while (atypes.hasNext()) {
                        AutoupdateType at = (AutoupdateType)((Object)atypes.next());
                        Updates upd = (Updates)allUpdates.get((Object)at);
                        at.setLastTimeStamp(upd.getTimeStamp());
                    }
                }
            }
            ((UpdatePanel)this.getComponent()).setUpdates(Wizard.this.wizardType);
        }

        void end(boolean forward) {
            if (forward) {
                ((UpdatePanel)this.getComponent()).markSelectedModules();
                if (!Wizard.this.canceled && !((UpdatePanel)this.getComponent()).checkLicencies()) {
                    Wizard.this.current--;
                }
            }
            ((UpdatePanel)this.getComponent()).removeListeners();
        }

        int nextPanelOffset() {
            if (((UpdatePanel)this.getComponent()).modulesToDownload() == 0) {
                return 2;
            }
            return 1;
        }

        void setUpdates(HashMap allUpd) {
            allUpdates.clear();
            allUpdates = allUpd;
        }
    }

    class PropPanel
    extends WizardPanel {
        LoginPanel lPanel;
        AutoupdateType currentAT;
        JPanel custPanel;
        HelpCtx userHelp;

        PropPanel() {
            this.userHelp = null;
        }

        String getName() {
            return Wizard.getBundle("CTL_StartPanel");
        }

        public void setValid(boolean valid) {
        }

        public Component getComponent() {
            if (this.lPanel == null) {
                this.lPanel = new LoginPanel(this){

                    public Dimension getPreferredSize() {
                        return PropPanel.this.WIZARD_SIZE;
                    }
                };
            }
            return this.lPanel;
        }

        public HelpCtx getHelp() {
            if (this.userHelp != null) {
                return this.userHelp;
            }
            return null;
        }

        void start(boolean forward) {
            if (this.custPanel != null) {
                return;
            }
            this.currentAT = (AutoupdateType)((Object)Wizard.this.auTypesWithCust.get(0));
            this.userHelp = null;
            try {
                this.custPanel = (JPanel)Introspector.getBeanInfo(((Object)((Object)this.currentAT)).getClass()).getBeanDescriptor().getCustomizerClass().newInstance();
                ((LoginPanel)this.getComponent()).setCustomizer(this.custPanel, this.currentAT);
                this.userHelp = (HelpCtx)this.custPanel.getClientProperty("Autoupdate_HelpID");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void end(boolean forward) {
            if (Wizard.this.wizardType == 0) {
                Downloader.deleteDownload();
                if (!Wizard.this.canceled && forward) {
                    Wizard.this.updates = this.currentAT.connectForUpdates();
                    Wizard.this.updates.checkUpdates((Validator)this, this.currentAT);
                    int res = Wizard.checkConnect(Wizard.this.updates, this.currentAT);
                    if (res == 0) {
                        allUpdates.put(this.currentAT, Wizard.this.updates);
                    } else if (res == 1) {
                        if (Wizard.this.updates.isError()) {
                            Wizard.this.current = -1;
                            return;
                        }
                        Wizard.this.current = -2;
                    }
                }
                Wizard.this.auTypesWithCust.remove(0);
                this.custPanel = null;
            }
        }
    }

    class StartPanel
    extends WizardPanel {
        FirstPanel firstPanel;

        StartPanel() {
        }

        String getName() {
            return Wizard.getBundle("CTL_StartPanel");
        }

        public void setValid(boolean valid) {
            Wizard.this.wizardType = ((FirstPanel)this.getComponent()).getWizardType();
        }

        public Component getComponent() {
            if (this.firstPanel == null) {
                this.firstPanel = new FirstPanel(this){

                    public Dimension getPreferredSize() {
                        return StartPanel.this.WIZARD_SIZE;
                    }
                };
            }
            return this.firstPanel;
        }

        public HelpCtx getHelp() {
            return null;
        }

        void end(boolean forward) {
            allUpdates.clear();
            Wizard.this.auTypesWithCust.clear();
            Wizard.resetErrorStore();
            Downloader.deleteDownload();
            if (Wizard.this.wizardType == 0 && !Wizard.this.canceled) {
                int sum = 0;
                Enumeration en = AutoupdateType.autoupdateTypes();
                while (en.hasMoreElements()) {
                    AutoupdateType at = (AutoupdateType)((Object)en.nextElement());
                    boolean hasCust = false;
                    if (!at.isEnabled()) continue;
                    try {
                        if (Introspector.getBeanInfo(((Object)((Object)at)).getClass()).getBeanDescriptor().getCustomizerClass() != null) {
                            Wizard.this.auTypesWithCust.add(at);
                            ++sum;
                            hasCust = true;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (hasCust) continue;
                    Wizard.this.updates = at.connectForUpdates();
                    Wizard.this.updates.checkUpdates((Validator)this, at);
                    int res = Wizard.checkConnect(Wizard.this.updates, at);
                    if (res == 0) {
                        ++sum;
                        allUpdates.put(at, Wizard.this.updates);
                        continue;
                    }
                    if (res != 1) continue;
                    Wizard.this.current = -2;
                    return;
                }
                if (sum == 0) {
                    if (Wizard.isErrorStored()) {
                        ConnectingErrorDialog.showDialog(errorType, errorMessage);
                    } else {
                        ConnectingErrorDialog.showDialog(3, null);
                    }
                    Wizard.this.current = -2;
                    return;
                }
            }
        }
    }

    abstract class WizardPanel
    implements WizardDescriptor.Panel,
    Validator {
        protected Dimension WIZARD_SIZE = new Dimension(550, 400);
        protected boolean valid = true;
        private EventListenerList listenerList = new EventListenerList();

        WizardPanel() {
        }

        void start(boolean forward) {
        }

        void end(boolean forward) {
        }

        int nextPanelOffset() {
            return 1;
        }

        abstract String getName();

        public void setValid(boolean valid) {
            this.valid = valid;
            this.fireChangeListenerStateChanged(this);
        }

        public boolean isValid() {
            return this.valid;
        }

        public HelpCtx getHelp() {
            return null;
        }

        public abstract Component getComponent();

        public void readSettings(Object settings) {
        }

        public void storeSettings(Object settings) {
        }

        public synchronized void addChangeListener(ChangeListener listener) {
            this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = Wizard.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, listener);
        }

        public synchronized void removeChangeListener(ChangeListener listener) {
            this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = Wizard.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, listener);
        }

        protected void fireChangeListenerStateChanged(Object param1) {
            ChangeEvent e = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? Wizard.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
                if (e == null) {
                    e = new ChangeEvent(param1);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(e);
            }
        }
    }

    static interface Validator {
        public void setValid(boolean var1);
    }
}

