/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

class CheckedInResponse
implements Response {
    private DateFormat dateFormatter;

    CheckedInResponse() {
    }

    public void process(LoggedDataInputStream dis, ResponseServices services) throws ResponseException {
        try {
            String localPath = dis.readLine();
            String repositoryPath = dis.readLine();
            String entriesLine = dis.readLine();
            File theFile = new File(services.convertPathname(localPath, repositoryPath));
            Date date = new Date(theFile.lastModified());
            Entry entry = new Entry(entriesLine);
            entry.setConflict(this.getDateFormatter().format(date));
            if (entry.isNewUserFile() || entry.isUserFileToBeRemoved()) {
                entry.setConflict("dummy timestamp");
            }
            services.setEntry(theFile, entry);
        }
        catch (IOException e) {
            throw new ResponseException((Exception)e.fillInStackTrace(), e.getLocalizedMessage());
        }
    }

    public boolean isTerminalResponse() {
        return false;
    }

    protected DateFormat getDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new SimpleDateFormat(Entry.getLastModifiedDateFormatter().toPattern(), Locale.US);
            this.dateFormatter.setTimeZone(Entry.getTimeZone());
        }
        return this.dateFormatter;
    }
}

