/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.PageInfo;
import org.openide.ErrorManager;

public class CompilerHacks {
    private Compiler comp;
    protected JspCompilationContext ctxt;
    private static Field pageInfoF;
    private static Field errDispatcherF;

    public CompilerHacks(JspCompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    static void initMethodsAndFields() {
        try {
            pageInfoF = Compiler.class.getDeclaredField("pageInfo");
            pageInfoF.setAccessible(true);
            errDispatcherF = Compiler.class.getDeclaredField("errDispatcher");
            errDispatcherF.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    private void setupCompiler() throws JasperException {
        if (this.comp == null) {
            this.comp = this.ctxt.createCompiler();
            CompilerHacks.setErrDispatcherInCompiler(this.comp, new ErrorDispatcher(false));
            CompilerHacks.setPageInfoInCompiler(this.comp, new HackPageInfo(new BeanRepository(this.ctxt.getClassLoader(), this.comp.getErrorDispatcher()), ""));
        }
    }

    Compiler getCompiler() throws JasperException {
        this.setupCompiler();
        return this.comp;
    }

    private static void setPageInfoInCompiler(Compiler c, PageInfo pageInfo) throws JasperException {
        try {
            pageInfoF.set(c, pageInfo);
        }
        catch (IllegalAccessException e) {
            throw new JasperException((Throwable)e);
        }
    }

    private static void setErrDispatcherInCompiler(Compiler c, ErrorDispatcher errDispatcher) throws JasperException {
        try {
            errDispatcherF.set(c, errDispatcher);
        }
        catch (IllegalAccessException e) {
            throw new JasperException((Throwable)e);
        }
    }

    static {
        CompilerHacks.initMethodsAndFields();
    }

    class HackPageInfo
    extends PageInfo {
        private Map approxXmlPrefixMapper;

        HackPageInfo(BeanRepository beanRepository, String jspFile) {
            super(beanRepository, jspFile);
            this.approxXmlPrefixMapper = new HashMap();
        }

        public void pushPrefixMapping(String prefix, String uri) {
            super.pushPrefixMapping(prefix, uri);
            if (uri != null) {
                this.approxXmlPrefixMapper.put(prefix, uri);
            }
        }

        Map getApproxXmlPrefixMapper() {
            return this.approxXmlPrefixMapper;
        }
    }
}

