/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.ejb.ui.panels;

import com.sun.jdo.api.persistence.mapping.core.ClassState;
import com.sun.jdo.api.persistence.mapping.core.TableState;
import com.sun.jdo.api.persistence.mapping.ejb.EJBInfoHelper;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.modules.persistence.mapping.core.ui.panels.SecondaryTablePanel;
import com.sun.jdo.modules.persistence.mapping.core.util.MappingContext;
import com.sun.jdo.modules.persistence.mapping.core.util.Util;
import com.sun.jdo.modules.persistence.mapping.ejb.ui.panels.ConsistencyLevelPanel;
import com.sun.jdo.modules.persistence.mapping.ejb.util.SunOneUtilsCMP;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AdvancedSettingsPanel
extends JPanel
implements ActionListener {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)AdvancedSettingsPanel.class);
    private static final String EMPTY_STRING = bundle.getString("CFM_choose_schema");
    private MappingContext mappingContext = null;
    private List dbSchemaFiles = null;
    private ConsistencyLevelPanel consistencyLevelPanel = null;
    private SecondaryTablePanel secondaryTable = null;
    private TableState origTableState;
    private ClassState classStateObject;
    private int consistencyLevel = 0;
    private EJBInfoHelper infoHelper;
    private boolean listenerEnabled = false;
    private DialogDescriptor dd = null;
    private Dialog d = null;
    private boolean showExtensions = true;
    private JComboBox dbSchemaComboBox;
    private JLabel dbSchemaLabel;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;

    public AdvancedSettingsPanel(MappingContext context, EJBInfoHelper infoHelper, ClassState classState) {
        this.mappingContext = context;
        this.infoHelper = infoHelper;
        this.dbSchemaFiles = new ArrayList(infoHelper.getAvailableSchemaNames());
        this.classStateObject = classState;
        this.origTableState = (TableState)classState.getTableState().clone();
        this.consistencyLevel = classState.getTableState().getConsistencyLevel();
        HelpCtx.setHelpIDString((JComponent)this, (String)bundle.getString("HelpID_Advanced_Settings"));
        this.initComponents();
        this.initAccessibility();
        this.setSchemaFiles();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.dbSchemaLabel = new JLabel();
        this.dbSchemaComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jPanel2 = new ConsistencyLevelPanel(this.mappingContext, this.classStateObject);
        this.consistencyLevelPanel = (ConsistencyLevelPanel)this.jPanel2;
        this.consistencyLevelPanel.setConsistencyLevel(this.consistencyLevel);
        this.jPanel3 = new SecondaryTablePanel(bundle.getString("ADV_LBL_secondary_table"), this.mappingContext);
        this.secondaryTable = (SecondaryTablePanel)this.jPanel3;
        this.secondaryTable.setStateObject(this.classStateObject);
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(500, 300));
        this.jPanel1.setLayout(new GridBagLayout());
        this.dbSchemaLabel.setDisplayedMnemonic(bundle.getString("ADV_database_schema_Mnemonic").trim().charAt(0));
        this.dbSchemaLabel.setLabelFor(this.dbSchemaComboBox);
        this.dbSchemaLabel.setText(bundle.getString("ADV_LBL_database_schema"));
        this.dbSchemaLabel.setToolTipText(bundle.getString("ADV_TT_database_schema"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.dbSchemaLabel, gridBagConstraints);
        this.dbSchemaComboBox.setMinimumSize(new Dimension(200, 25));
        this.dbSchemaComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                AdvancedSettingsPanel.this.dbSchemaComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.dbSchemaComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.3;
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel4.setBorder(new TitledBorder(new EtchedBorder(), this.mappingContext.getString("PROP_consistencyLevel")));
        this.jPanel4.setMinimumSize(new Dimension(450, 200));
        this.jPanel2.setMinimumSize(null);
        this.jPanel2.setPreferredSize(null);
        this.jPanel4.add((Component)this.jPanel2, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel3.setBorder(new TitledBorder(new EtchedBorder(), bundle.getString("ADV_LBL_secondary_table_box")));
        this.jPanel3.setToolTipText(this.mappingContext.getString("HINT_secondary_tables"));
        this.jPanel3.setMinimumSize(new Dimension(450, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jPanel3, gridBagConstraints);
    }

    private void dbSchemaComboBoxItemStateChanged(ItemEvent evt) {
        if (this.listenerEnabled && 1 == evt.getStateChange()) {
            if (this.setSelectedSchema()) {
                this.secondaryTable.setStateObject(this.classStateObject);
                this.setSchemaFiles();
            } else {
                this.listenerEnabled = false;
                this.dbSchemaComboBox.setSelectedItem(this.classStateObject.getTableState().getCurrentSchemaName() + (this.showExtensions ? ".dbschema" : ""));
                this.listenerEnabled = true;
            }
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ADV_MSG_accessibility"));
    }

    private void setSchemaFiles() {
        this.listenerEnabled = false;
        if (this.dbSchemaFiles == null || this.dbSchemaFiles.size() == 0) {
            Vector<String> v = new Vector<String>();
            v.add(EMPTY_STRING);
            DefaultComboBoxModel model = new DefaultComboBoxModel(v);
            this.dbSchemaComboBox.setModel(model);
            this.dbSchemaComboBox.setEnabled(false);
            this.consistencyLevelPanel.setEnabled(false);
        } else {
            Vector<String> v = new Vector<String>(this.dbSchemaFiles);
            String schema = this.classStateObject.getTableState().getCurrentSchemaName();
            String sn = schema + (this.showExtensions ? ".dbschema" : "");
            if (StringHelper.isEmpty(schema)) {
                v.insertElementAt(EMPTY_STRING, 0);
                this.consistencyLevelPanel.setEnabled(false);
            } else {
                this.consistencyLevelPanel.setEnabled(true);
            }
            DefaultComboBoxModel model = new DefaultComboBoxModel(v);
            this.dbSchemaComboBox.setModel(model);
            if (v.size() > 1 && v.contains(sn)) {
                this.dbSchemaComboBox.setSelectedItem(sn);
            }
        }
        this.listenerEnabled = true;
    }

    public boolean showAsDialog(String title) {
        this.dd = new DialogDescriptor((Object)this, title, true, -1, NotifyDescriptor.OK_OPTION, 0, HelpCtx.findHelp((Component)this), (ActionListener)this);
        this.dd.setClosingOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
        this.d = DialogDisplayer.getDefault().createDialog(this.dd);
        this.d.setVisible(true);
        if (this.dd.getValue() == NotifyDescriptor.OK_OPTION) {
            int newLevel = this.consistencyLevelPanel.getConsistencyLevel();
            if (newLevel != this.consistencyLevel) {
                this.classStateObject.getTableState().setConsistencyLevel(newLevel);
            }
            this.setVersionColumnMapping(newLevel);
            return true;
        }
        this.classStateObject.setTableState(this.origTableState);
        return false;
    }

    private void setVersionColumnMapping(int level) {
        if (16 == level) {
            Iterator iterator = this.classStateObject.getMappingClassElement().getFields().iterator();
            Object versionColumn = this.consistencyLevelPanel.getVersionColumn();
            MappingFieldElement versionField = null;
            while (iterator.hasNext() && versionField == null) {
                MappingFieldElement nextField = (MappingFieldElement)iterator.next();
                if (!nextField.isVersion()) continue;
                versionField = nextField;
            }
            if (versionField != null && versionColumn instanceof ColumnElement) {
                this.classStateObject.getFieldHolderState().setCurrentMapping(this.classStateObject.getPersistenceClassElement().getField(versionField.getName()), (ColumnElement)versionColumn);
            }
        }
    }

    private boolean setSelectedSchema() {
        String fullName = (String)this.dbSchemaComboBox.getSelectedItem();
        String schemaFileName = SunOneUtilsCMP.removeSchemaFileNameExtension(fullName);
        SchemaElement schema = this.infoHelper.getSchema(schemaFileName);
        if (schema == null) {
            String error = MessageFormat.format(bundle.getString("CFM_Err_schema_null"), fullName);
            Util.showError(new Exception(error));
            return false;
        }
        this.classStateObject.getTableState().setCurrentSchema(schema);
        return true;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase(NbBundle.getBundle((Class)NotifyDescriptor.class).getString("CTL_OK"))) {
            if (this.consistencyLevelPanel.hasCompleteContents()) {
                this.d.dispose();
                this.d = null;
            }
            this.dd.setValue(NotifyDescriptor.OK_OPTION);
        }
    }
}

