/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.core.ui.panels;

import com.sun.jdo.api.persistence.mapping.core.ClassState;
import com.sun.jdo.api.persistence.mapping.core.MappingStrategy;
import com.sun.jdo.api.persistence.mapping.core.TableState;
import com.sun.jdo.modules.persistence.mapping.core.ui.panels.MappingContextPanel;
import com.sun.jdo.modules.persistence.mapping.core.ui.panels.SecondaryTableSelectorPanel;
import com.sun.jdo.modules.persistence.mapping.core.util.DBListElement;
import com.sun.jdo.modules.persistence.mapping.core.util.MappingContext;
import com.sun.jdo.modules.persistence.mapping.core.util.Util;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.ui.CustomListCellRenderer;
import com.sun.jdo.spi.persistence.utility.ui.IconWrapper;
import com.sun.jdo.spi.persistence.utility.ui.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.util.NameUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;

public class SecondaryTablePanel
extends MappingContextPanel
implements EnhancedCustomPropertyEditor {
    String label;
    private JButton AddButton;
    private JButton RemoveButton;
    private JList SecondaryTableList;
    private JButton EditButton;
    private JScrollPane jScrollPane1;
    private TableState tableStateObject;
    private DefaultListModel SecondaryTableListModel;
    private ClassState _classState;

    public SecondaryTablePanel(String label, MappingContext mappingContext) {
        super(mappingContext);
        this.label = label;
        this.initComponents();
        this.initAccessibility();
    }

    public SecondaryTablePanel(MappingContext mappingContext) {
        this(mappingContext.getString("LBL_secondary_table_no_op"), mappingContext);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.getMappingContext().getString("ACSD_Secondary_Table"));
    }

    private void initComponents() {
        MappingContext mappingContext = this.getMappingContext();
        this.jScrollPane1 = new JScrollPane();
        this.SecondaryTableList = new JList();
        this.AddButton = new JButton();
        this.RemoveButton = new JButton();
        this.EditButton = new JButton();
        JLabel databaseSecondaryTableLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(250, 125));
        this.SecondaryTableList.setCellRenderer(new CustomListCellRenderer());
        this.SecondaryTableList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                SecondaryTablePanel.this.SecondaryTableListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.SecondaryTableList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.AddButton.setMnemonic(mappingContext.getMnemonic("CTL_Mnemonic_ADD"));
        this.AddButton.setText(mappingContext.getString("CTL_ADD"));
        this.AddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SecondaryTablePanel.this.AddButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.AddButton, gridBagConstraints);
        this.RemoveButton.setMnemonic(mappingContext.getMnemonic("CTL_Mnemonic_REMOVE"));
        this.RemoveButton.setText(mappingContext.getString("CTL_REMOVE"));
        this.RemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SecondaryTablePanel.this.RemoveButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.RemoveButton, gridBagConstraints);
        this.EditButton.setToolTipText(mappingContext.getString("HINT_EDIT"));
        this.EditButton.setMnemonic(mappingContext.getMnemonic("CTL_Mnemonic_EDIT"));
        this.EditButton.setText(mappingContext.getString("CTL_EDIT"));
        this.EditButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SecondaryTablePanel.this.EditButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.EditButton, gridBagConstraints);
        databaseSecondaryTableLabel.setText(this.label);
        databaseSecondaryTableLabel.setDisplayedMnemonic(mappingContext.getMnemonic("LBL_Mnemonic_secondary_table"));
        databaseSecondaryTableLabel.setLabelFor(this.SecondaryTableList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)databaseSecondaryTableLabel, gridBagConstraints);
    }

    private void SecondaryTableListValueChanged(ListSelectionEvent evt) {
        this.setButtonStates();
    }

    private void EditButtonActionPerformed(ActionEvent evt) {
        TableElement lTable = this.getSelectedTableElement();
        if (lTable != null) {
            TableState lNewState = SecondaryTableSelectorPanel.launchWindow(this.tableStateObject, lTable, this.getMappingContext());
            if (lNewState != null) {
                this.setTableState(lNewState);
            }
            this.selectEditedSecondaryTable(lTable);
            SwingUtils.scrollSelectedToVisible(this.SecondaryTableList);
        }
    }

    private void RemoveButtonActionPerformed(ActionEvent evt) {
        int[] rows = this.SecondaryTableList.getSelectedIndices();
        int count = rows != null ? rows.length : 0;
        TableState lNewState = (TableState)this.tableStateObject.clone();
        for (int i = count - 1; i >= 0; --i) {
            Object lValue = this.SecondaryTableListModel.getElementAt(rows[i]);
            String tableToRemove = null;
            if (lValue instanceof DBListElement) {
                TableElement lTable = (TableElement)((DBListElement)lValue).getFirstElement();
                if (lTable != null) {
                    tableToRemove = lTable.getName().getName();
                }
            } else if (lValue instanceof IconWrapper) {
                tableToRemove = lValue.toString();
            }
            if (tableToRemove == null) continue;
            lNewState.removeSecondaryTable(tableToRemove);
        }
        if (count > 0 && lNewState != null) {
            this.setTableState(lNewState);
        }
        if (rows != null && rows.length > 0) {
            SwingUtils.selectNearestRow(this.SecondaryTableList, rows[0]);
            SwingUtils.scrollSelectedToVisible(this.SecondaryTableList);
        }
    }

    private void AddButtonActionPerformed(ActionEvent evt) {
        List tables = this.tableStateObject.getSortedUnusedSchemaTables();
        if (tables == null || tables.size() == 0) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)this.getMappingContext().getString("MSG_No_Secondary_Tables"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return;
        }
        TableState lNewState = SecondaryTableSelectorPanel.launchWindow(this.tableStateObject, null, this.getMappingContext());
        DefaultListModel oldModel = this.SecondaryTableListModel;
        if (lNewState != null) {
            this.setTableState(lNewState);
        }
        this.selectAddedSecondaryTable(oldModel);
        SwingUtils.scrollSelectedToVisible(this.SecondaryTableList);
    }

    public void requestFocus() {
        this.AddButton.requestFocus();
    }

    private void loadSecondaryTableList() {
        if (this.tableStateObject != null) {
            Iterator iterator = this.tableStateObject.getSortedSecondaryTables().iterator();
            this.SecondaryTableListModel = new DefaultListModel();
            while (iterator.hasNext()) {
                String tableName = (String)iterator.next();
                String absoluteTableName = NameUtil.getAbsoluteTableName((String)this.tableStateObject.getCurrentSchemaName(), (String)tableName);
                TableElement table = TableElement.forName((String)absoluteTableName);
                Object objectToAdd = null;
                objectToAdd = table != null ? new DBListElement((DBElement)table, this.getMappingContext().getString("VALUE_unmapped")) : new IconWrapper(tableName, Util.getIllegalIcon());
                this.SecondaryTableListModel.addElement(objectToAdd);
            }
            this.SecondaryTableList.setModel(this.SecondaryTableListModel);
            this.setListSelection();
            this.setButtonStates();
            SwingUtils.autosizeList(this.SecondaryTableList, this.jScrollPane1);
        }
    }

    private void setListSelection() {
        if (this.SecondaryTableList.getModel().getSize() > 0) {
            this.SecondaryTableList.setSelectedIndex(0);
        }
    }

    private void setButtonStates() {
        boolean hasPrimary = this.tableStateObject.getCurrentPrimaryTable() != null;
        boolean hasSelection = hasPrimary && this.getSelectedTable() != null;
        boolean hasLegalSingeSelection = hasSelection && this.getSelectedTableElement() != null && this.SecondaryTableList.getSelectedIndices().length == 1;
        this.AddButton.setEnabled(hasPrimary);
        this.EditButton.setEnabled(hasLegalSingeSelection);
        this.RemoveButton.setEnabled(hasSelection);
    }

    public void setTableState(TableState state) {
        if (this.tableStateObject != null) {
            MappingStrategy strategy;
            if (!this.tableStateObject.equals(state) && Util.checkForWarning((strategy = new MappingStrategy(this.getMappingContext().getBrandedBundle("com.sun.jdo.api.persistence.mapping.core.Bundle"))).prepareAttach(this._classState.getFieldHolderState(), state))) {
                this._classState.setTableState(state);
                this.tableStateObject = state;
            }
        } else {
            this.tableStateObject = state;
        }
        this.loadSecondaryTableList();
        this.firePropertyChange("valid", null, JavaTypeHelper.valueOf(SecondaryTablePanel.isValidMapping(this.tableStateObject)));
    }

    public void setStateObject(ClassState state) {
        this._classState = state;
        if (state != null) {
            this.tableStateObject = state.getTableState();
        }
        this.loadSecondaryTableList();
    }

    private static boolean isValidMapping(TableState state) {
        if (state != null) {
            Iterator iterator = state.getSortedSecondaryTables().iterator();
            while (iterator.hasNext()) {
                String tableName = (String)iterator.next();
                String absoluteTableName = NameUtil.getAbsoluteTableName((String)state.getCurrentSchemaName(), (String)tableName);
                TableElement table = TableElement.forName((String)absoluteTableName);
                if (table != null) continue;
                return false;
            }
        }
        return true;
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.tableStateObject;
    }

    private String getSelectedTable() {
        Object selectedValue = this.SecondaryTableList.getSelectedValue();
        return selectedValue != null ? selectedValue.toString() : null;
    }

    private TableElement getSelectedTableElement() {
        Object selectedValue = this.SecondaryTableList.getSelectedValue();
        if (selectedValue != null && selectedValue instanceof DBListElement) {
            DBListElement lElement = (DBListElement)selectedValue;
            return lElement != null ? (TableElement)lElement.getFirstElement() : null;
        }
        return null;
    }

    private final void selectAddedSecondaryTable(DefaultListModel old_model) {
        int n = this.SecondaryTableListModel.getSize();
        int m = old_model.getSize();
        for (int i = 0; i < n; ++i) {
            Object elem = this.SecondaryTableListModel.getElementAt(i);
            boolean contains = false;
            for (int j = 0; j < m; ++j) {
                if (!elem.equals(old_model.getElementAt(j))) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            this.SecondaryTableList.setSelectionInterval(i, i);
            return;
        }
    }

    private final void selectEditedSecondaryTable(TableElement selected) {
        String old = selected.toString();
        for (int i = this.SecondaryTableListModel.getSize() - 1; i >= 0; --i) {
            if (!old.equals(this.SecondaryTableListModel.elementAt(i).toString())) continue;
            this.SecondaryTableList.setSelectedIndex(i);
            return;
        }
    }
}

