/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.config.model.Converter;
import org.netbeans.modules.web.jsf.config.model.FacesConfig;
import org.netbeans.modules.web.jsf.config.model.ManagedBean;
import org.netbeans.modules.web.jsf.editor.JSFEditorUtilities;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Occurrences {
    public static List<OccurrenceItem> getAllOccurrences(JavaClass javaClass, String newName) {
        FileObject[] configs;
        ArrayList<OccurrenceItem> result = new ArrayList<OccurrenceItem>();
        FileObject foJava = JavaModel.getFileObject((Resource)javaClass.getResource());
        WebModule wm = WebModule.getWebModule((FileObject)foJava);
        if (wm != null && (configs = JSFConfigUtilities.getConfiFilesFO(wm.getDeploymentDescriptor())) != null) {
            String type = javaClass.getName();
            try {
                for (int i = 0; i < configs.length; ++i) {
                    DataObject dObject = DataObject.find((FileObject)configs[i]);
                    if (!(dObject instanceof JSFConfigDataObject)) continue;
                    JSFConfigDataObject configDO = (JSFConfigDataObject)dObject;
                    FacesConfig config = configDO.getFacesConfig();
                    Converter[] converters = config.getConverter();
                    for (int j = 0; j < converters.length; ++j) {
                        if (type.equals(converters[j].getConverterClass())) {
                            result.add(new ConverterClassItem(configDO, converters[j], newName));
                            continue;
                        }
                        if (!type.equals(converters[j].getConverterForClass())) continue;
                        result.add(new ConverterForClassItem(configDO, converters[j], newName));
                    }
                    ManagedBean[] managedBeans = config.getManagedBean();
                    for (int j = 0; j < managedBeans.length; ++j) {
                        if (!type.equals(managedBeans[j].getManagedBeanClass())) continue;
                        result.add(new ManagedBeanClassItem(configDO, managedBeans[j], newName));
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return result;
    }

    public static class ConverterForClassItem
    extends OccurrenceItem {
        private Converter converter;

        public ConverterForClassItem(JSFConfigDataObject config, Converter converter, String newValue) {
            super(config, newValue, converter.getConverterForClass());
            this.converter = converter;
        }

        protected String getXMLElementName() {
            return "converter-for-class";
        }

        public void performRename() {
            this.changeConverterForClass(this.oldValue, this.newValue);
        }

        public void undoRename() {
            this.changeConverterForClass(this.newValue, this.oldValue);
        }

        public String getWhereUsedMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterForClass_WhereUsed", (Object)this.getElementText());
        }

        public String getRenameMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterForClass_Rename", (Object)this.getElementText());
        }

        public void performSafeDelete() {
            try {
                FacesConfig faces = this.config.getFacesConfig();
                Converter[] converters = faces.getConverter();
                for (int i = 0; i < converters.length; ++i) {
                    if (!this.oldValue.equals(converters[i].getConverterClass())) continue;
                    faces.removeConverter(converters[i]);
                }
                this.config.write(faces);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }

        public void undoSafeDelete() {
            try {
                FacesConfig faces = this.config.getFacesConfig();
                faces.addConverter(this.converter);
                this.config.write(faces);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }

        public String getSafeDeleteMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ManagedBeanClass_SafeDelete", (Object[])new Object[]{this.getElementText()});
        }

        private void changeConverterForClass(String oldClass, String newClass) {
            try {
                FacesConfig faces = this.config.getFacesConfig();
                Converter[] converters = faces.getConverter();
                for (int i = 0; i < converters.length; ++i) {
                    if (!oldClass.equals(converters[i].getConverterForClass())) continue;
                    converters[i].setConverterForClass(newClass);
                }
                this.config.write(faces);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }

        public PositionBounds getClassDefinitionPosition() {
            PositionBounds position = null;
            BaseDocument document = JSFEditorUtilities.getBaseDocument(this.config);
            int[] offsets = JSFEditorUtilities.getConverterDefinition(document, this.converter.getConverterForClass());
            try {
                String text = document.getText(offsets);
                int offset = offsets[0] + text.indexOf(this.oldValue);
                position = this.createPosition(offset, offset + this.oldValue.length());
            }
            catch (BadLocationException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            return position;
        }

        public PositionBounds getElementDefinitionPosition() {
            PositionBounds position = null;
            BaseDocument document = JSFEditorUtilities.getBaseDocument(this.config);
            int[] offsets = JSFEditorUtilities.getConverterDefinition(document, this.converter.getConverterForClass());
            position = this.createPosition(offsets[0], offsets[1]);
            return position;
        }
    }

    public static class ConverterClassItem
    extends OccurrenceItem {
        private Converter converter;

        public ConverterClassItem(JSFConfigDataObject config, Converter converter, String newValue) {
            super(config, newValue, converter.getConverterClass());
            this.converter = converter;
        }

        protected String getXMLElementName() {
            return "converter-class";
        }

        public void performRename() {
            this.changeConverterClass(this.oldValue, this.newValue);
        }

        public void undoRename() {
            this.changeConverterClass(this.newValue, this.oldValue);
        }

        public String getWhereUsedMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterClass_WhereUsed", (Object)this.getElementText());
        }

        public String getRenameMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterClass_Rename", (Object)this.getElementText());
        }

        public void performSafeDelete() {
            try {
                FacesConfig faces = this.config.getFacesConfig();
                Converter[] converters = faces.getConverter();
                for (int i = 0; i < converters.length; ++i) {
                    if (!this.oldValue.equals(converters[i].getConverterClass())) continue;
                    faces.removeConverter(converters[i]);
                }
                this.config.write(faces);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }

        public void undoSafeDelete() {
            try {
                FacesConfig faces = this.config.getFacesConfig();
                faces.addConverter(this.converter);
                this.config.write(faces);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }

        public String getSafeDeleteMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterClass_SafeDelete", (Object[])new Object[]{this.getElementText()});
        }

        private void changeConverterClass(String oldClass, String newClass) {
            try {
                FacesConfig faces = this.config.getFacesConfig();
                Converter[] converters = faces.getConverter();
                for (int i = 0; i < converters.length; ++i) {
                    if (!oldClass.equals(converters[i].getConverterClass())) continue;
                    converters[i].setConverterClass(newClass);
                }
                this.config.write(faces);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }

        public PositionBounds getClassDefinitionPosition() {
            PositionBounds position = null;
            BaseDocument document = JSFEditorUtilities.getBaseDocument(this.config);
            int[] offsets = JSFEditorUtilities.getConverterDefinition(document, this.converter.getConverterForClass());
            try {
                String text = document.getText(offsets);
                int offset = offsets[0] + text.indexOf(this.oldValue);
                position = this.createPosition(offset, offset + this.oldValue.length());
            }
            catch (BadLocationException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            return position;
        }

        public PositionBounds getElementDefinitionPosition() {
            PositionBounds position = null;
            BaseDocument document = JSFEditorUtilities.getBaseDocument(this.config);
            int[] offsets = JSFEditorUtilities.getConverterDefinition(document, this.converter.getConverterForClass());
            position = this.createPosition(offsets[0], offsets[1]);
            return position;
        }
    }

    public static class ManagedBeanClassItem
    extends OccurrenceItem {
        private ManagedBean bean;

        public ManagedBeanClassItem(JSFConfigDataObject config, ManagedBean bean, String newValue) {
            super(config, newValue, bean.getManagedBeanClass());
            this.bean = bean;
        }

        protected String getXMLElementName() {
            return "managed-bean-class";
        }

        public void performRename() {
            this.changeBeanClass(this.newValue);
        }

        public void undoRename() {
            this.changeBeanClass(this.oldValue);
        }

        public String getWhereUsedMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ManagedBeanClass_WhereUsed", (Object[])new Object[]{this.bean.getManagedBeanName(), this.getElementText()});
        }

        public String getRenameMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ManagedBeanClass_Rename", (Object[])new Object[]{this.bean.getManagedBeanName(), this.getElementText()});
        }

        public void performSafeDelete() {
            try {
                FacesConfig faces = this.config.getFacesConfig();
                ManagedBean[] beans = faces.getManagedBean();
                for (int i = 0; i < beans.length; ++i) {
                    if (!this.bean.getManagedBeanName().equals(beans[i].getManagedBeanName())) continue;
                    faces.removeManagedBean(beans[i]);
                }
                this.config.write(faces);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }

        public void undoSafeDelete() {
            try {
                FacesConfig faces = this.config.getFacesConfig();
                faces.addManagedBean(this.bean);
                this.config.write(faces);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }

        public String getSafeDeleteMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ManagedBeanClass_SafeDelete", (Object[])new Object[]{this.bean.getManagedBeanName(), this.getElementText()});
        }

        private void changeBeanClass(String className) {
            try {
                FacesConfig faces = this.config.getFacesConfig();
                ManagedBean[] beans = faces.getManagedBean();
                for (int i = 0; i < beans.length; ++i) {
                    if (!this.bean.getManagedBeanName().equals(beans[i].getManagedBeanName())) continue;
                    beans[i].setManagedBeanClass(className);
                }
                this.config.write(faces);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }

        public PositionBounds getClassDefinitionPosition() {
            PositionBounds position = null;
            BaseDocument document = JSFEditorUtilities.getBaseDocument(this.config);
            int[] offsets = JSFEditorUtilities.getManagedBeanDefinition(document, this.bean.getManagedBeanName());
            try {
                String text = document.getText(offsets);
                int offset = offsets[0] + text.indexOf(this.oldValue);
                position = this.createPosition(offset, offset + this.oldValue.length());
            }
            catch (BadLocationException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            return position;
        }

        public PositionBounds getElementDefinitionPosition() {
            PositionBounds position = null;
            BaseDocument document = JSFEditorUtilities.getBaseDocument(this.config);
            int[] offsets = JSFEditorUtilities.getManagedBeanDefinition(document, this.bean.getManagedBeanName());
            position = this.createPosition(offsets[0], offsets[1]);
            return position;
        }
    }

    public static abstract class OccurrenceItem {
        protected JSFConfigDataObject config;
        protected String newValue;
        protected String oldValue;

        public OccurrenceItem(JSFConfigDataObject config, String newValue, String oldValue) {
            this.config = config;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        public JSFConfigDataObject getConfigDO() {
            return this.config;
        }

        public String getElementText() {
            StringBuffer sb = new StringBuffer();
            sb.append("<font color=\"#0000FF\">");
            sb.append("&lt;").append(this.getXMLElementName()).append("&gt;</font><b>");
            sb.append(this.oldValue).append("</b><font color=\"#0000FF\">&lt;/").append(this.getXMLElementName());
            sb.append("&gt;</font>");
            return sb.toString();
        }

        protected abstract String getXMLElementName();

        public abstract void performRename();

        public abstract void undoRename();

        public abstract String getRenameMessage();

        public abstract void performSafeDelete();

        public abstract void undoSafeDelete();

        public abstract String getSafeDeleteMessage();

        public abstract String getWhereUsedMessage();

        protected PositionBounds createPosition(int startOffset, int endOffset) {
            CloneableEditorSupport editor = JSFEditorUtilities.findCloneableEditorSupport((DataObject)this.config);
            if (editor != null) {
                PositionRef start = editor.createPositionRef(startOffset, Position.Bias.Forward);
                PositionRef end = editor.createPositionRef(endOffset, Position.Bias.Backward);
                return new PositionBounds(start, end);
            }
            return null;
        }

        public PositionBounds getClassDefinitionPosition() {
            return this.createPosition(0, 0);
        }

        public PositionBounds getElementDefinitionPosition() {
            return this.createPosition(0, 0);
        }
    }
}

