/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.config.model.FacesConfig;
import org.netbeans.modules.web.jsf.config.model.ManagedBean;
import org.netbeans.modules.web.jsf.config.model.NavigationCase;
import org.netbeans.modules.web.jsf.config.model.NavigationRule;
import org.netbeans.modules.web.jsf.dialogs.AddDialog;
import org.netbeans.modules.web.jsf.dialogs.AddManagedBeanDialog;
import org.netbeans.modules.web.jsf.dialogs.AddNavigationCaseDialog;
import org.netbeans.modules.web.jsf.dialogs.AddNavigationRuleDialog;
import org.netbeans.modules.web.jsf.editor.JSFEditorUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class JSFPopupAction
extends SystemAction
implements Presenter.Popup {
    private ArrayList actions = null;
    private static String END_LINE = System.getProperty("line.separator");
    protected static final int MANAGED_BEAN_TYPE = 1;
    protected static final int NAVIGATION_RULE_TYPE = 2;

    public String getName() {
        return NbBundle.getMessage(JSFPopupAction.class, (String)"org-netbeans-modules-web-jsf-editor-JSFPopupAction.instance");
    }

    public void actionPerformed(ActionEvent ev) {
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public JMenuItem getPopupPresenter() {
        return new SubMenu(this.getName());
    }

    public static class AddNavigationCaseAction
    extends BaseAction {
        public AddNavigationCaseAction() {
            super(NbBundle.getBundle(JSFPopupAction.class).getString("add-navigation-case-action"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            BaseDocument doc = (BaseDocument)target.getDocument();
            JSFConfigDataObject data = (JSFConfigDataObject)NbEditorUtilities.getDataObject((Document)doc);
            AddNavigationCaseDialog dialogPanel = new AddNavigationCaseDialog(data, JSFEditorUtilities.getNavigationRule(doc, target.getCaretPosition()));
            AddDialog dialog = new AddDialog(dialogPanel, NbBundle.getMessage(JSFPopupAction.class, (String)"TTL_AddNavigationCase"), new HelpCtx(AddNavigationCaseDialog.class));
            dialog.disableAdd();
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            if (dialog.getValue().equals(AddDialog.ADD_OPTION)) {
                try {
                    FacesConfig config = data.getFacesConfig();
                    if (config == null) {
                        return;
                    }
                    boolean newRule = false;
                    NavigationRule rule = JSFConfigUtilities.findNavigationRule(config, dialogPanel.getRule());
                    if (rule == null) {
                        rule = config.newNavigationRule();
                        rule.setFromViewId(dialogPanel.getRule());
                        config.addNavigationRule(rule);
                        newRule = true;
                    }
                    NavigationCase nCase = rule.newNavigationCase();
                    if (dialogPanel.getFromAction() != null && !dialogPanel.getFromAction().equals("")) {
                        nCase.setFromAction(dialogPanel.getFromAction());
                    }
                    if (dialogPanel.getFromOutcome() != null && !dialogPanel.getFromOutcome().equals("")) {
                        nCase.setFromOutcome(dialogPanel.getFromOutcome());
                    }
                    nCase.setRedirected(dialogPanel.isRedirect());
                    nCase.setToViewId(dialogPanel.getToView());
                    if (dialogPanel.getDescription() != null && !dialogPanel.getDescription().equals("")) {
                        nCase.setDescription(new String[]{END_LINE + dialogPanel.getDescription() + END_LINE});
                    }
                    rule.addNavigationCase(nCase);
                    if (newRule) {
                        target.setCaretPosition(JSFEditorUtilities.writeBean(doc, (BaseBean)rule, "navigation-rule"));
                    } else {
                        target.setCaretPosition(JSFEditorUtilities.writeCaseIntoRule(doc, rule.getFromViewId(), nCase));
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
    }

    public static class AddNavigationRuleAction
    extends BaseAction {
        public AddNavigationRuleAction() {
            super(NbBundle.getBundle(JSFPopupAction.class).getString("add-navigation-rule-action"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            BaseDocument doc = (BaseDocument)target.getDocument();
            JSFConfigDataObject data = (JSFConfigDataObject)NbEditorUtilities.getDataObject((Document)doc);
            AddNavigationRuleDialog dialogPanel = new AddNavigationRuleDialog(data);
            AddDialog dialog = new AddDialog(dialogPanel, NbBundle.getMessage(JSFPopupAction.class, (String)"TTL_AddNavigationRule"), new HelpCtx(AddNavigationRuleDialog.class));
            dialog.disableAdd();
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            if (dialog.getValue().equals(AddDialog.ADD_OPTION)) {
                try {
                    FacesConfig config = data.getFacesConfig();
                    if (config == null) {
                        return;
                    }
                    NavigationRule rule = config.newNavigationRule();
                    rule.setDescription(new String[]{END_LINE + dialogPanel.getDescription() + END_LINE});
                    rule.setFromViewId(dialogPanel.getFromView());
                    config.addNavigationRule(rule);
                    target.setCaretPosition(JSFEditorUtilities.writeBean(doc, (BaseBean)rule, "navigation-rule"));
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
    }

    public static class AddManagedBeanAction
    extends BaseAction {
        public AddManagedBeanAction() {
            super(NbBundle.getBundle(JSFPopupAction.class).getString("add-managed-bean-action"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            BaseDocument doc = (BaseDocument)target.getDocument();
            JSFConfigDataObject data = (JSFConfigDataObject)NbEditorUtilities.getDataObject((Document)doc);
            AddManagedBeanDialog dialogPanel = new AddManagedBeanDialog(data);
            AddDialog dialog = new AddDialog(dialogPanel, NbBundle.getMessage(JSFPopupAction.class, (String)"TTL_AddManagedBean"), new HelpCtx(AddManagedBeanDialog.class));
            dialog.disableAdd();
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            if (dialog.getValue().equals(AddDialog.ADD_OPTION)) {
                try {
                    FacesConfig config = data.getFacesConfig();
                    if (config == null) {
                        return;
                    }
                    ManagedBean bean = config.newManagedBean();
                    bean.setManagedBeanName(dialogPanel.getName());
                    bean.setManagedBeanClass(dialogPanel.getBeanClass());
                    bean.setManagedBeanScope(dialogPanel.getScope());
                    if (dialogPanel.getDescription() != null && !dialogPanel.getDescription().equals("")) {
                        bean.setDescription(new String[]{END_LINE + dialogPanel.getDescription() + END_LINE});
                    }
                    config.addManagedBean(bean);
                    target.setCaretPosition(JSFEditorUtilities.writeBean(doc, (BaseBean)bean, "managed-bean"));
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
    }

    public class SubMenu
    extends JMenu {
        public SubMenu(String s) {
            super(s);
        }

        public JPopupMenu getPopupMenu() {
            JPopupMenu pm = super.getPopupMenu();
            pm.removeAll();
            pm.add((Action)((Object)new AddNavigationRuleAction()));
            pm.add((Action)((Object)new AddNavigationCaseAction()));
            pm.add(new JSeparator());
            pm.add((Action)((Object)new AddManagedBeanAction()));
            pm.pack();
            return pm;
        }
    }
}

