/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.jaxrpc;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class WrapperClientBeanInfoWriter
extends PrintWriter {
    private String className;
    private String superClassName;
    private String packageName;
    private Set constructorStatements = new HashSet();
    public static String WEBSERVICE_ICON_FILENAME = "webservice.png";
    int indent = 0;

    public WrapperClientBeanInfoWriter(Writer writer) {
        super(writer);
        this.setSuperClass("SimpleBeanInfo");
    }

    public void setPackage(String pkgName) {
        this.packageName = pkgName;
    }

    public void setName(String name) {
        this.className = name;
    }

    public void setSuperClass(String superClass) {
        this.superClassName = superClass;
    }

    public void writeBeanInfo() {
        this.println("package " + this.packageName + ";");
        this.println();
        this.println("import java.awt.Image;");
        this.println("import java.beans.BeanDescriptor;");
        this.println("import java.beans.PropertyDescriptor;");
        this.println("import java.beans.SimpleBeanInfo;");
        this.println();
        this.print("public class " + this.className + "BeanInfo");
        if (this.superClassName != null) {
            this.print(" extends " + this.superClassName + " ");
        }
        this.println(" {");
        this.println();
        this.println("  private Class beanClass = " + this.className + ".class;");
        this.println("  private String iconFileName = \"" + WEBSERVICE_ICON_FILENAME + "\";");
        this.println("  private BeanDescriptor beanDescriptor = null;");
        this.println("  private PropertyDescriptor[] propDescriptors = null;");
        this.println();
        this.println("  public BeanDescriptor getBeanDescriptor() {");
        this.println("      if (beanDescriptor == null) {");
        this.println("           beanDescriptor = new BeanDescriptor(beanClass);");
        this.println("           beanDescriptor.setValue(\"trayComponent\", Boolean.TRUE);");
        this.println("       }");
        this.println("      return beanDescriptor;");
        this.println("  }");
        this.println();
        this.println("  public PropertyDescriptor[] getPropertyDescriptors() {");
        this.println("      if (propDescriptors == null) {");
        this.println("         propDescriptors = new PropertyDescriptor[] {");
        this.println("         ");
        this.println("          };");
        this.println("      }");
        this.println("      return propDescriptors;");
        this.println("  }");
        this.println();
        this.println("  public Image getIcon(int iconKind) {");
        this.println("      return loadImage(iconFileName);");
        this.println("  }");
        this.println("}");
    }

    public static void main(String[] args) {
        try {
            WrapperClientBeanInfoWriter beanWriter = new WrapperClientBeanInfoWriter(new OutputStreamWriter(System.out));
            beanWriter.setPackage("untitled");
            beanWriter.setName("WebserviceProxyClient");
            beanWriter.writeBeanInfo();
            beanWriter.flush();
            beanWriter.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

