/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchSelector;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.awt.Mnemonics;

class SearchCriteriaPanel
extends JPanel {
    private final File[] roots;
    private JButton bBrowseFrom;
    private JButton bBrowseTo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JTextField tfCommitMessage;
    private JTextField tfFrom;
    private JTextField tfTo;
    private JTextField tfUsername;

    public SearchCriteriaPanel(File[] roots) {
        this.roots = roots;
        this.initComponents();
    }

    public String getFrom() {
        String s = this.tfFrom.getText().trim();
        return s.length() > 0 ? s : null;
    }

    public String getTo() {
        String s = this.tfTo.getText().trim();
        return s.length() > 0 ? s : null;
    }

    public String getCommitMessage() {
        String s = this.tfCommitMessage.getText().trim();
        return s.length() > 0 ? s : null;
    }

    public String getUsername() {
        String s = this.tfUsername.getText().trim();
        return s.length() > 0 ? s : null;
    }

    public void setFrom(String from) {
        if (from == null) {
            from = "";
        }
        this.tfFrom.setText(from);
    }

    public void setTo(String to) {
        if (to == null) {
            to = "";
        }
        this.tfTo.setText(to);
    }

    public void setCommitMessage(String message) {
        if (message == null) {
            message = "";
        }
        this.tfCommitMessage.setText(message);
    }

    public void setUsername(String username) {
        if (username == null) {
            username = "";
        }
        this.tfUsername.setText(username);
    }

    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchCriteriaPanel.this.tfCommitMessage.requestFocusInWindow();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.tfCommitMessage = new JTextField();
        this.jLabel2 = new JLabel();
        this.tfUsername = new JTextField();
        this.jLabel3 = new JLabel();
        this.tfFrom = new JTextField();
        this.jLabel5 = new JLabel();
        this.bBrowseFrom = new JButton();
        this.jLabel4 = new JLabel();
        this.tfTo = new JTextField();
        this.jLabel6 = new JLabel();
        this.bBrowseTo = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 12, 0, 11));
        this.jLabel1.setLabelFor(this.tfCommitMessage);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_UseCommitMessage"));
        this.jLabel1.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_CommitMessage"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.tfCommitMessage.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.tfCommitMessage, gridBagConstraints);
        this.jLabel2.setLabelFor(this.tfUsername);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_UseUsername"));
        this.jLabel2.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_Username"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.tfUsername.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.tfUsername, gridBagConstraints);
        this.jLabel3.setLabelFor(this.tfFrom);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_UseFrom"));
        this.jLabel3.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_From"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.tfFrom.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.tfFrom, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_FromToHint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 4);
        this.add((Component)this.jLabel5, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowseFrom, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_BrowseFrom"));
        this.bBrowseFrom.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_BrowseFrom"));
        this.bBrowseFrom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchCriteriaPanel.this.onFromBrowse(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.bBrowseFrom, gridBagConstraints);
        this.jLabel4.setLabelFor(this.tfTo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_UseTo"));
        this.jLabel4.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_To"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.tfTo.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.tfTo, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_FromToHint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 0, 4);
        this.add((Component)this.jLabel6, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowseTo, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_BrowseTo"));
        this.bBrowseTo.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_BrowseTo"));
        this.bBrowseTo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchCriteriaPanel.this.onToBrowse(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.bBrowseTo, gridBagConstraints);
    }

    private void onToBrowse(ActionEvent evt) {
        this.onBrowse(this.tfTo);
    }

    private void onFromBrowse(ActionEvent evt) {
        this.onBrowse(this.tfFrom);
    }

    private void onBrowse(JTextField destination) {
        for (int i = 0; i < this.roots.length; ++i) {
            try {
                CVSRoot.parse((String)Utils.getCVSRootFor(this.roots[i]));
                BranchSelector selector = new BranchSelector();
                String tag = selector.selectTag(this.roots[i], null);
                if (tag != null) {
                    destination.setText(tag);
                }
                return;
            }
            catch (IOException iOException) {
                continue;
            }
        }
    }
}

