/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class DiffProjectsAction
extends SystemAction {
    public DiffProjectsAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage((Class)DiffProjectsAction.class, (String)"CTL_MenuItem_DiffProjects");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(DiffProjectsAction.class);
    }

    public boolean isEnabled() {
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; ++i) {
            Project project = projects[i];
            if (!Utils.isVersionedProject(project)) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent ev) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                DiffProjectsAction.this.async();
            }
        });
    }

    private void async() {
        final ExecutorGroup group = new ExecutorGroup(NbBundle.getMessage((Class)DiffProjectsAction.class, (String)"CTL_MenuItem_DiffProjectsRunning"));
        group.progress(NbBundle.getMessage((Class)DiffProjectsAction.class, (String)"BK2001"));
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        final Context ctx = Utils.getProjectsContext(projects);
        final ResourceBundle loc = NbBundle.getBundle((Class)DiffProjectsAction.class);
        if (ctx.getFiles().length == 0) {
            group.executed();
            JOptionPane.showMessageDialog(null, loc.getString("MSG_NoProjectFiles_Prompt"), loc.getString("MSG_NoProjectFiles_Title"), 1);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String title = loc.getString("CTL_DialogTitle_DiffProjects");
                DiffExecutor exec = new DiffExecutor(ctx, title);
                exec.showLocalDiff(group);
            }
        });
    }
}

