/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class ThreadsTreeModel
implements TreeModel {
    private static boolean verbose = System.getProperty("netbeans.debugger.viewrefresh") != null && System.getProperty("netbeans.debugger.viewrefresh").indexOf(116) >= 0;
    private JPDADebuggerImpl debugger;
    private Map childrenCache = new WeakHashMap();
    private Listener listener;
    private Collection listeners = new HashSet();

    public ThreadsTreeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class));
    }

    public Object getRoot() {
        return "Root";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object o, int from, int to) throws UnknownTypeException {
        Object[] ch;
        ChildrenTree cht;
        Map map = this.childrenCache;
        synchronized (map) {
            cht = (ChildrenTree)this.childrenCache.get(o);
            ch = cht != null ? cht.getChildren() : null;
        }
        if (ch == null) {
            ch = this.computeChildren(o);
            if (ch == null) {
                throw new UnknownTypeException(o);
            }
            map = this.childrenCache;
            synchronized (map) {
                cht = new ChildrenTree(o);
                cht.setChildren(ch);
                this.childrenCache.put(o, cht);
            }
        }
        int l = ch.length;
        from = Math.min(l, from);
        to = Math.min(l, to);
        if (from == 0 && to == l) {
            return ch;
        }
        Object[] ch1 = new Object[to - from];
        System.arraycopy(ch, from, ch1, 0, to - from);
        ch = ch1;
        return ch;
    }

    private Object[] computeChildren(Object node) {
        if (node.equals("Root")) {
            return this.debugger.getTopLevelThreadGroups();
        }
        if (node instanceof JPDAThreadGroup) {
            JPDAThreadGroup tg = (JPDAThreadGroup)node;
            JPDAThreadGroup[] tgs = tg.getThreadGroups();
            JPDAThread[] ts = tg.getThreads();
            int n = tgs.length + ts.length;
            Object[] ch = new Object[n];
            System.arraycopy(tgs, 0, ch, 0, tgs.length);
            System.arraycopy(ts, 0, ch, tgs.length, ts.length);
            return ch;
        }
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recomputeChildren() {
        Map map = this.childrenCache;
        synchronized (map) {
            this.recomputeChildren(this.getRoot());
        }
    }

    private void recomputeChildren(Object node) {
        ChildrenTree cht = (ChildrenTree)this.childrenCache.get(node);
        if (cht != null) {
            Set keys = this.childrenCache.keySet();
            Object[] oldCh = cht.getChildren();
            Object[] newCh = this.computeChildren(node);
            cht.setChildren(newCh);
            for (int i = 0; i < newCh.length; ++i) {
                if (!keys.contains(newCh[i])) continue;
                this.recomputeChildren(newCh[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildrenCount(Object node) throws UnknownTypeException {
        Object[] ch;
        ChildrenTree cht;
        Map map = this.childrenCache;
        synchronized (map) {
            cht = (ChildrenTree)this.childrenCache.get(node);
            ch = cht != null ? cht.getChildren() : null;
        }
        if (ch == null) {
            ch = this.computeChildren(node);
            if (ch == null) {
                throw new UnknownTypeException(node);
            }
            map = this.childrenCache;
            synchronized (map) {
                cht = new ChildrenTree(node);
                cht.setChildren(ch);
                this.childrenCache.put(node, cht);
            }
        }
        return ch.length;
    }

    public boolean isLeaf(Object o) throws UnknownTypeException {
        if (o instanceof JPDAThread) {
            return true;
        }
        if (o instanceof JPDAThreadGroup) {
            return false;
        }
        if (o == "Root") {
            return false;
        }
        throw new UnknownTypeException(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(l);
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(l);
            if (this.listeners.size() == 0) {
                this.listener.destroy();
                this.listener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged() {
        Object[] ls;
        this.recomputeChildren();
        Collection collection = this.listeners;
        synchronized (collection) {
            ls = this.listeners.toArray();
        }
        ModelEvent.TreeChanged ev = new ModelEvent.TreeChanged((Object)this);
        for (int i = 0; i < ls.length; ++i) {
            ((ModelListener)ls[i]).modelChanged((ModelEvent)ev);
        }
    }

    private static class ChildrenTree {
        private Object node;
        private Object[] ch;

        public ChildrenTree(Object node) {
            this.node = node;
        }

        public void setChildren(Object[] ch) {
            this.ch = ch;
        }

        public Object[] getChildren() {
            return this.ch;
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private JPDADebugger debugger;
        private WeakReference model;
        private RequestProcessor.Task task;

        public Listener(ThreadsTreeModel tm, JPDADebugger debugger) {
            this.debugger = debugger;
            this.model = new WeakReference<ThreadsTreeModel>(tm);
            debugger.addPropertyChangeListener((PropertyChangeListener)this);
            if (debugger.getState() == 2) {
                this.task = this.createTask();
                this.task.schedule(500);
            }
        }

        private ThreadsTreeModel getModel() {
            ThreadsTreeModel tm = (ThreadsTreeModel)this.model.get();
            if (tm == null) {
                this.destroy();
            }
            return tm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy() {
            this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
            Listener listener = this;
            synchronized (listener) {
                if (this.task != null) {
                    this.task.cancel();
                    if (verbose) {
                        System.out.println("TTM cancel old task " + this.task);
                    }
                    this.task = null;
                }
            }
        }

        private RequestProcessor.Task createTask() {
            RequestProcessor.Task task = new RequestProcessor("Threads Refresh", 1).create((Runnable)new RefreshTree());
            if (verbose) {
                System.out.println("TTM  create task " + task);
            }
            return task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == "state") {
                if (this.debugger.getState() == 3) {
                    ThreadsTreeModel tm = this.getModel();
                    if (tm == null) {
                        return;
                    }
                    Listener listener = this;
                    synchronized (listener) {
                        if (this.task == null) {
                            this.task = this.createTask();
                        }
                    }
                    this.task.schedule(500);
                    return;
                }
            }
            if (e.getPropertyName() != "state") return;
            if (this.debugger.getState() != 2) return;
            ThreadsTreeModel tm = this.getModel();
            if (tm == null) {
                return;
            }
            Listener listener = this;
            synchronized (listener) {
                if (this.task == null) {
                    this.task = this.createTask();
                }
            }
            this.task.schedule(2000);
        }

        private class RefreshTree
        implements Runnable {
            public void run() {
                ThreadsTreeModel tm = Listener.this.getModel();
                if (tm == null) {
                    return;
                }
                if (verbose) {
                    System.out.println("TTM do R task " + Listener.this.task);
                }
                tm.fireTreeChanged();
                int n = Listener.this.debugger.getState();
                Listener.this.debugger;
                if (n == 2) {
                    Listener.this.task.schedule(2000);
                }
            }
        }
    }
}

