/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;

class Local
extends AbstractVariable
implements org.netbeans.api.debugger.jpda.LocalVariable {
    protected LocalVariable local;
    private JPDAThread thread;
    private int depth;
    private String className;

    Local(JPDADebuggerImpl debugger, Value value, String className, LocalVariable local, CallStackFrameImpl frame) {
        super(debugger, value, local.name() + ((Object)local).hashCode() + (value instanceof ObjectReference ? "^" : ""));
        this.local = local;
        if (frame != null) {
            this.thread = frame.getThread();
            this.depth = frame.getFrameDepth();
        }
        this.className = className;
    }

    Local(JPDADebuggerImpl debugger, Value value, String className, LocalVariable local, String genericSignature, CallStackFrameImpl frame) {
        super(debugger, value, genericSignature, local.name() + ((Object)local).hashCode() + (value instanceof ObjectReference ? "^" : ""));
        this.local = local;
        if (frame != null) {
            this.thread = frame.getThread();
            this.depth = frame.getFrameDepth();
        }
        this.className = className;
    }

    public String getName() {
        return this.local.name();
    }

    public String getClassName() {
        return this.className;
    }

    protected final void setClassName(String className) {
        this.className = className;
    }

    public String getDeclaredType() {
        return this.local.typeName();
    }

    protected final void setValue(Value value) throws InvalidExpressionException {
        try {
            StackFrame sf = ((CallStackFrameImpl)this.thread.getCallStack(this.depth, this.depth + 1)[0]).getStackFrame();
            sf.setValue(this.local, value);
        }
        catch (AbsentInformationException aiex) {
            throw new InvalidExpressionException((Throwable)aiex);
        }
        catch (InvalidTypeException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
        catch (ClassNotLoadedException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
    }

    final void setFrame(CallStackFrameImpl frame) {
        this.thread = frame.getThread();
        this.depth = frame.getFrameDepth();
    }

    public String toString() {
        return "LocalVariable " + this.local.name();
    }
}

