/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;

public class ThreadBreakpointImpl
extends BreakpointImpl
implements Executor {
    private ThreadBreakpoint breakpoint;

    public ThreadBreakpointImpl(ThreadBreakpoint presenter, JPDADebuggerImpl debugger, Session session) {
        super((JPDABreakpoint)presenter, null, debugger, session);
        this.breakpoint = presenter;
        this.set();
    }

    protected void setRequests() {
        try {
            VirtualMachine vm;
            if ((this.breakpoint.getBreakpointType() & 1) != 0) {
                ThreadStartRequest tsr = this.getEventRequestManager().createThreadStartRequest();
                this.addEventRequest(tsr);
            }
            if ((this.breakpoint.getBreakpointType() & 2) != 0 && (vm = this.getVirtualMachine()) != null) {
                ThreadDeathRequest tdr = vm.eventRequestManager().createThreadDeathRequest();
                this.addEventRequest(tdr);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public boolean exec(Event event) {
        ThreadReference thread = null;
        if (event instanceof ThreadStartEvent) {
            thread = ((ThreadStartEvent)event).thread();
        } else if (event instanceof ThreadDeathEvent) {
            thread = ((ThreadDeathEvent)event).thread();
        }
        return this.perform(null, thread, null, thread);
    }
}

