/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.InvalidRequestStateException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AbstractDICookie;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDAStepImpl;
import org.netbeans.modules.debugger.jpda.JSR45DebuggerEngineProvider;
import org.netbeans.modules.debugger.jpda.JavaEngineProvider;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsEngineListener;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.EvaluationException;
import org.netbeans.modules.debugger.jpda.expr.Evaluator;
import org.netbeans.modules.debugger.jpda.expr.Expression;
import org.netbeans.modules.debugger.jpda.expr.ParseException;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.LocalsTreeModel;
import org.netbeans.modules.debugger.jpda.models.ObjectTranslation;
import org.netbeans.modules.debugger.jpda.util.JPDAUtils;
import org.netbeans.modules.debugger.jpda.util.Operator;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.debugger.DelegatingSessionProvider;
import org.netbeans.spi.viewmodel.TreeModel;
import org.openide.ErrorManager;

public class JPDADebuggerImpl
extends JPDADebugger {
    private static final boolean startVerbose = System.getProperty("netbeans.debugger.start") != null;
    private VirtualMachine virtualMachine = null;
    private Exception exception;
    private Thread startingThread;
    private int state = 0;
    private Operator operator;
    private PropertyChangeSupport pcs;
    private JPDAThreadImpl currentThread;
    private CallStackFrame currentCallStackFrame;
    private int suspend = 2;
    public final Object LOCK = new Object();
    private final Object LOCK2 = new Object();
    private boolean starting;
    private JavaEngineProvider javaEngineProvider;
    private Set languages;
    private String lastStratumn;
    private ContextProvider lookupProvider;
    private ObjectTranslation threadsTranslation;
    private ObjectTranslation localsTranslation;
    private StackFrame altCSF = null;
    private Boolean canBeModified;
    private Object canBeModifiedLock = new Object();
    private SmartSteppingFilter smartSteppingFilter;
    private InvalidExpressionException methodCallsUnsupportedExc;
    private static final Pattern jvmVersionPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(_\\d+)?(-\\w+)?");
    private static Method tcGenericSignatureMethod;
    private static Method lvGenericSignatureMethod;
    private SourcePath engineContext;
    private LocalsTreeModel localsTreeModel;
    private Set jsr45EngineProviders;

    public JPDADebuggerImpl(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
        this.pcs = new PropertyChangeSupport((Object)this);
        List l = lookupProvider.lookup(null, DebuggerEngineProvider.class);
        int k = l.size();
        for (int i = 0; i < k; ++i) {
            if (!(l.get(i) instanceof JavaEngineProvider)) continue;
            this.javaEngineProvider = (JavaEngineProvider)((Object)l.get(i));
        }
        if (this.javaEngineProvider == null) {
            throw new IllegalArgumentException("JavaEngineProvider have to be used to start JPDADebugger!");
        }
        this.languages = new HashSet();
        this.languages.add("Java");
        this.threadsTranslation = ObjectTranslation.createThreadTranslation(this);
        this.localsTranslation = ObjectTranslation.createLocalsTranslation(this);
    }

    public int getState() {
        return this.state;
    }

    public int getSuspend() {
        return this.suspend;
    }

    public void setSuspend(int s) {
        if (s == this.suspend) {
            return;
        }
        int old = this.suspend;
        this.suspend = s;
        this.firePropertyChange("suspend", new Integer(old), new Integer(s));
    }

    public JPDAThread getCurrentThread() {
        return this.currentThread;
    }

    public synchronized CallStackFrame getCurrentCallStackFrame() {
        if (this.currentCallStackFrame != null) {
            try {
                if (!this.currentCallStackFrame.getThread().isSuspended()) {
                    this.currentCallStackFrame = null;
                }
            }
            catch (InvalidStackFrameException isfex) {
                this.currentCallStackFrame = null;
            }
        }
        if (this.currentCallStackFrame == null && this.currentThread != null) {
            try {
                this.currentCallStackFrame = this.currentThread.getCallStack()[0];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.currentCallStackFrame;
    }

    public Variable evaluate(String expression) throws InvalidExpressionException {
        Value v = this.evaluateIn(expression);
        return this.getLocalsTreeModel().getVariable(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitRunning() throws DebuggerStartException {
        Object object = this.LOCK2;
        synchronized (object) {
            if (this.getState() == 4) {
                if (this.exception != null) {
                    throw new DebuggerStartException((Throwable)this.exception);
                }
                return;
            }
            if (!this.starting && this.state != 1) {
                return;
            }
            try {
                this.LOCK2.wait();
            }
            catch (InterruptedException e) {
                throw new DebuggerStartException((Throwable)e);
            }
            if (this.exception != null) {
                throw new DebuggerStartException((Throwable)this.exception);
            }
            return;
        }
    }

    public boolean canPopFrames() {
        VirtualMachine vm = this.getVirtualMachine();
        if (vm == null) {
            return false;
        }
        return vm.canPopFrames();
    }

    public boolean canFixClasses() {
        VirtualMachine vm = this.getVirtualMachine();
        if (vm == null) {
            return false;
        }
        return vm.canRedefineClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixClasses(Map classes) {
        Object object = this.LOCK;
        synchronized (object) {
            HashMap map = new HashMap();
            Iterator i = classes.keySet().iterator();
            while (i.hasNext()) {
                String className = (String)i.next();
                List<ReferenceType> classRefs = this.getVirtualMachine().classesByName(className);
                int jj = classRefs.size();
                for (int j = 0; j < jj; ++j) {
                    map.put(classRefs.get(j), classes.get(className));
                }
            }
            this.getVirtualMachine().redefineClasses(map);
            Session s = (Session)this.lookupProvider.lookupFirst(null, Session.class);
            DebuggerEngine de = s.getEngineForLanguage("Java");
            BreakpointsEngineListener bel = (BreakpointsEngineListener)de.lookupFirst(null, LazyActionsManagerListener.class);
            bel.fixBreakpointImpls();
            JPDAThread t = this.getCurrentThread();
            if (t != null && t.isSuspended()) {
                CallStackFrame frame = this.getCurrentCallStackFrame();
                if (t.getStackDepth() < 2 && frame.isObsolete()) {
                    return;
                }
                try {
                    if (!frame.equals(t.getCallStack(0, 1)[0])) {
                        return;
                    }
                }
                catch (AbsentInformationException ex) {
                    return;
                }
                if (frame.isObsolete() && ((CallStackFrameImpl)frame).canPop()) {
                    frame.popFrame();
                    this.setState(2);
                    this.updateCurrentCallStackFrame(t);
                    this.setState(3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canBeModified() {
        VirtualMachine vm = this.getVirtualMachine();
        if (vm == null) {
            return false;
        }
        Object object = this.canBeModifiedLock;
        synchronized (object) {
            if (this.canBeModified == null) {
                try {
                    Method canBeModifiedMethod = VirtualMachine.class.getMethod("canBeModified", new Class[0]);
                    Object modifiable = canBeModifiedMethod.invoke((Object)vm, new Object[0]);
                    this.canBeModified = (Boolean)modifiable;
                }
                catch (NoSuchMethodException nsmex) {
                    this.canBeModified = Boolean.TRUE;
                }
                catch (IllegalAccessException iaex) {
                    this.canBeModified = Boolean.TRUE;
                }
                catch (InvocationTargetException itex) {
                    this.canBeModified = Boolean.TRUE;
                }
            }
            return this.canBeModified;
        }
    }

    public SmartSteppingFilter getSmartSteppingFilter() {
        if (this.smartSteppingFilter == null) {
            this.smartSteppingFilter = (SmartSteppingFilter)this.lookupProvider.lookupFirst(null, SmartSteppingFilter.class);
            this.smartSteppingFilter.addExclusionPatterns((Set)Properties.getDefault().getProperties("debugger").getProperties("sources").getProperties("class_filters").getCollection("enabled", (Collection)Collections.EMPTY_SET));
        }
        return this.smartSteppingFilter;
    }

    public void fireBreakpointEvent(JPDABreakpoint breakpoint, JPDABreakpointEvent event) {
        super.fireBreakpointEvent(breakpoint, event);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(propertyName, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popFrames(ThreadReference thread, StackFrame frame) {
        Object object = this.LOCK;
        synchronized (object) {
            try {
                thread.popFrames(frame);
                this.setState(2);
                this.updateCurrentCallStackFrame(this.getThread(thread));
                this.setState(3);
            }
            catch (IncompatibleThreadStateException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(Exception e) {
        Object object = this.LOCK2;
        synchronized (object) {
            this.exception = e;
            this.starting = false;
            this.LOCK2.notify();
        }
    }

    public void setCurrentThread(JPDAThread thread) {
        JPDAThreadImpl oldT = this.currentThread;
        this.currentThread = (JPDAThreadImpl)thread;
        if (thread != oldT) {
            this.pcs.firePropertyChange("currentThread", oldT, this.currentThread);
        }
        this.updateCurrentCallStackFrame(thread);
    }

    public void setCurrentCallStackFrame(CallStackFrame callStackFrame) {
        CallStackFrame old = this.setCurrentCallStackFrameNoFire(callStackFrame);
        if (old == callStackFrame) {
            return;
        }
        this.pcs.firePropertyChange("currentCallStackFrame", old, callStackFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallStackFrame setCurrentCallStackFrameNoFire(CallStackFrame callStackFrame) {
        CallStackFrame old;
        JPDADebuggerImpl jPDADebuggerImpl = this;
        synchronized (jPDADebuggerImpl) {
            if (callStackFrame == this.currentCallStackFrame) {
                return callStackFrame;
            }
            old = this.currentCallStackFrame;
            this.currentCallStackFrame = callStackFrame;
        }
        return old;
    }

    public Value evaluateIn(String expression) throws InvalidExpressionException {
        Expression expr = null;
        try {
            expr = Expression.parse(expression, "1.5.0");
            return this.evaluateIn(expr);
        }
        catch (ParseException e) {
            InvalidExpressionException iee = new InvalidExpressionException(e.getMessage());
            iee.initCause((Throwable)e);
            throw iee;
        }
    }

    public void setAltCSF(StackFrame sf) {
        this.altCSF = sf;
    }

    public StackFrame getAltCSF() {
        return this.altCSF;
    }

    public Value evaluateIn(Expression expression) throws InvalidExpressionException {
        Object object = this.LOCK;
        synchronized (object) {
            CallStackFrameImpl csf = (CallStackFrameImpl)this.getCurrentCallStackFrame();
            if (csf != null) {
                JPDAThread frameThread = csf.getThread();
                try {
                    Value value = this.evaluateIn(expression, csf.getStackFrame());
                    try {
                        csf.getThread();
                    }
                    catch (InvalidStackFrameException isfex) {
                        int depth = csf.getFrameDepth();
                        try {
                            CallStackFrame csf2 = frameThread.getCallStack(depth, depth + 1)[0];
                            this.setCurrentCallStackFrameNoFire(csf2);
                        }
                        catch (AbsentInformationException aiex) {
                            this.setCurrentCallStackFrame(null);
                        }
                    }
                    return value;
                }
                catch (VMDisconnectedException e) {
                    return null;
                }
            }
            if (this.altCSF != null) {
                try {
                    if (this.altCSF.thread().isSuspended()) {
                        return this.evaluateIn(expression, this.altCSF);
                    }
                    this.altCSF = null;
                }
                catch (InvalidStackFrameException isfex) {
                    this.altCSF = null;
                }
                catch (VMDisconnectedException e) {
                    return null;
                }
            }
            throw new InvalidExpressionException("No current context (stack frame)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evaluateIn(Expression expression, final StackFrame frame) throws InvalidExpressionException {
        Object object = this.LOCK;
        synchronized (object) {
            Value value;
            JPDAThreadImpl[] resumedThread;
            List[] disabledBreakpoints;
            block16: {
                if (frame == null) {
                    throw new InvalidExpressionException("No current context");
                }
                ArrayList<String> imports = new ArrayList<String>();
                ArrayList staticImports = new ArrayList();
                imports.add("java.lang.*");
                imports.addAll(Arrays.asList(EditorContextBridge.getImports(this.getEngineContext().getURL(frame, "Java"))));
                disabledBreakpoints = new List[]{null};
                resumedThread = new JPDAThreadImpl[]{null};
                EvaluationContext context = new EvaluationContext(frame, imports, staticImports, this.methodCallsUnsupportedExc == null, new Runnable(){

                    public void run() {
                        if (disabledBreakpoints[0] == null) {
                            disabledBreakpoints[0] = JPDADebuggerImpl.this.disableAllBreakpoints();
                            ThreadReference tr = frame.thread();
                            resumedThread[0] = (JPDAThreadImpl)JPDADebuggerImpl.this.getThread(tr);
                            resumedThread[0].notifyToBeRunning();
                        }
                    }
                });
                Evaluator evaluator = expression.evaluator(context);
                try {
                    value = evaluator.evaluate();
                    if (this.methodCallsUnsupportedExc != null || context.canInvokeMethods()) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (this.methodCallsUnsupportedExc == null && !context.canInvokeMethods()) {
                            this.methodCallsUnsupportedExc = new InvalidExpressionException((Throwable)new UnsupportedOperationException());
                        }
                        if (disabledBreakpoints[0] != null) {
                            this.enableAllBreakpoints(disabledBreakpoints[0]);
                        }
                        if (resumedThread[0] != null) {
                            resumedThread[0].notifySuspended();
                        }
                        throw throwable;
                    }
                    catch (EvaluationException e) {
                        InvalidExpressionException iee = new InvalidExpressionException((Throwable)e);
                        iee.initCause((Throwable)e);
                        throw iee;
                    }
                    catch (IncompatibleThreadStateException itsex) {
                        ErrorManager.getDefault().notify((Throwable)itsex);
                        IllegalStateException isex = new IllegalStateException(itsex.getLocalizedMessage());
                        isex.initCause(itsex);
                        throw isex;
                    }
                }
                this.methodCallsUnsupportedExc = new InvalidExpressionException((Throwable)new UnsupportedOperationException());
            }
            if (disabledBreakpoints[0] != null) {
                this.enableAllBreakpoints(disabledBreakpoints[0]);
            }
            if (resumedThread[0] != null) {
                resumedThread[0].notifySuspended();
            }
            return value;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Value invokeMethod(ObjectReference reference, com.sun.jdi.Method method, Value[] arguments) throws InvalidExpressionException {
        if (this.currentThread == null) {
            throw new InvalidExpressionException("No current context");
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.methodCallsUnsupportedExc != null) {
                throw this.methodCallsUnsupportedExc;
            }
            List l = this.disableAllBreakpoints();
            ThreadReference tr = this.getEvaluationThread();
            JPDAThreadImpl thread = (JPDAThreadImpl)this.getThread(tr);
            boolean threadSuspended = thread.isSuspended();
            thread.notifyToBeRunning();
            CallStackFrameImpl csf = (CallStackFrameImpl)this.getCurrentCallStackFrame();
            JPDAThread frameThread = null;
            if (csf != null) {
                try {
                    frameThread = csf.getThread();
                }
                catch (InvalidStackFrameException isfex) {
                    // empty catch block
                }
            }
            try {
                Value isfex = Evaluator.invokeVirtual(reference, method, tr, Arrays.asList(arguments));
                return isfex;
            }
            catch (InvalidExpressionException ieex) {
                if (ieex.getTargetException() instanceof UnsupportedOperationException) {
                    this.methodCallsUnsupportedExc = ieex;
                }
                throw ieex;
            }
            finally {
                if (threadSuspended) {
                    thread.notifySuspended();
                }
                this.enableAllBreakpoints(l);
                if (frameThread != null) {
                    try {
                        csf.getThread();
                    }
                    catch (InvalidStackFrameException isfex) {
                        int depth = csf.getFrameDepth();
                        try {
                            CallStackFrame csf2 = frameThread.getCallStack(depth, depth + 1)[0];
                            this.setCurrentCallStackFrameNoFire(csf2);
                        }
                        catch (AbsentInformationException aiex) {
                            this.setCurrentCallStackFrame(null);
                        }
                    }
                }
            }
        }
    }

    public static String getGenericSignature(TypeComponent component) {
        if (tcGenericSignatureMethod == null) {
            return null;
        }
        try {
            return (String)tcGenericSignatureMethod.invoke((Object)component, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getGenericSignature(LocalVariable component) {
        if (lvGenericSignatureMethod == null) {
            return null;
        }
        try {
            return (String)lvGenericSignatureMethod.invoke((Object)component, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public VirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setStarting() {
        this.setState(1);
    }

    public void setStartingThread(Thread startingThread) {
        this.startingThread = startingThread;
    }

    public void unsetStartingThread() {
        this.startingThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(VirtualMachine vm, Operator o) {
        if (startVerbose) {
            System.out.println("\nS JPDADebuggerImpl.setRunning ()");
            JPDAUtils.printFeatures(vm);
        }
        Object object = this.LOCK2;
        synchronized (object) {
            this.starting = true;
        }
        this.virtualMachine = vm;
        object = this.canBeModifiedLock;
        synchronized (object) {
            this.canBeModified = null;
        }
        this.initGenericsSupport();
        this.operator = o;
        this.setState(2);
        object = this.LOCK;
        synchronized (object) {
            this.virtualMachine.resume();
        }
        if (startVerbose) {
            System.out.println("\nS JPDADebuggerImpl.setRunning () - end");
        }
        object = this.LOCK2;
        synchronized (object) {
            this.starting = false;
            this.LOCK2.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStoppedState(ThreadReference thread) {
        Object object = this.LOCK;
        synchronized (object) {
            JPDAThread t = this.getThread(thread);
            this.checkJSR45Languages(t);
            this.setCurrentThread(t);
            this.setState(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        block19: {
            if (startVerbose) {
                System.out.println("\nS StartActionProvider.finish ()");
            }
            AbstractDICookie di = (AbstractDICookie)this.lookupProvider.lookupFirst(null, AbstractDICookie.class);
            if (this.getState() == 4) {
                return;
            }
            if (this.startingThread != null) {
                this.startingThread.interrupt();
            }
            this.startingThread = null;
            Operator o = this.getOperator();
            if (o != null) {
                o.stop();
            }
            try {
                this.waitRunning();
            }
            catch (DebuggerStartException dsex) {
                // empty catch block
            }
            try {
                if (this.virtualMachine != null) {
                    if (di instanceof AttachingDICookie) {
                        if (startVerbose) {
                            System.out.println("\nS StartActionProvider.finish () VM dispose");
                        }
                        this.virtualMachine.dispose();
                    } else {
                        if (startVerbose) {
                            System.out.println("\nS StartActionProvider.finish () VM exit");
                        }
                        this.virtualMachine.exit(0);
                    }
                }
            }
            catch (VMDisconnectedException e) {
                if (!startVerbose) break block19;
                System.out.println("\nS StartActionProvider.finish () VM exception " + e);
            }
        }
        this.virtualMachine = null;
        this.setState(4);
        if (this.jsr45EngineProviders != null) {
            Iterator i = this.jsr45EngineProviders.iterator();
            while (i.hasNext()) {
                JSR45DebuggerEngineProvider provider = (JSR45DebuggerEngineProvider)((Object)i.next());
                provider.getDesctuctor().killEngine();
            }
            this.jsr45EngineProviders = null;
        }
        this.javaEngineProvider.getDestructor().killEngine();
        if (startVerbose) {
            System.out.println("\nS StartActionProvider.finish () end ");
        }
        Object object = this.LOCK2;
        synchronized (object) {
            this.starting = false;
            this.LOCK2.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.getState() == 3) {
                return;
            }
            if (this.virtualMachine != null) {
                this.virtualMachine.suspend();
            }
            this.setState(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        if (this.operator.flushStaledEvents()) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.virtualMachine != null) {
                this.virtualMachine.resume();
            }
            this.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPDAThreadGroup[] getTopLevelThreadGroups() {
        List<ThreadGroupReference> groupList;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.virtualMachine == null) {
                return new JPDAThreadGroup[0];
            }
            groupList = this.virtualMachine.topLevelThreadGroups();
        }
        JPDAThreadGroup[] groups = new JPDAThreadGroup[groupList.size()];
        for (int i = 0; i < groups.length; ++i) {
            groups[i] = this.getThreadGroup(groupList.get(i));
        }
        return groups;
    }

    public JPDAThread getThread(ThreadReference tr) {
        return (JPDAThread)this.threadsTranslation.translate(tr);
    }

    public JPDAThreadGroup getThreadGroup(ThreadGroupReference tgr) {
        return (JPDAThreadGroup)this.threadsTranslation.translate(tgr);
    }

    public Variable getLocalVariable(LocalVariable lv, Value v) {
        return (Variable)this.localsTranslation.translate(lv, v);
    }

    public Variable getVariable(Value value) {
        return this.getLocalsTreeModel().getVariable(value);
    }

    private void initGenericsSupport() {
        int minor;
        Matcher m;
        tcGenericSignatureMethod = null;
        if (Bootstrap.virtualMachineManager().minorInterfaceVersion() >= 5 && (m = jvmVersionPattern.matcher(this.virtualMachine.version())).matches() && (minor = Integer.parseInt(m.group(2))) >= 5) {
            try {
                tcGenericSignatureMethod = TypeComponent.class.getMethod("genericSignature", new Class[0]);
                lvGenericSignatureMethod = LocalVariable.class.getMethod("genericSignature", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    private void setState(int state) {
        if (state == this.state) {
            return;
        }
        int o = this.state;
        this.state = state;
        this.firePropertyChange("state", new Integer(o), new Integer(state));
        System.setProperty("org.openide.awt.SwingBrowserImpl.do-not-block-awt", String.valueOf(state != 4));
    }

    private void firePropertyChange(String name, Object o, Object n) {
        this.pcs.firePropertyChange(name, o, n);
    }

    public synchronized SourcePath getEngineContext() {
        if (this.engineContext == null) {
            this.engineContext = (SourcePath)this.lookupProvider.lookupFirst(null, SourcePath.class);
        }
        return this.engineContext;
    }

    private LocalsTreeModel getLocalsTreeModel() {
        if (this.localsTreeModel == null) {
            this.localsTreeModel = (LocalsTreeModel)this.lookupProvider.lookupFirst("LocalsView", TreeModel.class);
        }
        return this.localsTreeModel;
    }

    private ThreadReference getEvaluationThread() {
        if (this.currentThread != null) {
            return this.currentThread.getThreadReference();
        }
        if (this.virtualMachine == null) {
            return null;
        }
        List<ThreadReference> l = this.virtualMachine.allThreads();
        if (l.size() < 1) {
            return null;
        }
        int k = l.size();
        ThreadReference thread = null;
        for (int i = 0; i < k; ++i) {
            ThreadReference t = l.get(i);
            if (!t.isSuspended()) continue;
            thread = t;
            if (!t.name().equals("Finalizer")) continue;
            return t;
        }
        return thread;
    }

    private void updateCurrentCallStackFrame(JPDAThread thread) {
        if (thread == null || thread.getStackDepth() < 1) {
            this.setCurrentCallStackFrame(null);
        } else {
            try {
                this.setCurrentCallStackFrame(thread.getCallStack(0, 1)[0]);
            }
            catch (AbsentInformationException e) {
                this.setCurrentCallStackFrame(null);
            }
        }
    }

    private List disableAllBreakpoints() {
        ArrayList<EventRequest> l = new ArrayList<EventRequest>();
        VirtualMachine vm = this.getVirtualMachine();
        if (vm == null) {
            return l;
        }
        EventRequestManager erm = vm.eventRequestManager();
        l.addAll(erm.accessWatchpointRequests());
        l.addAll(erm.breakpointRequests());
        l.addAll(erm.classPrepareRequests());
        l.addAll(erm.classUnloadRequests());
        l.addAll(erm.exceptionRequests());
        l.addAll(erm.methodEntryRequests());
        l.addAll(erm.methodExitRequests());
        l.addAll(erm.modificationWatchpointRequests());
        l.addAll(erm.threadDeathRequests());
        l.addAll(erm.threadStartRequests());
        for (int i = l.size() - 1; i >= 0; --i) {
            if (!((EventRequest)l.get(i)).isEnabled()) {
                l.remove(i);
                continue;
            }
            ((EventRequest)l.get(i)).disable();
        }
        this.operator.breakpointsDisabled();
        return l;
    }

    private void enableAllBreakpoints(List l) {
        this.operator.breakpointsEnabled();
        int k = l.size();
        for (int i = 0; i < k; ++i) {
            try {
                ((EventRequest)l.get(i)).enable();
                continue;
            }
            catch (IllegalThreadStateException ex) {
                continue;
            }
            catch (InvalidRequestStateException ex) {
                // empty catch block
            }
        }
    }

    private void checkJSR45Languages(JPDAThread t) {
        if (t.getStackDepth() > 0) {
            try {
                CallStackFrame f = t.getCallStack(0, 1)[0];
                List l = f.getAvailableStrata();
                int k = l.size();
                for (int i = 0; i < k; ++i) {
                    if (this.languages.contains(l.get(i))) continue;
                    String language = (String)l.get(i);
                    DebuggerManager.getDebuggerManager().startDebugging(this.createJSR45DI(language));
                    this.languages.add(language);
                }
                String stratum = f.getDefaultStratum();
                if (stratum != null && !stratum.equals(this.lastStratumn)) {
                    this.javaEngineProvider.getSession().setCurrentLanguage(stratum);
                }
                this.lastStratumn = stratum;
            }
            catch (AbsentInformationException e) {
                System.out.println("NoInformationException");
            }
        }
    }

    private DebuggerInfo createJSR45DI(String language) {
        if (this.jsr45EngineProviders == null) {
            this.jsr45EngineProviders = new HashSet(1);
        }
        JSR45DebuggerEngineProvider provider = new JSR45DebuggerEngineProvider(language);
        this.jsr45EngineProviders.add(provider);
        return DebuggerInfo.create((String)("netbeans-jpda-JSR45DICookie-" + language), (Object[])new Object[]{new DelegatingSessionProvider(){

            public Session getSession(DebuggerInfo debuggerInfo) {
                return JPDADebuggerImpl.this.javaEngineProvider.getSession();
            }
        }, provider});
    }

    public JPDAStep createJPDAStep(int size, int depth) {
        Session session = (Session)this.lookupProvider.lookupFirst(null, Session.class);
        return new JPDAStepImpl(this, session, size, depth);
    }
}

