/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.javadoc;

import java.util.Hashtable;
import org.netbeans.editor.ext.html.javadoc.TagHelpItem;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SAXHelpHandler
extends DefaultHandler {
    private TagHelpItem tag = null;
    private TagHelpItem attribute;
    private static final int HELP_CODE = "help".hashCode();
    private static final int TAG_CODE = "tag".hashCode();
    private static final int ATTRIBUTE_CODE = "attribute".hashCode();
    private static final int LOCATION_CODE = "location".hashCode();
    private static final int START_TEXT_CODE = "start-text".hashCode();
    private static final int END_TEXT_CODE = "end-text".hashCode();
    private static final int ADD_TEXT_CODE = "add-text".hashCode();
    private static final int BEFORE_CODE = "before".hashCode();
    private static final int AFTER_CODE = "after".hashCode();
    private static final String NAME_STRING = "name";
    private static final String LOCATION_STRING = "location";
    private static final String FILE_STRING = "file";
    private static final String IDENTICAL_STRING = "identical";
    private static final String TEXT_STRING = "text";
    private static final String OFFSET_STRING = "offset";
    private static final String BEFORE_STRING = "before";
    private static final String AFTER_STRING = "after";
    private static final int TAG_STATE = 1;
    private static final int ATTRIBUTE_STATE = 2;
    private static final int BEFORE_STATE = 10;
    private static final int AFTER_STATE = 11;
    private int state;
    private int textState;
    private Hashtable map = new Hashtable();
    private String file = null;
    private String location;
    private String identical;
    private String mezery;

    public void startElement(String uri, String localname, String qname, Attributes attrs) throws SAXException {
        int controlCode = qname.hashCode();
        if (controlCode == TAG_CODE) {
            String value = attrs.getValue(NAME_STRING);
            this.tag = new TagHelpItem(value);
            this.map.put(this.tag.getName().toUpperCase(), this.tag);
            this.state = 1;
            value = attrs.getValue(IDENTICAL_STRING);
            if (value != null) {
                this.tag.setIdentical(value);
            }
        } else if (controlCode == ATTRIBUTE_CODE) {
            String value = attrs.getValue(NAME_STRING);
            this.attribute = new TagHelpItem(value);
            this.state = 2;
            this.map.put((this.tag.getName() + "#" + this.attribute.getName()).toUpperCase(), this.attribute);
            value = attrs.getValue(IDENTICAL_STRING);
            if (value != null) {
                this.attribute.setIdentical(value);
            }
        } else if (controlCode == LOCATION_CODE) {
            String value = attrs.getValue(FILE_STRING);
            switch (this.state) {
                case 1: {
                    this.tag.setFile(value);
                    break;
                }
                case 2: {
                    this.attribute.setFile(value);
                }
            }
        } else if (controlCode == START_TEXT_CODE) {
            String value = attrs.getValue(OFFSET_STRING);
            int offset = 0;
            if (value != null) {
                try {
                    offset = new Integer(value);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            value = attrs.getValue(TEXT_STRING);
            switch (this.state) {
                case 1: {
                    this.tag.setStartText(value);
                    this.tag.setStartTextOffset(offset);
                    break;
                }
                case 2: {
                    this.attribute.setStartText(value);
                    this.attribute.setStartTextOffset(offset);
                }
            }
        } else if (controlCode == END_TEXT_CODE) {
            String value = attrs.getValue(OFFSET_STRING);
            int offset = 0;
            if (value != null) {
                try {
                    offset = new Integer(value);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            value = attrs.getValue(TEXT_STRING);
            switch (this.state) {
                case 1: {
                    this.tag.setEndText(value);
                    this.tag.setEndTextOffset(offset);
                    break;
                }
                case 2: {
                    this.attribute.setEndText(value);
                    this.attribute.setEndTextOffset(offset);
                }
            }
        } else if (controlCode == ADD_TEXT_CODE) {
            String before = attrs.getValue(BEFORE_STRING);
            String after = attrs.getValue(AFTER_STRING);
            switch (this.state) {
                case 1: {
                    this.tag.setTextBefore(before);
                    this.tag.setTextAfter(after);
                    break;
                }
                case 2: {
                    this.attribute.setTextBefore(before);
                    this.attribute.setTextAfter(after);
                }
            }
        } else if (controlCode != START_TEXT_CODE) {
            if (controlCode == BEFORE_CODE) {
                this.textState = 10;
            } else if (controlCode == AFTER_CODE) {
                this.textState = 11;
            } else if (controlCode == HELP_CODE) {
                this.file = attrs.getValue(FILE_STRING);
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String text = new String(ch, start, length).trim();
        if (text != null && text.length() > 0) {
            TagHelpItem key = null;
            switch (this.state) {
                case 1: {
                    key = this.tag;
                    break;
                }
                case 2: {
                    key = this.attribute;
                }
            }
            if (key != null) {
                switch (this.textState) {
                    case 10: {
                        if (key.getTextBefore() != null) {
                            key.setTextBefore(key.getTextBefore() + text);
                            break;
                        }
                        key.setTextBefore(text);
                        break;
                    }
                    case 11: {
                        if (key.getTextAfter() != null) {
                            key.setTextAfter(key.getTextAfter() + text);
                            break;
                        }
                        key.setTextAfter(text);
                    }
                }
            }
        }
    }

    public String getHelpFile() {
        return this.file;
    }

    public Hashtable getMap() {
        return this.map;
    }
}

