/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Utilities;
import org.netbeans.modules.editor.hints.borrowed.ListCompletionView;
import org.netbeans.modules.editor.hints.borrowed.ScrollCompletionPane;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.editor.hints.spi.Hint;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class HintsUI
implements MouseListener,
KeyListener {
    private JTextComponent comp;
    private List hints = Collections.EMPTY_LIST;
    private Popup listPopup;
    private JLabel hintIcon;
    private ScrollCompletionPane hintListComponent;
    private PopupFactory pf = null;
    private ChangeInfo changes;
    static final /* synthetic */ boolean $assertionsDisabled;

    HintsUI() {
    }

    public JTextComponent getComponent() {
        return this.comp;
    }

    public void setHints(List hints, JTextComponent comp, boolean showPopup) {
        boolean show;
        if (((Object)this.hints).equals(hints) && this.comp == comp) {
            return;
        }
        if (comp != this.comp || !((Object)this.hints).equals(hints) && comp != null) {
            this.removePopups();
        }
        boolean bl = show = hints != null && comp != null && !hints.isEmpty();
        if (!show && this.comp != null) {
            this.removePopups();
        }
        this.hints = hints == null ? Collections.EMPTY_LIST : hints;
        this.setComponent(comp);
        if (show) {
            boolean popup = ((Hint)hints.get(0)).getType() == 2;
            this.showHints();
            if (!popup && showPopup) {
                this.showPopup();
            }
        }
    }

    private void setComponent(JTextComponent comp) {
        boolean change;
        boolean bl = change = this.comp != comp;
        if (change) {
            this.unregister();
            this.comp = comp;
            this.register();
        }
    }

    private void register() {
        if (this.comp == null) {
            return;
        }
        this.comp.addKeyListener(this);
    }

    private void unregister() {
        if (this.comp == null) {
            return;
        }
        this.comp.removeKeyListener(this);
    }

    private void removePopups() {
        if (this.comp == null) {
            return;
        }
        this.removeIconHint();
        this.removePopup();
    }

    private void removeIconHint() {
        Container c;
        if (this.hintIcon != null && (c = this.hintIcon.getParent()) != null) {
            Rectangle bds = this.hintIcon.getBounds();
            c.remove(this.hintIcon);
            c.repaint(bds.x, bds.y, bds.width, bds.height);
        }
    }

    private void removePopup() {
        if (this.listPopup != null) {
            this.listPopup.hide();
            this.hintListComponent.getView().removeMouseListener(this);
            this.hintListComponent = null;
            this.listPopup = null;
            this.hintIcon.setToolTipText(NbBundle.getMessage((Class)HintsUI.class, (String)"HINT_Bulb"));
        }
    }

    boolean isKnownComponent(Component c) {
        return c != null && (c == this.comp || c == this.hintIcon || c == this.hintListComponent || c instanceof Container && ((Container)c).isAncestorOf(this.hintListComponent));
    }

    private void showHints() {
        if (this.comp == null || !this.comp.isDisplayable() || !this.comp.isShowing()) {
            return;
        }
        this.configureBounds(this.getHintIcon());
    }

    private void configureBounds(JComponent jc) {
        JRootPane pane = this.comp.getRootPane();
        JLayeredPane lp = pane.getLayeredPane();
        Rectangle r = null;
        try {
            int pos = Utilities.getRowStart(this.comp, this.comp.getCaret().getDot());
            r = this.comp.modelToView(pos);
        }
        catch (BadLocationException e) {
            this.setHints(null, null, false);
            ErrorManager.getDefault().notify((Throwable)e);
            return;
        }
        Point p = new Point(r.x - this.comp.getX(), r.y);
        Dimension d = jc.getPreferredSize();
        p.x -= 13;
        p.y += 4;
        SwingUtilities.convertPointToScreen(p, this.comp);
        SwingUtilities.convertPointFromScreen(p, lp);
        jc.setBounds(p.x, p.y, d.width, d.height);
        lp.add((Component)jc, JLayeredPane.POPUP_LAYER);
        jc.setVisible(true);
        jc.repaint();
    }

    private JLabel getHintIcon() {
        String iconBase;
        if (this.hintIcon == null) {
            this.hintIcon = new JLabel();
            this.hintIcon.addMouseListener(this);
            this.hintIcon.setToolTipText(NbBundle.getMessage((Class)HintsUI.class, (String)"HINT_Bulb"));
        }
        if (this.hints.size() > 1) {
            iconBase = "org/netbeans/modules/editor/hints/resources/error.png";
        } else {
            int type = 3;
            if (this.hints.size() > 0) {
                Hint hint = (Hint)this.hints.get(0);
                type = hint.getType();
            }
            iconBase = type == 3 ? "org/netbeans/modules/editor/hints/resources/suggestion.png" : "org/netbeans/modules/editor/hints/resources/error.png";
        }
        this.hintIcon.setIcon(new ImageIcon(org.openide.util.Utilities.loadImage((String)iconBase)));
        return this.hintIcon;
    }

    void showPopup() {
        if (this.comp == null || this.hints.isEmpty()) {
            return;
        }
        this.hintIcon.setToolTipText(null);
        ToolTipManager.sharedInstance().setEnabled(false);
        ToolTipManager.sharedInstance().setEnabled(true);
        if (!$assertionsDisabled && this.hintListComponent != null) {
            throw new AssertionError();
        }
        this.hintListComponent = new ScrollCompletionPane(this.comp, this.hints, null, null);
        this.hintListComponent.getView().addMouseListener(this);
        try {
            int pos = Utilities.getRowStart(this.comp, this.comp.getCaret().getDot());
            Rectangle r = this.comp.modelToView(pos);
            Point p = new Point(r.x + 5, r.y + 20);
            SwingUtilities.convertPointToScreen(p, this.comp);
            if (!$assertionsDisabled && this.listPopup != null) {
                throw new AssertionError();
            }
            this.listPopup = this.getPopupFactory().getPopup(this.comp, this.hintListComponent, p.x, p.y);
            this.listPopup.show();
        }
        catch (BadLocationException ble) {
            ErrorManager.getDefault().notify((Throwable)ble);
            this.setHints(null, null, false);
        }
    }

    private PopupFactory getPopupFactory() {
        if (this.pf == null) {
            this.pf = PopupFactory.getSharedInstance();
        }
        return this.pf;
    }

    public void mouseClicked(MouseEvent e) {
        Hint h;
        if ((e.getSource() == this.hintListComponent || e.getSource() instanceof ListCompletionView) && (h = (Hint)this.hintListComponent.getView().getSelectedValue()) != null) {
            this.invokeHint(h);
            this.setHints(null, null, false);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() instanceof JLabel && !this.isPopupActive()) {
            this.showPopup();
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public boolean isActive() {
        boolean bulbShowing = this.hintIcon != null && this.hintIcon.isShowing();
        boolean popupShowing = this.hintListComponent != null && this.hintListComponent.isShowing();
        return bulbShowing || popupShowing;
    }

    public boolean isPopupActive() {
        return this.hintListComponent != null && this.hintListComponent.isShowing();
    }

    public void keyPressed(KeyEvent e) {
        InputMap input;
        Object actionTag;
        boolean popupShowing;
        if (this.comp == null || this.hints.size() == 0) {
            return;
        }
        boolean bulbShowing = this.hintIcon != null && this.hintIcon.isShowing();
        boolean bl = popupShowing = this.hintListComponent != null && this.hintListComponent.isShowing();
        if (e.getKeyCode() == 10) {
            if (e.getModifiersEx() == 512) {
                if (bulbShowing && !popupShowing) {
                    this.showPopup();
                    e.consume();
                }
            } else if (e.getModifiersEx() == 0 && popupShowing) {
                Hint hint = (Hint)this.hintListComponent.getView().getSelectedValue();
                this.invokeHint(hint);
                e.consume();
            }
        } else if (e.getKeyCode() == 27) {
            if (popupShowing) {
                this.removePopup();
            }
        } else if (popupShowing && (actionTag = (input = this.hintListComponent.getInputMap()).get(KeyStroke.getKeyStrokeForEvent(e))) != null) {
            Action a = this.hintListComponent.getActionMap().get(actionTag);
            a.actionPerformed(null);
            e.consume();
            return;
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invokeHint(final Hint h) {
        this.removePopups();
        JTextComponent component = this.comp;
        Cursor cur = component.getCursor();
        component.setCursor(Cursor.getPredefinedCursor(3));
        RequestProcessor.Task t = null;
        try {
            t = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    HintsUI.this.changes = h.implement();
                }
            });
            if (t == null) return;
        }
        catch (Throwable throwable) {
            if (t == null) throw throwable;
            t.addTaskListener(new TaskListener(component, cur){
                private final /* synthetic */ JTextComponent val$component;
                private final /* synthetic */ Cursor val$cur;
                {
                    this.val$component = jTextComponent;
                    this.val$cur = cursor;
                }

                public void taskFinished(Task task) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            HintsUI.open(HintsUI.this.changes, val$component);
                            val$component.setCursor(val$cur);
                        }
                    });
                }
            });
            throw throwable;
        }
        t.addTaskListener(new /* invalid duplicate definition of identical inner class */);
    }

    private static void open(ChangeInfo changes, JTextComponent component) {
        JTextComponent c = component;
        if (changes != null && changes.size() > 0) {
            ChangeInfo.Change change = changes.get(0);
            FileObject file = change.getFileObject();
            if (file != null) {
                try {
                    DataObject dob = DataObject.find((FileObject)file);
                    EditCookie ck = (EditCookie)dob.getCookie(EditCookie.class);
                    if (ck != null) {
                        ck.edit();
                    } else {
                        OpenCookie oc = (OpenCookie)dob.getCookie(OpenCookie.class);
                        oc.open();
                    }
                    EditorCookie edit = (EditorCookie)dob.getCookie(EditorCookie.class);
                    JEditorPane[] panes = edit.getOpenedPanes();
                    if (panes == null || panes.length <= 0) {
                        return;
                    }
                    c = panes[0];
                }
                catch (DataObjectNotFoundException donfe) {
                    ErrorManager.getDefault().notify((Throwable)donfe);
                    return;
                }
            }
            Position start = change.getStart();
            Position end = change.getEnd();
            if (start != null) {
                c.setSelectionStart(start.getOffset());
            }
            if (end != null) {
                c.setSelectionEnd(end.getOffset());
            }
        }
    }

    static {
        $assertionsDisabled = !HintsUI.class.desiredAssertionStatus();
    }
}

