/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui.actions;

import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.DebugAction;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.j2ee.deployment.profiler.spi.Profiler;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class ProfileAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(DebugAction.class, (String)"LBL_Profile");
    }

    protected void performAction(Node[] nodes) {
        ProfileAction.performActionImpl(nodes);
    }

    protected boolean enable(Node[] nodes) {
        return ProfileAction.enableImpl(nodes);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static void performActionImpl(Node[] nodes) {
        if (nodes.length != 1) {
            return;
        }
        final ServerInstance si = (ServerInstance)nodes[0].getCookie(ServerInstance.class);
        if (si != null) {
            Profiler profiler = ServerRegistry.getProfiler();
            if (profiler == null) {
                return;
            }
            final ProfilerServerSettings settings = profiler.getSettings(si.getUrl());
            if (settings == null) {
                return;
            }
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String title = NbBundle.getMessage(DebugAction.class, (String)"LBL_Profiling", (Object)si.getDisplayName());
                    ProgressUI progressUI = new ProgressUI(title, false);
                    try {
                        progressUI.start();
                        si.startProfile(settings, false, progressUI);
                    }
                    catch (ServerException ex) {
                        String msg = ex.getLocalizedMessage();
                        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)msg, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                    }
                    finally {
                        progressUI.finish();
                    }
                }
            });
        }
    }

    private static boolean enableImpl(Node[] nodes) {
        if (nodes.length != 1) {
            return false;
        }
        ServerInstance si = (ServerInstance)nodes[0].getCookie(ServerInstance.class);
        return si != null && si.getServerState() == 2 && si.isProfileSupported();
    }
}

