/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.persistence.rules.member;

import java.util.Arrays;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.AnnotatedAsIdOrEmbeddedIdPred;

public class IdDefinedOnceInHierarchy
extends AbstractRule {
    private String superClassThatDefinesId;

    public IdDefinedOnceInHierarchy() {
        super(null, Arrays.asList(new AnnotatedAsIdOrEmbeddedIdPred()));
    }

    public String getId() {
        return "IdDefinedOnceInHierarchy";
    }

    protected String getMessageKey() {
        return "MSG_SuperClassAlreadyHasId";
    }

    protected Object[] getMessageParameters() {
        Object[] result = new Object[]{this.superClassThatDefinesId};
        return result;
    }

    protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        return ctx.isMappedSuperclass() && super.isApplicable(subject, ctx);
    }

    public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (this.isApplicable(subject, ctx)) {
            JavaClass javaClass = ctx.getMainJavaClass();
            boolean idAlreadyDefined = false;
            JavaClass nextClass = javaClass.getSuperClass();
            while (!nextClass.getName().equals("java.lang.Object")) {
                idAlreadyDefined = PersistenceAPIHelper.isAnyMemberAnnotatedAsIdOrEmbeddedId(nextClass);
                if (idAlreadyDefined) {
                    this.superClassThatDefinesId = nextClass.getName();
                    return this.createProblem(ctx, subject);
                }
                nextClass = nextClass.getSuperClass();
            }
        }
        return null;
    }

    public void reset() {
        this.superClassThatDefinesId = null;
    }
}

