/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification;

import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.verification.Visitor;
import org.openide.util.NbBundle;

public class TreeWalker
implements Visitor {
    private final Visitor piggyBackedVisitor;

    public TreeWalker(Visitor piggyBackedVisitor) {
        if (piggyBackedVisitor instanceof TreeWalker) {
            throw new IllegalArgumentException(NbBundle.getMessage(this.getClass(), (String)"MSG_TreeWalkerIllegalArgument", (Object)piggyBackedVisitor));
        }
        this.piggyBackedVisitor = piggyBackedVisitor;
    }

    public void visitClass(JavaClass javaClass) {
        Element[] classElements;
        this.piggyBackedVisitor.visitClass(javaClass);
        for (Annotation annotation : javaClass.getAnnotations()) {
            this.visitAnnotation(annotation);
        }
        for (Element e : classElements = javaClass.getContents().toArray(new Element[0])) {
            if (e instanceof JavaClass) continue;
            if (e instanceof Constructor) {
                this.visitConstructor((Constructor)Constructor.class.cast(e));
                continue;
            }
            if (e instanceof Method) {
                this.visitMethod((Method)Method.class.cast(e));
                continue;
            }
            if (e instanceof Field) {
                this.visitField((Field)Field.class.cast(e));
                continue;
            }
            if (!(e instanceof Annotation)) continue;
            this.visitAnnotation((Annotation)Annotation.class.cast(e));
        }
    }

    public void visitConstructor(Constructor constr) {
        this.piggyBackedVisitor.visitConstructor(constr);
        for (Annotation annotation : constr.getAnnotations()) {
            this.visitAnnotation(annotation);
        }
    }

    public void visitMethod(Method method) {
        this.piggyBackedVisitor.visitMethod(method);
        for (Annotation annotation : method.getAnnotations()) {
            this.visitAnnotation(annotation);
        }
    }

    public void visitField(Field field) {
        this.piggyBackedVisitor.visitField(field);
        for (Annotation annotation : field.getAnnotations()) {
            this.visitAnnotation(annotation);
        }
    }

    public void visitAnnotation(Annotation annotation) {
        this.piggyBackedVisitor.visitAnnotation(annotation);
    }
}

