/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.Action;
import org.netbeans.modules.palette.Item;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class DefaultItem
implements Item {
    private Node itemNode;

    public DefaultItem(Node itemNode) {
        this.itemNode = itemNode;
    }

    public String getName() {
        return this.itemNode.getName();
    }

    public Image getIcon(int type) {
        return this.itemNode.getIcon(type);
    }

    public Action[] getActions() {
        return this.itemNode.getActions(false);
    }

    public String getShortDescription() {
        return this.itemNode.getShortDescription();
    }

    public String getDisplayName() {
        return this.itemNode.getDisplayName();
    }

    public void invokePreferredAction(ActionEvent e) {
        Action action = this.itemNode.getPreferredAction();
        if (null != action && action.isEnabled()) {
            action.actionPerformed(e);
        }
    }

    public Lookup getLookup() {
        return this.itemNode.getLookup();
    }

    public boolean equals(Object obj) {
        if (null == obj || !(obj instanceof DefaultItem)) {
            return false;
        }
        return this.itemNode.equals((Object)((DefaultItem)obj).itemNode);
    }

    public Transferable drag() {
        try {
            return this.itemNode.drag();
        }
        catch (IOException ioE) {
            ErrorManager.getDefault().notify(1, (Throwable)ioE);
            return null;
        }
    }

    public Transferable cut() {
        try {
            return this.itemNode.clipboardCut();
        }
        catch (IOException ioE) {
            ErrorManager.getDefault().notify(1, (Throwable)ioE);
            return null;
        }
    }

    public String toString() {
        return this.itemNode.getDisplayName();
    }
}

