/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.apache.tools.ant.module.AntModule;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.WeakSet;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class Hyperlink
extends Annotation
implements OutputListener,
PropertyChangeListener {
    private static final Set hyperlinks = new WeakSet();
    private final URL url;
    private final String message;
    private final int line1;
    private int col1;
    private final int line2;
    private final int col2;
    private boolean dead = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void detachAllAnnotations() {
        Set set = hyperlinks;
        synchronized (set) {
            Iterator it = hyperlinks.iterator();
            while (it.hasNext()) {
                ((Hyperlink)it.next()).destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hyperlink(URL url, String message, int line1, int col1, int line2, int col2) {
        this.url = url;
        this.message = message;
        this.line1 = line1;
        this.col1 = col1;
        this.line2 = line2;
        this.col2 = col2;
        Set set = hyperlinks;
        synchronized (set) {
            hyperlinks.add(this);
        }
    }

    public void setColumn1(int col1) {
        if (this.col1 == -1) {
            this.col1 = col1;
        }
    }

    void destroy() {
        this.doDetach();
        this.dead = true;
    }

    public void outputLineAction(OutputEvent ev) {
        block11: {
            if (this.dead) {
                return;
            }
            FileObject file = URLMapper.findFileObject((URL)this.url);
            if (file == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                DataObject dob = DataObject.find((FileObject)file);
                EditorCookie ed = (EditorCookie)dob.getCookie(EditorCookie.class);
                if (ed != null && file == dob.getPrimaryFile()) {
                    if (this.line1 == -1) {
                        ed.open();
                        break block11;
                    }
                    ed.openDocument();
                    AntModule.err.log("opened document for " + file);
                    try {
                        Line l = ed.getLineSet().getOriginal(this.line1 - 1);
                        if (l.isDeleted()) break block11;
                        this.attachAsNeeded(l);
                        if (this.col1 == -1) {
                            l.show(2);
                            break block11;
                        }
                        l.show(2, this.col1 - 1);
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        ed.open();
                    }
                    break block11;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify(16, (Throwable)donfe);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(16, (Throwable)ioe);
            }
        }
        if (this.message != null) {
            StatusDisplayer.getDefault().setStatusText(this.message);
        }
    }

    public void outputLineSelected(OutputEvent ev) {
        if (this.dead) {
            return;
        }
        FileObject file = URLMapper.findFileObject((URL)this.url);
        if (file == null) {
            return;
        }
        try {
            DataObject dob = DataObject.find((FileObject)file);
            EditorCookie ed = (EditorCookie)dob.getCookie(EditorCookie.class);
            if (ed != null) {
                Line l;
                if (ed.getDocument() == null) {
                    AntModule.err.log("no document for " + file);
                    return;
                }
                AntModule.err.log("got document for " + file);
                if (this.line1 != -1 && !(l = ed.getLineSet().getOriginal(this.line1 - 1)).isDeleted()) {
                    this.attachAsNeeded(l);
                    if (this.col1 == -1) {
                        l.show(0);
                    } else {
                        l.show(0, this.col1 - 1);
                    }
                }
            }
        }
        catch (DataObjectNotFoundException donfe) {
            ErrorManager.getDefault().notify(16, (Throwable)donfe);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void attachAsNeeded(Line l) {
        if (this.getAttachedAnnotatable() == null) {
            Line ann;
            boolean log = AntModule.err.isLoggable(1);
            String text = l.getText();
            if (log) {
                AntModule.err.log("Attaching to line " + l.getDisplayName() + " text=`" + text + "' line1=" + this.line1 + " line2=" + this.line2 + " col1=" + this.col1 + " col2=" + this.col2);
            }
            if (text != null && (this.line2 == -1 || this.line1 == this.line2) && this.col1 != -1) {
                int new_col1 = this.convertTabColumnsToCharacterColumns(text, this.col1 - 1, 8);
                int new_col2 = this.convertTabColumnsToCharacterColumns(text, this.col2 - 1, 8);
                if (log) {
                    AntModule.err.log("\tfits on one line");
                }
                if (new_col2 != -1 && new_col2 >= new_col1 && new_col2 < text.length()) {
                    if (log) {
                        AntModule.err.log("\tspecified section of the line");
                    }
                    ann = l.createPart(new_col1, new_col2 - new_col1 + 1);
                } else if (new_col1 < text.length()) {
                    if (log) {
                        AntModule.err.log("\tspecified column to end of line");
                    }
                    ann = l.createPart(new_col1, text.length() - new_col1 - 1);
                } else {
                    if (log) {
                        AntModule.err.log("\tcolumn numbers are bogus");
                    }
                    ann = l;
                }
            } else {
                if (log) {
                    AntModule.err.log("\tmultiple lines, something wrong with line, or no column given");
                }
                ann = l;
            }
            this.attach((Annotatable)ann);
            Set set = hyperlinks;
            synchronized (set) {
                Iterator it = hyperlinks.iterator();
                while (it.hasNext()) {
                    Hyperlink h = (Hyperlink)it.next();
                    if (h == this) continue;
                    h.doDetach();
                }
            }
            ann.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private int convertTabColumnsToCharacterColumns(String text, int column, int tabSize) {
        int i;
        char[] textChars = text.toCharArray();
        int jikes_column = 0;
        for (i = 0; i < textChars.length && jikes_column < column; ++i) {
            if (textChars[i] == '\t') {
                jikes_column += tabSize - jikes_column % tabSize;
                continue;
            }
            ++jikes_column;
        }
        return i;
    }

    private synchronized void doDetach() {
        Annotatable ann = this.getAttachedAnnotatable();
        if (ann != null) {
            if (AntModule.err.isLoggable(1)) {
                AntModule.err.log("Detaching from " + ann + " `" + ann.getText() + "'");
            }
            ann.removePropertyChangeListener((PropertyChangeListener)this);
            this.detach();
        }
    }

    public void outputLineCleared(OutputEvent ev) {
        this.doDetach();
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (this.dead) {
            return;
        }
        String prop = ev.getPropertyName();
        if (prop == null || prop.equals("text") || prop.equals("deleted")) {
            if (AntModule.err.isLoggable(1)) {
                AntModule.err.log("Received Annotatable property change: " + prop);
            }
            this.doDetach();
        }
    }

    public String getAnnotationType() {
        return "org-apache-tools-ant-module-error";
    }

    public String getShortDescription() {
        if (this.message != null) {
            return this.message;
        }
        return null;
    }

    public String toString() {
        return "Hyperlink[" + this.url + ":" + this.line1 + ":" + this.col1 + ":" + this.line2 + ":" + this.col2 + "]";
    }
}

