/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.perftool;

import java.text.MessageFormat;
import org.netbeans.core.perftool.PerformanceEvent;
import org.netbeans.core.perftool.PerformanceMeter;
import org.netbeans.core.perftool.Util;
import org.openide.ErrorManager;

final class PerformanceMeterImpl
implements PerformanceMeter {
    static final String LOG_NAME = "IDE-Perf";
    static final String LOG_PREFIX = "[IDE-Perf] ";
    private static PerformanceMeterImpl instance;
    private ErrorManager log;

    static PerformanceMeterImpl getInstance() {
        if (instance == null) {
            instance = new PerformanceMeterImpl();
        }
        return instance;
    }

    private PerformanceMeterImpl() {
    }

    public void notify(PerformanceEvent ev) {
        if (Util.isRunning()) {
            this.log(ev.toString());
        }
    }

    public void notifyTime(String msg, long millis) {
        if (Util.isRunning()) {
            this.log(MessageFormat.format("{0} {1} s", msg, Util.long2Print(millis, 1000.0f, 3)));
        }
    }

    public void notifyMemory(String msg, long bytes) {
        if (Util.isRunning()) {
            this.log(MessageFormat.format("{0} {1} MB", msg, Util.long2Print(bytes, 1048576.0f, 1)));
        }
    }

    private ErrorManager getLog() {
        if (this.log == null) {
            this.log = ErrorManager.getDefault().getInstance(LOG_NAME);
        }
        return this.log;
    }

    private void log(String msg) {
        this.getLog().log(256, msg);
    }
}

