/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.actions.PasteAction;
import org.openide.awt.Actions;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.windows.WindowManager;

public final class NewAction
extends NodeAction {
    private static ActSubMenuModel model = new ActSubMenuModel(null);
    static /* synthetic */ Class class$org$openide$nodes$Node;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    protected void performAction(Node[] activatedNodes) {
        NewAction.performAction(activatedNodes, 0);
    }

    protected boolean asynchronous() {
        return false;
    }

    private static void performAction(Node[] activatedNodes, int indx) {
        NewType[] types = NewAction.getNewTypes(activatedNodes);
        if (types.length <= indx) {
            return;
        }
        NewAction.performAction(activatedNodes, types[indx]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performAction(Node[] activatedNodes, NewType type) {
        PasteAction.NodeSelector sel = null;
        try {
            ExplorerManager em = PasteAction.findExplorerManager();
            if (em != null) {
                sel = new PasteAction.NodeSelector(em, activatedNodes);
            }
            type.create();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        finally {
            if (sel != null) {
                sel.select();
            }
        }
    }

    private static NewType[] getNewTypes() {
        return NewAction.getNewTypes(WindowManager.getDefault().getRegistry().getCurrentNodes());
    }

    private static NewType[] getNewTypes(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return new NewType[0];
        }
        return activatedNodes[0].getNewTypes();
    }

    protected boolean enable(Node[] activatedNodes) {
        NewType[] types = NewAction.getNewTypes();
        Object[] listeners = model.getListenerList();
        if (listeners.length > 0) {
            ChangeEvent ev = new ChangeEvent(model);
            for (int i = listeners.length - 1; i >= 0; i -= 2) {
                ((ChangeListener)listeners[i]).stateChanged(ev);
            }
        }
        return types.length > 0;
    }

    public String getName() {
        return NewAction.createName(NewAction.getNewTypes());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(NewAction.class);
    }

    public JMenuItem getMenuPresenter() {
        return new Actions.SubMenu((SystemAction)this, (Actions.SubMenuModel)model, false);
    }

    public JMenuItem getPopupPresenter() {
        return new Actions.SubMenu((SystemAction)this, (Actions.SubMenuModel)model, true);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new DelegateAction(this, actionContext);
    }

    private static String createName(NewType[] newTypes) {
        if (newTypes != null && newTypes.length == 1) {
            return NbBundle.getMessage((Class)NewAction.class, (String)"NewArg", (Object)newTypes[0].getName());
        }
        return NbBundle.getMessage((Class)NewAction.class, (String)"New");
    }

    private static final class DelegateAction
    implements Action,
    Presenter.Menu,
    Presenter.Popup {
        private final NodeAction delegate;
        private final ActSubMenuModel model;

        public DelegateAction(NodeAction a, Lookup actionContext) {
            this.delegate = a;
            this.model = new ActSubMenuModel(actionContext);
        }

        public String toString() {
            return super.toString() + "[delegate=" + this.delegate + "]";
        }

        public void actionPerformed(ActionEvent e) {
            this.model.performActionAt(0);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public void putValue(String key, Object o) {
        }

        public Object getValue(String key) {
            if ("Name".equals(key)) {
                return NewAction.createName(this.model.newTypes());
            }
            return this.delegate.getValue(key);
        }

        public boolean isEnabled() {
            return this.model.getCount() > 0;
        }

        public void setEnabled(boolean b) {
        }

        public JMenuItem getMenuPresenter() {
            return new Actions.SubMenu((Action)this, (Actions.SubMenuModel)this.model, false);
        }

        public JMenuItem getPopupPresenter() {
            return new Actions.SubMenu((Action)this, (Actions.SubMenuModel)this.model, true);
        }
    }

    private static class ActSubMenuModel
    extends EventListenerList
    implements Actions.SubMenuModel {
        static final long serialVersionUID = -4273674308662494596L;
        private Lookup lookup;
        private Node prevNode;
        private NewType[] prevTypes;

        ActSubMenuModel(Lookup lookup) {
            this.lookup = lookup;
        }

        private NewType[] newTypes() {
            Collection c;
            if (this.lookup != null && (c = this.lookup.lookup(new Lookup.Template(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = NewAction.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node)).allItems()).size() == 1) {
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    Lookup.Item item = (Lookup.Item)it.next();
                    Node n = (Node)item.getInstance();
                    if (n == null) continue;
                    if (n == this.prevNode && this.prevTypes != null) {
                        return this.prevTypes;
                    }
                    this.prevNode = n;
                    this.prevTypes = n.getNewTypes();
                    return this.prevTypes;
                }
            }
            return NewAction.getNewTypes();
        }

        public int getCount() {
            return this.newTypes().length;
        }

        public String getLabel(int index) {
            NewType[] newTypes = this.newTypes();
            if (newTypes.length <= index) {
                return null;
            }
            return newTypes[index].getName();
        }

        public HelpCtx getHelpCtx(int index) {
            NewType[] newTypes = this.newTypes();
            if (newTypes.length <= index) {
                return null;
            }
            return newTypes[index].getHelpCtx();
        }

        public void performActionAt(int index) {
            NewType[] nt = this.newTypes();
            if (nt.length <= index) {
                return;
            }
            Node[] arr = this.lookup != null ? this.lookup.lookup(new Lookup.Template(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = NewAction.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node)).allInstances().toArray(new Node[0]) : WindowManager.getDefault().getRegistry().getCurrentNodes();
            NewAction.performAction(arr, nt[index]);
        }

        public void addChangeListener(ChangeListener l) {
            this.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = NewAction.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = NewAction.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
        }
    }
}

