/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.Invocation;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterClass;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKind;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.java.hints.CreateElementJavaHint;
import org.netbeans.modules.java.hints.DeclarationInfo;
import org.netbeans.modules.java.hints.PositionUtils;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class CreateMethodJavaHint
extends CreateElementJavaHint {
    private ClassDefinition javaClass;
    private static final Integer zero = new Integer(0);

    CreateMethodJavaHint(NamedElement symbol, ClassDefinition cls) {
        super(symbol);
        this.javaClass = cls;
        if (cls instanceof ParameterizedType) {
            this.javaClass = ((ParameterizedType)cls).getDefinition();
        }
        String signature = this.name + '(' + this.getParameters() + ')';
        this.hintText = NbBundle.getMessage((Class)CreateMethodJavaHint.class, (String)"MSG_CreateMethod", (Object)signature, (Object)cls.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeInfo implement() {
        Method newMethod;
        boolean bothInOneFile;
        boolean fail = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            JavaModel.setClassPath((Resource)this.unresolvedSymbol.getResource());
            Resource classRes = this.javaClass.getResource();
            Resource unresRes = this.unresolvedSymbol.getResource();
            bothInOneFile = classRes.equals(unresRes);
            Type fieldType = DeclarationInfo.computeType((Element)this.unresolvedSymbol);
            int modifiers = this.computeAccessModifiers(this.javaClass, unresRes);
            newMethod = this.createMethod(modifiers |= this.computeStaticModifier(this.unresolvedSymbol), fieldType);
            fail = false;
        }
        finally {
            JavaModel.getJavaRepository().endTrans(fail);
        }
        ChangeInfo ch = PositionUtils.selectFirstStatement(newMethod);
        if (!bothInOneFile) {
            this.addModified();
        }
        return ch;
    }

    private Method createMethod(int modifiers, Type type) {
        JavaModelPackage pac = (JavaModelPackage)this.javaClass.refImmediatePackage();
        TypeReference typeRef = JavaModelUtil.resolveImportsForType((Element)this.javaClass, (Type)type);
        List pars = this.createParams();
        String bodyText = this.createBody(type);
        Method method = pac.getMethod().createMethod(this.name, null, modifiers, null, null, null, bodyText, null, pars, null, typeRef, 0);
        List features = this.javaClass.getContents();
        int index = PositionUtils.getProposedMethodIndex(features);
        features.add(index, method);
        return method;
    }

    private String createBody(Type type) {
        String initVal;
        if (type instanceof PrimitiveType) {
            PrimitiveTypeKind primitiveType = ((PrimitiveType)type).getKind();
            if (PrimitiveTypeKindEnum.BOOLEAN.equals((Object)primitiveType)) {
                initVal = "false";
            } else if (PrimitiveTypeKindEnum.CHAR.equals((Object)primitiveType)) {
                initVal = "'\\0'";
            } else {
                if (PrimitiveTypeKindEnum.VOID.equals((Object)primitiveType)) {
                    return "throw new UnsupportedOperationException(\"Not yet implemented\");";
                }
                initVal = "0";
            }
        } else if (type instanceof ClassDefinition) {
            initVal = "null";
        } else {
            throw new IllegalArgumentException("Type " + type.getClass());
        }
        return "return ".concat(initVal).concat(";");
    }

    private List createParams() {
        JavaModelPackage pac = (JavaModelPackage)this.javaClass.refImmediatePackage();
        ParameterClass parProxy = pac.getParameter();
        Invocation inv = (Invocation)this.unresolvedSymbol;
        Expression[] parExprs = inv.getParameters().toArray(new Expression[0]);
        ArrayList<Parameter> parTypes = new ArrayList<Parameter>(parExprs.length);
        HashMap<String, Integer> names = new HashMap<String, Integer>();
        for (int i = 0; i < parExprs.length; ++i) {
            Type pType = parExprs[i].getType();
            pType = pType == null ? pac.getType().resolve("java.lang.Object") : CreateMethodJavaHint.getNamedType(pType);
            TypeReference typeRef = JavaModelUtil.resolveImportsForType((Element)this.javaClass, (Type)pType);
            String name = CreateMethodJavaHint.getName(parExprs[i], pType);
            Integer count = (Integer)names.get(name);
            if (count != null) {
                names.put(name, new Integer(count + 1));
                name = name.concat(count.toString());
            } else {
                names.put(name, zero);
            }
            Parameter par = parProxy.createParameter(name, null, false, typeRef, 0, false);
            parTypes.add(par);
        }
        return parTypes;
    }

    private static String getName(Expression parExpr, Type pType) {
        if (parExpr instanceof VariableAccess) {
            VariableAccess var = (VariableAccess)parExpr;
            return var.getName();
        }
        return CreateMethodJavaHint.getName(pType);
    }

    private static String getName(Type pType) {
        if (pType instanceof PrimitiveType) {
            return pType.getName().substring(0, 1);
        }
        if (pType instanceof JavaClass) {
            String name = ((JavaClass)pType).getSimpleName();
            String loweredName = name.substring(0, 1).toLowerCase().concat(name.substring(1));
            return Utilities.isJavaIdentifier((String)loweredName) ? loweredName : 'a' + name;
        }
        if (pType instanceof Array) {
            return CreateMethodJavaHint.getName(((Array)pType).getType());
        }
        throw new IllegalArgumentException("Uknow type " + pType.getClass());
    }

    private String getParameters() {
        Invocation inv = (Invocation)this.unresolvedSymbol;
        Expression[] parExprs = inv.getParameters().toArray(new Expression[0]);
        if (parExprs.length > 0) {
            StringBuffer text = new StringBuffer();
            for (int i = 0; i < parExprs.length; ++i) {
                Type pType = parExprs[i].getType();
                String typeName = pType != null ? CreateMethodJavaHint.getNamedType(pType).getName() : "java.lang.Object";
                text.append(typeName).append(',');
            }
            return text.substring(0, text.length() - 1);
        }
        return "";
    }

    private static Type getNamedType(Type pType) {
        if (pType instanceof ClassDefinition && pType.getName() == null) {
            ClassDefinition anonClass = (ClassDefinition)pType;
            JavaClass[] ifcs = anonClass.getInterfaces().toArray(new JavaClass[1]);
            pType = ifcs[0] != null ? ifcs[0] : anonClass.getSuperClass();
        }
        return pType;
    }
}

