/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ToolsAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.MethodElement;
import org.openide.src.nodes.ClassChildren;
import org.openide.src.nodes.ClassElementFilter;
import org.openide.src.nodes.ClassElementNode;
import org.openide.src.nodes.ConstructorElementNode;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.ElementNodeFactory;
import org.openide.src.nodes.FieldElementNode;
import org.openide.src.nodes.IconStrings;
import org.openide.src.nodes.InitializerElementNode;
import org.openide.src.nodes.MethodElementNode;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

public class DefaultFactory
implements ElementNodeFactory,
IconStrings {
    public static final DefaultFactory READ_WRITE = new DefaultFactory(true);
    public static final DefaultFactory READ_ONLY = new DefaultFactory(false);
    private static final Object CATEGORY_FIELDS = new Object();
    private static final Object CATEGORY_METHODS = new Object();
    private static final Object CATEGORY_CONSTRUCTORS = new Object();
    private static final Collection CLASS_CATEGORIES = new Vector(3, 0);
    private static final Collection INTERFACE_CATEGORIES;
    private static final int FILTER_CATEGORIES = 4096;
    private boolean writeable;
    private static final SystemAction[] CATEGORY_ACTIONS;
    static final int[][] FILTERS;
    static final String[] NAMES;
    static final String[] SHORTDESCRS;
    static final String[] CATEGORY_ICONS;

    public DefaultFactory(boolean writeable) {
        this.writeable = writeable;
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public Node createMethodNode(MethodElement element) {
        return new MethodElementNode(element, this.writeable);
    }

    public Node createConstructorNode(ConstructorElement element) {
        return new ConstructorElementNode(element, this.writeable);
    }

    public Node createFieldNode(FieldElement element) {
        return new FieldElementNode(element, this.writeable);
    }

    public Node createInitializerNode(InitializerElement element) {
        return new InitializerElementNode(element, this.writeable);
    }

    public Node createClassNode(ClassElement element) {
        return new ClassElementNode(element, this.createClassChildren(element), this.writeable);
    }

    protected Children createClassChildren(ClassElement element) {
        return this.createClassChildren(element, this.writeable ? READ_WRITE : READ_ONLY);
    }

    protected final Children createClassChildren(ClassElement element, ElementNodeFactory factory) {
        if (ElementNode.sourceOptions.getCategoriesUsage()) {
            CategorizingChildren children = new CategorizingChildren(factory, element, this.writeable);
            ClassElementFilter filter = new ClassElementFilter();
            filter.setOrder(new int[]{2, 4, 4096});
            children.setFilter(filter);
            return children;
        }
        return new ClassChildren(factory, element);
    }

    public Node createWaitNode() {
        AbstractNode n = new AbstractNode(Children.LEAF);
        n.setName(ElementNode.bundle.getString("Wait"));
        n.setIconBase("org/openide/src/resources/wait");
        return n;
    }

    public Node createErrorNode() {
        AbstractNode n = new AbstractNode(Children.LEAF);
        n.setName(ElementNode.bundle.getString("Error"));
        n.setIconBase("org/openide/src/resources/error");
        return n;
    }

    static {
        CLASS_CATEGORIES.add(CATEGORY_FIELDS);
        CLASS_CATEGORIES.add(CATEGORY_CONSTRUCTORS);
        CLASS_CATEGORIES.add(CATEGORY_METHODS);
        INTERFACE_CATEGORIES = new Vector(2, 0);
        INTERFACE_CATEGORIES.add(CATEGORY_FIELDS);
        INTERFACE_CATEGORIES.add(CATEGORY_METHODS);
        CATEGORY_ACTIONS = new SystemAction[]{SystemAction.get((Class)PasteAction.class), null, SystemAction.get((Class)NewAction.class), null, SystemAction.get((Class)ToolsAction.class), SystemAction.get((Class)PropertiesAction.class)};
        FILTERS = new int[][]{{16}, {8}, {32}};
        NAMES = new String[]{ElementNode.bundle.getString("Fields"), ElementNode.bundle.getString("Constructors"), ElementNode.bundle.getString("Methods")};
        SHORTDESCRS = new String[]{ElementNode.bundle.getString("Fields_HINT"), ElementNode.bundle.getString("Constructors_HINT"), ElementNode.bundle.getString("Methods_HINT")};
        CATEGORY_ICONS = new String[]{"org/openide/src/resources/variables", "org/openide/src/resources/constructors", "org/openide/src/resources/methods"};
    }

    static class ElementCategoryNode
    extends AbstractNode {
        ClassElement element;
        int newTypeIndex;

        ElementCategoryNode(int index, ElementNodeFactory factory, ClassElement element, boolean writeable) {
            this(index, new ClassChildren(factory, element));
            this.element = element;
            this.newTypeIndex = writeable ? index : -1;
            switch (index) {
                case 0: {
                    this.setName("Fields");
                    break;
                }
                case 1: {
                    this.setName("Constructors");
                    break;
                }
                case 2: {
                    this.setName("Methods");
                }
            }
        }

        private ElementCategoryNode(int index, ClassChildren children) {
            super((Children)children);
            this.setDisplayName(NAMES[index]);
            this.setShortDescription(SHORTDESCRS[index]);
            ClassElementFilter filter = new ClassElementFilter();
            filter.setOrder(FILTERS[index]);
            children.setFilter(filter);
            this.systemActions = CATEGORY_ACTIONS;
            this.setIconBase(CATEGORY_ICONS[index]);
        }

        public boolean canCopy() {
            return false;
        }

        public NewType[] getNewTypes() {
            if (!SourceEditSupport.isWriteable(this.element)) {
                return new NewType[0];
            }
            switch (this.newTypeIndex) {
                case 0: {
                    return new NewType[]{new SourceEditSupport.ElementNewType(this.element, 1)};
                }
                case 1: {
                    return new NewType[]{new SourceEditSupport.ElementNewType(this.element, 0), new SourceEditSupport.ElementNewType(this.element, 2)};
                }
                case 2: {
                    return new NewType[]{new SourceEditSupport.ElementNewType(this.element, 3)};
                }
            }
            return super.getNewTypes();
        }

        public void createPasteTypes(Transferable t, List s) {
            Node n = this.getParentNode();
            if (n == null || !(n instanceof ClassElementNode)) {
                return;
            }
            ((ClassElementNode)n).createPasteTypes(t, s);
        }
    }

    static class CategorizingChildren
    extends ClassChildren {
        boolean writeable;

        CategorizingChildren(ElementNodeFactory factory, ClassElement data, boolean wr) {
            super(factory, data);
            this.writeable = wr;
        }

        protected Node[] createNodes(Object key) {
            if (key == CATEGORY_FIELDS) {
                return new Node[]{new ElementCategoryNode(0, this.factory, this.element, this.writeable)};
            }
            if (key == CATEGORY_METHODS) {
                return new Node[]{new ElementCategoryNode(2, this.factory, this.element, this.writeable)};
            }
            if (key == CATEGORY_CONSTRUCTORS) {
                return new Node[]{new ElementCategoryNode(1, this.factory, this.element, this.writeable)};
            }
            return super.createNodes(key);
        }

        protected Collection getKeysOfType(int type) {
            if (type != 4096) {
                return super.getKeysOfType(type);
            }
            if (this.element.isClassOrInterface()) {
                return CLASS_CATEGORIES;
            }
            return INTERFACE_CATEGORIES;
        }

        static {
            ClassChildren.propToFilter.put("classOrInterface", new Integer(4096));
        }
    }
}

