/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.ActionFactory;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.MacroDialogSupport;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.editor.EditorModule;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorUI;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.NbToolTip;
import org.netbeans.modules.editor.PopupActions;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.FindAction;
import org.openide.actions.GotoAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PopupAction;
import org.openide.actions.RedoAction;
import org.openide.actions.ReplaceAction;
import org.openide.actions.UndoAction;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.JPopupMenuPlus;
import org.openide.awt.Mnemonics;
import org.openide.loaders.DataFolder;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class NbEditorKit
extends ExtKit {
    public static final String SYSTEM_ACTION_CLASS_NAME_PROPERTY = "systemActionClassName";
    static final long serialVersionUID = 4482122073483644089L;
    private static final Map contentTypeTable;
    public static final String generateGoToPopupAction = "generate-goto-popup";
    public static final String generateFoldPopupAction = "generate-fold-popup";
    private static final NbUndoAction nbUndoActionDef;
    private static final NbRedoAction nbRedoActionDef;
    private Map systemAction2editorAction = new HashMap();
    static /* synthetic */ Class class$org$netbeans$modules$editor$NbEditorKit;
    static /* synthetic */ Class class$org$netbeans$modules$editor$NbEditorKit$ToggleToolbarAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$BaseOptions;
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit;
    static /* synthetic */ Class class$org$netbeans$modules$editor$PopupActions;
    static /* synthetic */ Class class$org$openide$windows$TopComponent;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$openide$util$actions$SystemAction;
    static /* synthetic */ Class class$javax$swing$text$Keymap;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$MacrosEditorPanel;

    public NbEditorKit() {
        EditorModule.init();
        AllOptionsFolder aof = AllOptionsFolder.getDefault();
        if (aof != null) {
            aof.loadMIMEOption(((Object)((Object)this)).getClass());
        }
    }

    public Document createDefaultDocument() {
        NbEditorDocument doc = new NbEditorDocument(((Object)((Object)this)).getClass());
        Object mimeType = doc.getProperty("mimeType");
        if (mimeType == null) {
            doc.putProperty("mimeType", this.getContentType());
        }
        return doc;
    }

    protected void toolTipAnnotationsLock(Document doc) {
    }

    protected void toolTipAnnotationsUnlock(Document doc) {
    }

    protected EditorUI createEditorUI() {
        return new NbEditorUI();
    }

    protected Action[] createActions() {
        Action[] nbEditorActions = new Action[]{new NbBuildPopupMenuAction(), new NbStopMacroRecordingAction(), nbUndoActionDef, nbRedoActionDef, new NbBuildToolTipAction(), new NbToggleLineNumbersAction(), new ToggleToolbarAction(), new NbGenerateGoToPopupAction(), new GenerateFoldPopupAction()};
        return TextAction.augmentList(super.createActions(), nbEditorActions);
    }

    protected void addSystemActionMapping(String editorActionName, Class systemActionClass) {
        Action a = this.getActionByName(editorActionName);
        if (a != null) {
            a.putValue(SYSTEM_ACTION_CLASS_NAME_PROPERTY, systemActionClass.getName());
        }
        this.systemAction2editorAction.put(systemActionClass.getName(), editorActionName);
    }

    protected void updateActions() {
        this.addSystemActionMapping("cut-to-clipboard", CutAction.class);
        this.addSystemActionMapping("copy-to-clipboard", CopyAction.class);
        this.addSystemActionMapping("paste-from-clipboard", PasteAction.class);
        this.addSystemActionMapping("delete-next", DeleteAction.class);
        this.addSystemActionMapping("show-popup-menu", PopupAction.class);
        this.addSystemActionMapping("find", FindAction.class);
        this.addSystemActionMapping("replace", ReplaceAction.class);
        this.addSystemActionMapping("goto", GotoAction.class);
        this.addSystemActionMapping("undo", UndoAction.class);
        this.addSystemActionMapping("redo", RedoAction.class);
    }

    private boolean isInheritorOfNbEditorKit() {
        Class<?> clz = ((Object)((Object)this)).getClass();
        while (clz.getSuperclass() != null) {
            if ((class$org$netbeans$modules$editor$NbEditorKit == null ? NbEditorKit.class$("org.netbeans.modules.editor.NbEditorKit") : class$org$netbeans$modules$editor$NbEditorKit) != (clz = clz.getSuperclass())) continue;
            return true;
        }
        return false;
    }

    public String getContentType() {
        if (this.isInheritorOfNbEditorKit()) {
            ErrorManager.getDefault().log(16, "Warning: KitClass " + ((Object)((Object)this)).getClass().getName() + " doesn't override the method getContentType.");
        }
        return contentTypeTable.containsKey(((Object)((Object)this)).getClass().getName()) ? (String)contentTypeTable.get(((Object)((Object)this)).getClass().getName()) : "text/" + ((Object)((Object)this)).getClass().getName().replace('.', '_');
    }

    private static ResourceBundle getBundleFromName(String name) {
        ResourceBundle bundle = null;
        if (name != null) {
            try {
                bundle = NbBundle.getBundle((String)name);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return bundle;
    }

    static {
        nbUndoActionDef = new NbUndoAction();
        nbRedoActionDef = new NbRedoAction();
        contentTypeTable = new HashMap();
        contentTypeTable.put("org.netbeans.modules.properties.syntax.PropertiesKit", "text/x-properties");
        contentTypeTable.put("org.netbeans.modules.web.core.syntax.JSPKit", "text/x-jsp");
        contentTypeTable.put("org.netbeans.modules.css.text.syntax.CSSEditorKit", "text/css");
        contentTypeTable.put("org.netbeans.modules.xml.css.editor.CSSEditorKit", "text/css");
        contentTypeTable.put("org.netbeans.modules.xml.text.syntax.DTDKit", "text/x-dtd");
        contentTypeTable.put("org.netbeans.modules.xml.text.syntax.XMLKit", "text/xml");
        contentTypeTable.put("org.netbeans.modules.corba.idl.editor.coloring.IDLKit", "text/x-idl");
    }

    private static class LayerSubFolderMenu
    extends JMenu {
        private boolean addSeparatorBeforeNextAction;

        public LayerSubFolderMenu(JTextComponent target, String text, List items) {
            super(text);
            Mnemonics.setLocalizedText((AbstractButton)this, (String)text);
            for (int i = 0; i < items.size(); ++i) {
                Object obj = items.get(i);
                if (obj == null) {
                    this.addSeparator();
                    continue;
                }
                if (obj instanceof String) {
                    this.addAction(target, (JMenu)this, (String)obj);
                    continue;
                }
                if (!(obj instanceof Action)) continue;
                this.addAction(target, (JMenu)this, (Action)obj);
            }
        }

        private void addAcceleretors(Action a, JMenuItem item, JTextComponent target) {
            Keymap km;
            Keymap keymap = target == null ? BaseKit.getKit((Class)(class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = NbEditorKit.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit)).getKeymap() : (km = target.getKeymap());
            if (km != null) {
                KeyStroke ks;
                KeyStroke[] keys = km.getKeyStrokesForAction(a);
                if (keys != null && keys.length > 0) {
                    boolean added = false;
                    for (int i = 0; i < keys.length; ++i) {
                        if (keys[i].getKeyCode() != 106 && keys[i].getKeyCode() != 107) continue;
                        item.setAccelerator(keys[i]);
                        added = true;
                        break;
                    }
                    if (!added) {
                        item.setAccelerator(keys[0]);
                    }
                } else if (a != null && (ks = (KeyStroke)a.getValue("AcceleratorKey")) != null) {
                    item.setAccelerator(ks);
                }
            }
        }

        protected String getItemText(JTextComponent target, String actionName, Action a) {
            Object value;
            String itemText = a instanceof BaseAction ? ((BaseAction)a).getPopupMenuText(target) : ((value = a.getValue("PopupMenuText")) instanceof String ? (String)value : actionName);
            return itemText;
        }

        protected void addAction(JTextComponent target, JMenu menu, String actionName) {
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            if (kit == null) {
                return;
            }
            Action a = kit.getActionByName(actionName);
            if (a != null) {
                this.addAction(target, menu, a);
            } else {
                menu.addSeparator();
            }
        }

        protected void addAction(JTextComponent target, JMenu menu, Action a) {
            BaseKit kit;
            BaseKit baseKit = target == null ? BaseKit.getKit((Class)(class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = NbEditorKit.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit)) : (kit = Utilities.getKit((JTextComponent)target));
            if (!(kit instanceof BaseKit)) {
                kit = BaseKit.getKit((Class)(class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = NbEditorKit.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit));
                target = null;
            }
            if (kit == null) {
                return;
            }
            if (a != null) {
                String itemText;
                String actionName = (String)a.getValue("Name");
                JMenuItem item = null;
                if (a instanceof BaseAction) {
                    item = ((BaseAction)a).getPopupMenuItem(target);
                }
                if (item == null && (itemText = this.getItemText(target, actionName, a)) != null) {
                    item = new JMenuItem(itemText);
                    item.addActionListener(a);
                    Mnemonics.setLocalizedText((AbstractButton)item, (String)itemText);
                    this.addAcceleretors(a, item, target);
                    item.setEnabled(a.isEnabled());
                    Object helpID = a.getValue("helpID");
                    if (helpID != null && helpID instanceof String) {
                        item.putClientProperty("HelpID", helpID);
                    }
                }
                if (item != null) {
                    menu.add(item);
                }
            } else {
                menu.addSeparator();
            }
        }
    }

    public static class GenerateFoldPopupAction
    extends BaseAction {
        private boolean addSeparatorBeforeNextAction;

        public GenerateFoldPopupAction() {
            super(NbEditorKit.generateFoldPopupAction);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        protected Class getShortDescriptionBundleClass() {
            return class$org$netbeans$modules$editor$NbEditorKit == null ? (class$org$netbeans$modules$editor$NbEditorKit = NbEditorKit.class$("org.netbeans.modules.editor.NbEditorKit")) : class$org$netbeans$modules$editor$NbEditorKit;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
        }

        private void addAcceleretors(Action a, JMenuItem item, JTextComponent target) {
            KeyStroke[] keys;
            Keymap km;
            Keymap keymap = target == null ? BaseKit.getKit((Class)(class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = NbEditorKit.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit)).getKeymap() : (km = target.getKeymap());
            if (km != null && (keys = km.getKeyStrokesForAction(a)) != null && keys.length > 0) {
                boolean added = false;
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i].getKeyCode() != 106 && keys[i].getKeyCode() != 107) continue;
                    item.setAccelerator(keys[i]);
                    added = true;
                    break;
                }
                if (!added) {
                    item.setAccelerator(keys[0]);
                }
            }
        }

        protected String getItemText(JTextComponent target, String actionName, Action a) {
            String itemText = a instanceof BaseAction ? ((BaseAction)a).getPopupMenuText(target) : actionName;
            return itemText;
        }

        protected void addAction(JTextComponent target, JMenu menu, String actionName) {
            BaseKit kit;
            if (this.addSeparatorBeforeNextAction) {
                this.addSeparatorBeforeNextAction = false;
                menu.addSeparator();
            }
            BaseKit baseKit = target == null ? BaseKit.getKit((Class)(class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = NbEditorKit.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit)) : (kit = Utilities.getKit((JTextComponent)target));
            if (!(kit instanceof BaseKit)) {
                kit = BaseKit.getKit((Class)(class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = NbEditorKit.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit));
                target = null;
            }
            if (kit == null) {
                return;
            }
            boolean foldingEnabled = target == null ? false : (Boolean)Settings.getValue((Class)Utilities.getKitClass((JTextComponent)target), (String)"code-folding-enable");
            Action a = kit.getActionByName(actionName);
            if (a != null) {
                String itemText;
                JMenuItem item = null;
                if (a instanceof BaseAction) {
                    item = ((BaseAction)a).getPopupMenuItem(target);
                }
                if (item == null && (itemText = this.getItemText(target, actionName, a)) != null) {
                    item = new JMenuItem(itemText);
                    item.addActionListener(a);
                    Mnemonics.setLocalizedText((AbstractButton)item, (String)itemText);
                    this.addAcceleretors(a, item, target);
                    item.setEnabled(a.isEnabled() && foldingEnabled);
                    Object helpID = a.getValue("helpID");
                    if (helpID != null && helpID instanceof String) {
                        item.putClientProperty("HelpID", helpID);
                    }
                }
                if (item != null) {
                    menu.add(item);
                }
            } else {
                menu.addSeparator();
            }
        }

        protected void setAddSeparatorBeforeNextAction(boolean addSeparator) {
            this.addSeparatorBeforeNextAction = addSeparator;
        }

        protected void addAdditionalItems(JTextComponent target, JMenu menu) {
            this.setAddSeparatorBeforeNextAction(false);
        }

        public JMenuItem getPopupMenuItem(JTextComponent target) {
            String menuText = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$NbEditorKit == null ? (class$org$netbeans$modules$editor$NbEditorKit = NbEditorKit.class$("org.netbeans.modules.editor.NbEditorKit")) : class$org$netbeans$modules$editor$NbEditorKit)).getString("Menu/View/CodeFolds");
            JMenu menu = new JMenu(menuText);
            Mnemonics.setLocalizedText((AbstractButton)menu, (String)menuText);
            this.setAddSeparatorBeforeNextAction(false);
            this.addAction(target, menu, "collapse-fold");
            this.addAction(target, menu, "expand-fold");
            this.setAddSeparatorBeforeNextAction(true);
            this.addAction(target, menu, "collapse-all-folds");
            this.addAction(target, menu, "expand-all-folds");
            this.setAddSeparatorBeforeNextAction(true);
            if (target != null) {
                this.addAdditionalItems(target, menu);
            }
            return menu;
        }
    }

    public static class NbBuildToolTipAction
    extends ExtKit.BuildToolTipAction {
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                NbToolTip.buildToolTip(target);
            }
        }
    }

    public static class NbGenerateGoToPopupAction
    extends BaseAction {
        public NbGenerateGoToPopupAction() {
            super(NbEditorKit.generateGoToPopupAction);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
        }

        protected Class getShortDescriptionBundleClass() {
            return class$org$netbeans$modules$editor$NbEditorKit == null ? (class$org$netbeans$modules$editor$NbEditorKit = NbEditorKit.class$("org.netbeans.modules.editor.NbEditorKit")) : class$org$netbeans$modules$editor$NbEditorKit;
        }
    }

    public class NbToggleLineNumbersAction
    extends ActionFactory.ToggleLineNumbersAction {
        private boolean lineNumbersVisible = false;

        protected boolean isLineNumbersVisible() {
            return AllOptionsFolder.getDefault().getLineNumberVisible();
        }

        protected void toggleLineNumbers() {
            boolean numbersVisible = AllOptionsFolder.getDefault().getLineNumberVisible();
            AllOptionsFolder.getDefault().setLineNumberVisible(!numbersVisible);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            this.toggleLineNumbers();
        }
    }

    public static class NbRedoAction
    extends ActionFactory.RedoAction {
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            RedoAction ra = (RedoAction)SystemAction.get((Class)(class$org$openide$actions$RedoAction == null ? (class$org$openide$actions$RedoAction = NbEditorKit.class$("org.openide.actions.RedoAction")) : class$org$openide$actions$RedoAction));
            if (ra != null && ra.isEnabled()) {
                ra.actionPerformed(evt);
            }
        }
    }

    public static class NbUndoAction
    extends ActionFactory.UndoAction {
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            UndoAction ua = (UndoAction)SystemAction.get((Class)(class$org$openide$actions$UndoAction == null ? (class$org$openide$actions$UndoAction = NbEditorKit.class$("org.openide.actions.UndoAction")) : class$org$openide$actions$UndoAction));
            if (ua != null && ua.isEnabled()) {
                ua.actionPerformed(evt);
            }
        }
    }

    public class NbStopMacroRecordingAction
    extends ActionFactory.StopMacroRecordingAction {
        private BaseOptions bo;

        private Map getKBMap() {
            List list = this.bo.getKeyBindingList();
            if (list.size() > 0 && (list.get(0) instanceof Class || list.get(0) instanceof String)) {
                list.remove(0);
            }
            Map ret = OptionUtilities.makeKeyBindingsMap(list);
            return ret;
        }

        protected MacroDialogSupport getMacroDialogSupport(Class kitClass) {
            return new NbMacroDialogSupport(kitClass);
        }

        private class NbMacroDialogSupport
        extends MacroDialogSupport {
            public NbMacroDialogSupport(Class kitClass) {
                super(kitClass);
            }

            public void actionPerformed(ActionEvent evt) {
                NbStopMacroRecordingAction.this.bo = BaseOptions.getOptions(((Object)((Object)NbEditorKit.this)).getClass());
                Map oldMacroMap = null;
                Map oldKBMap = null;
                if (NbStopMacroRecordingAction.this.bo != null) {
                    oldMacroMap = NbStopMacroRecordingAction.this.bo.getMacroMap();
                    oldKBMap = NbStopMacroRecordingAction.this.getKBMap();
                }
                super.actionPerformed(evt);
                if (NbStopMacroRecordingAction.this.bo != null) {
                    Map newMacroMap = NbStopMacroRecordingAction.this.bo.getMacroMap();
                    NbStopMacroRecordingAction.this.bo.setMacroDiffMap(OptionUtilities.getMapDiff(oldMacroMap, newMacroMap, true));
                    NbStopMacroRecordingAction.this.bo.setKeyBindingsDiffMap(OptionUtilities.getMapDiff(oldKBMap, NbStopMacroRecordingAction.this.getKBMap(), true));
                    NbStopMacroRecordingAction.this.bo.setMacroMap(newMacroMap, false);
                    NbStopMacroRecordingAction.this.bo.setKeyBindingList(NbStopMacroRecordingAction.this.bo.getKeyBindingList(), false);
                }
            }

            protected int showConfirmDialog(String macroName) {
                NotifyDescriptor.Confirmation confirm = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$options$MacrosEditorPanel == null ? (class$org$netbeans$modules$editor$options$MacrosEditorPanel = NbEditorKit.class$("org.netbeans.modules.editor.options.MacrosEditorPanel")) : class$org$netbeans$modules$editor$options$MacrosEditorPanel), (String)"MEP_Overwrite", (Object)macroName), 1, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirm);
                return (Integer)confirm.getValue();
            }
        }
    }

    public class NbBuildPopupMenuAction
    extends ExtKit.BuildPopupMenuAction {
        static final long serialVersionUID = -8623762627678464181L;

        protected JPopupMenu createPopupMenu(JTextComponent component) {
            return new JPopupMenuPlus();
        }

        protected JPopupMenu buildPopupMenu(JTextComponent component) {
            JPopupMenu pm = this.createPopupMenu(component);
            HashMap notAddedFolders = new HashMap();
            EditorUI ui = Utilities.getEditorUI((JTextComponent)component);
            Object mimeTypeObj = component.getDocument().getProperty("mimeType");
            String mimeType = mimeTypeObj instanceof String ? (String)mimeTypeObj : NbEditorKit.this.getContentType();
            MimeLookup lookup = MimeLookup.getMimeLookup((String)mimeType);
            PopupActions pa = (PopupActions)lookup.lookup(class$org$netbeans$modules$editor$PopupActions == null ? (class$org$netbeans$modules$editor$PopupActions = NbEditorKit.class$("org.netbeans.modules.editor.PopupActions")) : class$org$netbeans$modules$editor$PopupActions);
            List l = pa != null ? pa.getPopupActions() : (List)Settings.getValue((Class)Utilities.getKitClass((JTextComponent)component), (String)(ui == null || ui.hasExtComponent() ? "popup-menu-action-name-list" : "dialog-popup-menu-action-name-list"));
            if (l != null) {
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    Object obj = i.next();
                    if (obj == null) continue;
                    if (obj instanceof Action) {
                        this.addAction(component, pm, (Action)obj);
                        continue;
                    }
                    if (obj instanceof JSeparator) {
                        this.addAction(component, pm, (String)null);
                        continue;
                    }
                    if (obj instanceof String) {
                        String actionName = (String)obj;
                        this.addAction(component, pm, actionName);
                        continue;
                    }
                    if (!(obj instanceof DataFolder)) continue;
                    DataFolder folder = (DataFolder)obj;
                    String folderName = folder.getName();
                    if (pa == null) continue;
                    String localizedName = null;
                    String bundleLocation = (String)folder.getPrimaryFile().getAttribute("SystemFileSystem.localizingBundle");
                    ResourceBundle bundle = NbEditorKit.getBundleFromName(bundleLocation);
                    if (bundle != null) {
                        try {
                            localizedName = bundle.getString(folderName);
                        }
                        catch (MissingResourceException mre) {
                            // empty catch block
                        }
                    }
                    LayerSubFolderMenu subMenu = new LayerSubFolderMenu(component, localizedName == null ? folderName : localizedName, pa.getPopupActions(folderName));
                    pm.add(subMenu);
                }
            }
            return pm;
        }

        private Lookup getContextLookup(Component component) {
            Lookup lookup = null;
            for (Component c = component; !(c == null || c instanceof Lookup.Provider && (lookup = ((Lookup.Provider)c).getLookup()) != null); c = c.getParent()) {
            }
            return lookup;
        }

        private Action translateContextLookupAction(Lookup contextLookup, Action action) {
            if (action instanceof ContextAwareAction && contextLookup != null) {
                action = ((ContextAwareAction)action).createContextAwareInstance(contextLookup);
            }
            return action;
        }

        private JMenuItem createLocalizedMenuItem(Action action) {
            JMenuItem item;
            if (action instanceof Presenter.Popup) {
                item = ((Presenter.Popup)action).getPopupPresenter();
            } else {
                item = new JMenuItem(action);
                Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
                if (item.getIcon() != null) {
                    item.setIcon(null);
                }
            }
            return item;
        }

        private void assignAccelerator(Keymap km, Action action, JMenuItem item) {
            if (item.getAccelerator() == null) {
                KeyStroke[] keys;
                KeyStroke ks = (KeyStroke)action.getValue("AcceleratorKey");
                if (ks != null) {
                    item.setAccelerator(ks);
                } else if (km != null && (keys = km.getKeyStrokesForAction(action)) != null && keys.length > 0) {
                    item.setAccelerator(keys[0]);
                }
            }
        }

        protected void addAction(JTextComponent component, JPopupMenu popupMenu, Action action) {
            Lookup contextLookup = this.getContextLookup(component);
            if (contextLookup == null && NbEditorKit.this.systemAction2editorAction.containsKey(action.getClass().getName())) {
                this.addAction(component, popupMenu, (String)NbEditorKit.this.systemAction2editorAction.get(action.getClass().getName()));
                return;
            }
            if ((action = this.translateContextLookupAction(contextLookup, action)) != null) {
                JMenuItem item = this.createLocalizedMenuItem(action);
                if (item instanceof DynamicMenuContent) {
                    JComponent[] cmps = ((DynamicMenuContent)item).getMenuPresenters();
                    for (int i = 0; i < cmps.length; ++i) {
                        popupMenu.add(cmps[i]);
                    }
                } else {
                    item.setEnabled(action.isEnabled());
                    Object helpID = action.getValue("helpID");
                    if (helpID != null && helpID instanceof String) {
                        item.putClientProperty("HelpID", helpID);
                    }
                    this.assignAccelerator(component.getKeymap(), action, item);
                    this.debugPopupMenuItem(item, action);
                    popupMenu.add(item);
                }
            }
        }

        private void addTopComponentActions(JTextComponent component, JPopupMenu popupMenu) {
            Lookup contextLookup = this.getContextLookup(component);
            TopComponent tc = NbEditorUtilities.getOuterTopComponent(component);
            if (tc != null) {
                Action[] actions = tc.getActions();
                Component[] comps = org.openide.util.Utilities.actionsToPopup((Action[])actions, (Lookup)contextLookup).getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    popupMenu.add(comps[i]);
                }
            }
        }

        protected void addAction(JTextComponent component, JPopupMenu popupMenu, String actionName) {
            if (actionName != null) {
                if ((class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = NbEditorKit.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent).getName().equals(actionName)) {
                    this.addTopComponentActions(component, popupMenu);
                    return;
                }
                Class<?> saClass = null;
                try {
                    ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = NbEditorKit.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                    saClass = Class.forName(actionName, false, loader);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (saClass != null && (class$org$openide$util$actions$SystemAction == null ? (class$org$openide$util$actions$SystemAction = NbEditorKit.class$("org.openide.util.actions.SystemAction")) : class$org$openide$util$actions$SystemAction).isAssignableFrom(saClass)) {
                    Lookup contextLookup = this.getContextLookup(component);
                    Object action = SystemAction.get(saClass);
                    JMenuItem item = this.createLocalizedMenuItem((Action)(action = this.translateContextLookupAction(contextLookup, (Action)action)));
                    if (item != null) {
                        if (item instanceof DynamicMenuContent) {
                            JComponent[] cmps = ((DynamicMenuContent)item).getMenuPresenters();
                            for (int i = 0; i < cmps.length; ++i) {
                                popupMenu.add(cmps[i]);
                            }
                        } else {
                            if (!(item instanceof JMenu)) {
                                this.assignAccelerator((Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? (class$javax$swing$text$Keymap = NbEditorKit.class$("javax.swing.text.Keymap")) : class$javax$swing$text$Keymap), (Action)action, item);
                            }
                            this.debugPopupMenuItem(item, (Action)action);
                            popupMenu.add(item);
                        }
                    }
                    return;
                }
            }
            super.addAction(component, popupMenu, actionName);
        }
    }

    public static class ToggleToolbarAction
    extends BaseAction {
        public ToggleToolbarAction() {
            super("toggle-toolbar");
            this.putValue("helpID", (class$org$netbeans$modules$editor$NbEditorKit$ToggleToolbarAction == null ? (class$org$netbeans$modules$editor$NbEditorKit$ToggleToolbarAction = NbEditorKit.class$("org.netbeans.modules.editor.NbEditorKit$ToggleToolbarAction")) : class$org$netbeans$modules$editor$NbEditorKit$ToggleToolbarAction).getName());
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            boolean toolbarVisible = AllOptionsFolder.getDefault().isToolbarVisible();
            AllOptionsFolder.getDefault().setToolbarVisible(!toolbarVisible);
        }

        public JMenuItem getPopupMenuItem(JTextComponent target) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$options$BaseOptions == null ? (class$org$netbeans$modules$editor$options$BaseOptions = NbEditorKit.class$("org.netbeans.modules.editor.options.BaseOptions")) : class$org$netbeans$modules$editor$options$BaseOptions)).getString("PROP_base_toolbarVisible"), AllOptionsFolder.getDefault().isToolbarVisible());
            item.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ToggleToolbarAction.this.actionPerformed(null, null);
                }
            });
            return item;
        }

        protected Class getShortDescriptionBundleClass() {
            return class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = NbEditorKit.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit;
        }
    }
}

